/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.featurereg.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FeatureRegistryHelper {
    private String features_dir_path = null;
    protected DocumentBuilderFactory dfactory = null;
    protected DocumentBuilder docBuilder = null;
    protected Document featureDocument = null;
    private String plugin_tag = "plugin";
    private String id_tag = "id";
    private String uri_tag = "uri";
    private String plugin_xml = "plugin.xml";
    private String feature_xml = "feature.xml";

    public FeatureRegistryHelper() {
        try {
            this.dfactory = DocumentBuilderFactory.newInstance();
            this.dfactory.setNamespaceAware(false);
            this.dfactory.setValidating(false);
            this.docBuilder = this.dfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Exception in creating docBuilder " + parserConfigurationException.toString());
        }
        this.features_dir_path = System.getProperty("was.install.root") + File.separator + "features";
    }

    public boolean isFeatureDirValid(String string) {
        boolean bl = false;
        String string2 = this.features_dir_path + File.separator + string;
        File file = new File(string2);
        if (file.isDirectory()) {
            bl = true;
        }
        return bl;
    }

    public void addPluginToRegistry(String string, String string2) {
        String string3 = this.features_dir_path + File.separator + string + File.separator + this.feature_xml;
        try {
            FileInputStream fileInputStream = new FileInputStream(string3);
            this.featureDocument = this.docBuilder.parse(fileInputStream);
            Element element = this.featureDocument.getDocumentElement();
            NodeList nodeList = this.featureDocument.getElementsByTagName(this.plugin_tag);
            boolean bl = false;
            Element element2 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                element2 = (Element)element3.cloneNode(true);
                String string4 = element3.getAttribute("id");
                if (!string4.equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (element2 != null) {
                    element2.setAttribute(this.id_tag, string2);
                    element2.setAttribute(this.uri_tag, string2 + "/" + this.plugin_xml);
                    element.appendChild(element2);
                    this.writeFeatureXmlFile(this.featureDocument, string3);
                }
            } else {
                System.out.println("Plugin is already present in feature.xml located at " + string3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in addPluginToRegistry " + exception.toString());
            System.out.println("Problem occured while adding plugin to feature.xml located at  " + string3 + "add plugin manually to the feature.xml");
            exception.printStackTrace();
        }
    }

    public void removePluginFromRegistry(String string, String string2) {
        String string3 = this.features_dir_path + File.separator + string + File.separator + this.feature_xml;
        try {
            FileInputStream fileInputStream = new FileInputStream(string3);
            this.featureDocument = this.docBuilder.parse(fileInputStream);
            Element element = this.featureDocument.getDocumentElement();
            NodeList nodeList = this.featureDocument.getElementsByTagName(this.plugin_tag);
            boolean bl = false;
            Element element2 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string4 = element3.getAttribute("id");
                if (!string4.equals(string2)) continue;
                bl = true;
                element2 = element3;
                break;
            }
            if (bl) {
                element.removeChild(element2);
                this.writeFeatureXmlFile(this.featureDocument, string3);
            } else {
                System.out.println("Plugin cannnot be removed as it is not present in feature.xml located at " + string3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in removePluginToRegistry " + exception.toString());
            System.out.println("Problem occured while removing plugin from feature.xml located at  " + string3 + "remove plugin manually from the feature.xml");
            exception.printStackTrace();
        }
    }

    private void writeFeatureXmlFile(Document document, String string) {
        try {
            Element element = document.getDocumentElement();
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndent(5);
            outputFormat.setIndenting(true);
            outputFormat.setPreserveSpace(false);
            outputFormat.setOmitDocumentType(false);
            XMLSerializer xMLSerializer = null;
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            xMLSerializer = new XMLSerializer((Writer)bufferedWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(element);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in addPluginToRegistry " + exception.toString());
            exception.printStackTrace();
        }
    }
}

