/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi;

import com.ibm.ws.ConfigurationElement;
import com.ibm.ws.ConfigurationProperty;
import com.ibm.ws.Extension;
import com.ibm.ws.ExtensionPoint;
import com.ibm.ws.PluginDescriptor;
import com.ibm.ws.PluginPrerequisite;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler {
    protected static final Logger logger = Logger.getLogger(PluginParser.class.getName());
    String locationName = null;
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    private SAXParser saxParser;
    private XMLReader xmlReader;
    Locator locator = null;
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_REQUIRES_STATE = 3;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 4;
    private static final int PLUGIN_EXTENSION_STATE = 5;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 7;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private Vector[] scratchVectors = new Vector[2];

    public PluginParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(false);
            this.saxParser = sAXParserFactory.newSAXParser();
            this.xmlReader = this.saxParser.getXMLReader();
            this.xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.xmlReader.setEntityResolver(this);
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setDTDHandler(this);
            this.xmlReader.setErrorHandler(this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.logp(Level.SEVERE, PluginParser.class.getName(), "constructor", "parser with specified options can't be build");
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            logger.logp(Level.SEVERE, PluginParser.class.getName(), "constructor", "error generated during parsing creation");
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = (Integer)this.stateStack.peek();
        if (n3 != 7) {
            return;
        }
        if (n3 == 7) {
            ConfigurationElement configurationElement = (ConfigurationElement)this.objectStack.peek();
            String string = new String(cArray, n, n2);
            String string2 = configurationElement.getValue();
            if (string2 == null) {
                if (string.trim().length() != 0) {
                    configurationElement.setValue(string);
                }
            } else {
                configurationElement.setValue(string2 + string);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String string, String string2, String string3) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                logger.logp(Level.SEVERE, PluginParser.class.getName(), "endElement", "internal stack structure error on element " + string3);
                break;
            }
            case 2: {
                Vector vector;
                if (!string3.equals("plugin")) break;
                this.stateStack.pop();
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this.objectStack.peek();
                Vector vector2 = this.scratchVectors[0];
                if (vector2.size() > 0) {
                    pluginDescriptor.setDeclaredExtensionPoints(vector2.toArray(new ExtensionPoint[vector2.size()]));
                    this.scratchVectors[0].removeAllElements();
                }
                if ((vector = this.scratchVectors[1]).size() <= 0) break;
                pluginDescriptor.setDeclaredExtensions(vector.toArray(new Extension[vector.size()]));
                this.scratchVectors[1].removeAllElements();
                break;
            }
            case 3: {
                if (!string3.equals("requires")) break;
                this.stateStack.pop();
                Vector vector = (Vector)this.objectStack.pop();
                if (vector.size() <= 0) break;
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this.objectStack.peek();
                pluginDescriptor.setRequires(vector.toArray(new PluginPrerequisite[vector.size()]));
                break;
            }
            case 4: {
                if (!string3.equals("extension-point")) break;
                this.stateStack.pop();
                break;
            }
            case 5: {
                if (!string3.equals("extension")) break;
                this.stateStack.pop();
                Extension extension = (Extension)this.objectStack.pop();
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this.objectStack.peek();
                extension.setParentDescriptor(pluginDescriptor);
                this.scratchVectors[1].addElement(extension);
                break;
            }
            case 6: {
                if (!string3.equals("import")) break;
                this.stateStack.pop();
                break;
            }
            case 7: {
                this.stateStack.pop();
                ConfigurationElement configurationElement = (ConfigurationElement)this.objectStack.pop();
                String string4 = configurationElement.getValue();
                if (string4 != null) {
                    configurationElement.setValue(string4.trim());
                }
                Object e = this.objectStack.peek();
                configurationElement.setParent(e);
                if ((Integer)this.stateStack.peek() == 5) {
                    ConfigurationElement[] configurationElementArray = ((Extension)e).getElements();
                    int n = configurationElementArray == null ? 0 : configurationElementArray.length;
                    ConfigurationElement[] configurationElementArray2 = new ConfigurationElement[n + 1];
                    for (int i = 0; i < n; ++i) {
                        configurationElementArray2[i] = configurationElementArray[i];
                    }
                    configurationElementArray2[n] = configurationElement;
                    ((Extension)e).setElements(configurationElementArray2);
                    break;
                }
                ConfigurationElement[] configurationElementArray = ((ConfigurationElement)e).getSubElements();
                int n = configurationElementArray == null ? 0 : configurationElementArray.length;
                ConfigurationElement[] configurationElementArray3 = new ConfigurationElement[n + 1];
                for (int i = 0; i < n; ++i) {
                    configurationElementArray3[i] = configurationElementArray[i];
                }
                configurationElementArray3[n] = configurationElement;
                ((ConfigurationElement)e).setSubElements(configurationElementArray3);
            }
        }
    }

    public void error(SAXParseException sAXParseException) {
        if (!sAXParseException.getMessage().startsWith("Element type") && !sAXParseException.getMessage().endsWith("must be declared")) {
            logger.logp(Level.SEVERE, PluginParser.class.getName(), "error", "error parsing file " + sAXParseException.getSystemId() + ", " + sAXParseException.getLineNumber());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.logp(Level.SEVERE, PluginParser.class.getName(), "fatalError", "error parsing file " + sAXParseException.getSystemId() + ", " + sAXParseException.getLineNumber());
    }

    public void handleExtensionPointState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        logger.logp(Level.CONFIG, PluginParser.class.getName(), "handleExtensionPointState", "ignored " + string);
    }

    public void handleExtensionState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(7));
        ConfigurationElement configurationElement = new ConfigurationElement();
        this.objectStack.push(configurationElement);
        configurationElement.setName(string);
        this.parseConfigurationElementAttributes(attributes);
    }

    public void handleInitialState(String string, Attributes attributes) {
        if (string.equals("plugin")) {
            this.stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else {
            this.stateStack.push(new Integer(0));
            logger.logp(Level.CONFIG, PluginParser.class.getName(), "handleInitialState", "unknows root element " + string);
        }
    }

    protected static String[] getArrayFromList(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? null : vector.toArray(new String[0]);
    }

    public void handlePluginState(String string, Attributes attributes) {
        if (string.equals("requires")) {
            this.stateStack.push(new Integer(3));
            this.objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (string.equals("extension-point")) {
            this.stateStack.push(new Integer(4));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (string.equals("extension")) {
            this.stateStack.push(new Integer(5));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
    }

    public void handleRequiresImportState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
    }

    public void handleRequiresState(String string, Attributes attributes) {
        if (string.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
    }

    public void ignoreableWhitespace(char[] cArray, int n, int n2) {
    }

    public synchronized PluginDescriptor parsePlugin(InputSource inputSource) {
        if (inputSource.getSystemId() != null) {
            this.locationName = inputSource.getSystemId();
        }
        try {
            this.xmlReader.parse(inputSource);
            return (PluginDescriptor)this.objectStack.pop();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (EmptyStackException emptyStackException) {
            emptyStackException.printStackTrace();
            return null;
        }
    }

    public void parseConfigurationElementAttributes(Attributes attributes) {
        int n;
        ConfigurationElement configurationElement = (ConfigurationElement)this.objectStack.peek();
        configurationElement.setStartLine(this.locator.getLineNumber());
        Vector<ConfigurationProperty> vector = null;
        int n2 = n = attributes != null ? attributes.getLength() : 0;
        if (n == 0) {
            return;
        }
        vector = new Vector<ConfigurationProperty>();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            ConfigurationProperty configurationProperty = new ConfigurationProperty();
            configurationProperty.setName(string);
            configurationProperty.setValue(string2);
            vector.addElement(configurationProperty);
        }
        configurationElement.setProperties(vector.toArray(new ConfigurationProperty[vector.size()]));
        vector = null;
    }

    public void parseExtensionAttributes(Attributes attributes) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.objectStack.peek();
        Extension extension = new Extension();
        extension.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(extension);
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("id")) {
                extension.setSimpleId(string2);
                continue;
            }
            if (string.equals("point")) {
                String string3;
                if (string2.lastIndexOf(46) == -1) {
                    String string4 = pluginDescriptor.getUniqueIdentifier();
                    string3 = string4 + "." + string2;
                } else {
                    string3 = string2;
                }
                extension.setExtensionPointUniqueId(string3);
                continue;
            }
            if (!string.equals("name")) continue;
            extension.setName(string2);
        }
    }

    public void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint extensionPoint = new ExtensionPoint();
        extensionPoint.setStartLine(this.locator.getLineNumber());
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("id")) {
                extensionPoint.setSimpleId(string2);
                continue;
            }
            if (string.equals("schema")) {
                extensionPoint.setSchema(string2);
                continue;
            }
            if (!string.equals("name")) continue;
            extensionPoint.setName(string2);
        }
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.objectStack.peek();
        extensionPoint.setParentDescriptor(pluginDescriptor);
        this.scratchVectors[0].addElement(extensionPoint);
    }

    public void parsePluginAttributes(Attributes attributes) {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(pluginDescriptor);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("id")) {
                pluginDescriptor.setUniqueIdentifier(string2);
                continue;
            }
            if (string.equals("version")) {
                pluginDescriptor.setVersion(string2);
                continue;
            }
            if (string.equals("vendor-name")) {
                pluginDescriptor.setProviderName(string2);
                continue;
            }
            if (string.equals("name")) {
                pluginDescriptor.setName(string2);
                continue;
            }
            if (!string.equals("embedded") && !string.equals("context-root")) continue;
        }
    }

    public void parsePluginRequiresImport(Attributes attributes) {
        PluginPrerequisite pluginPrerequisite = new PluginPrerequisite();
        pluginPrerequisite.setStartLine(this.locator.getLineNumber());
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("plugin")) {
                pluginPrerequisite.setUniqueIdentifier(string2);
                continue;
            }
            if (string.equals("version")) {
                pluginPrerequisite.setVersion(string2);
                continue;
            }
            if (!string.equals("match")) continue;
            if ("exact".equals(string2)) {
                pluginPrerequisite.setMatch("exact");
                continue;
            }
            if ("compatible".equals(string2)) {
                pluginPrerequisite.setMatch("compatible");
                continue;
            }
            if (!"greaterOrEqual".equals(string2)) continue;
            pluginPrerequisite.setMatch("greaterOrEqual");
        }
        ((Vector)this.objectStack.peek()).addElement(pluginPrerequisite);
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    static String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string2.length();
        int n2 = string3.length();
        int n3 = string4.indexOf(string2);
        while (n3 != -1) {
            string4 = string4.substring(0, n3) + string3 + string4.substring(n3 + n);
            n3 = string4.indexOf(string2, n3 + n2);
        }
        return string4;
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
        for (int i = 0; i <= 1; ++i) {
            this.scratchVectors[i] = new Vector();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(string3, attributes);
                break;
            }
            case 2: {
                this.handlePluginState(string3, attributes);
                break;
            }
            case 3: {
                this.handleRequiresState(string3, attributes);
                break;
            }
            case 4: {
                this.handleExtensionPointState(string3, attributes);
                break;
            }
            case 5: 
            case 7: {
                this.handleExtensionState(string3, attributes);
                break;
            }
            case 6: {
                this.handleRequiresImportState(string3, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
            }
        }
    }

    public void warning(SAXParseException sAXParseException) {
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        if (string2 == null) {
            return null;
        }
        string2 = "plugin.dtd";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new FileNotFoundException("<PluginParser><resolveEntity> entity not found in classpath: " + string2);
        }
        return new InputSource(inputStream);
    }

    public void releaseParser() {
        this.saxParser = null;
    }
}

