/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class PluginVersionIdentifier {
    protected static final Logger logger = Logger.getLogger(PluginVersionIdentifier.class.getName());
    private int major = 0;
    private int minor = 0;
    private int service = 0;
    private static String SEPARATOR = ".";

    public int getMajorComponent() {
        return this.major;
    }

    public int getMinorComponent() {
        return this.minor;
    }

    public int getServiceComponent() {
        return this.service;
    }

    public boolean isCompatibleWith(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return false;
        }
        if (this.major != pluginVersionIdentifier.getMajorComponent()) {
            return false;
        }
        if (this.minor > pluginVersionIdentifier.getMinorComponent()) {
            return true;
        }
        if (this.minor < pluginVersionIdentifier.getMinorComponent()) {
            return false;
        }
        if (this.service > pluginVersionIdentifier.getServiceComponent()) {
            return true;
        }
        return this.service >= pluginVersionIdentifier.getServiceComponent();
    }

    public boolean isEquivalentTo(PluginVersionIdentifier pluginVersionIdentifier) {
        return this.major == pluginVersionIdentifier.getMajorComponent() && this.minor == pluginVersionIdentifier.getMinorComponent() && this.service == pluginVersionIdentifier.getServiceComponent();
    }

    public boolean isGreaterOrEqualTo(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return false;
        }
        if (this.major > pluginVersionIdentifier.getMajorComponent()) {
            return true;
        }
        if (this.major == pluginVersionIdentifier.getMajorComponent() && this.minor > pluginVersionIdentifier.getMinorComponent()) {
            return true;
        }
        return this.major == pluginVersionIdentifier.getMajorComponent() && this.minor == pluginVersionIdentifier.getMinorComponent() && this.service >= pluginVersionIdentifier.getServiceComponent();
    }

    public String toString() {
        return this.major + SEPARATOR + this.minor + SEPARATOR + this.service;
    }

    public PluginVersionIdentifier(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.service = n3;
    }

    public PluginVersionIdentifier(String string) {
        Integer[] integerArray = PluginVersionIdentifier.parseVersion(string);
        this.major = integerArray[0];
        this.minor = integerArray[1];
        this.service = integerArray[2];
    }

    public static Integer[] parseVersion(String string) {
        String string2;
        if (string == null) {
            logger.info("versionId is null");
        }
        if ((string2 = string.trim()).equals("")) {
            logger.info("versionId is empty");
        }
        if (string2.startsWith(SEPARATOR)) {
            logger.info("versionId starts with separator");
        }
        if (string2.endsWith(SEPARATOR)) {
            logger.info("versionId ends with separator");
        }
        if (string2.indexOf(SEPARATOR + SEPARATOR) != -1) {
            logger.info("versionId is malformed");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SEPARATOR);
        Vector<String> vector = new Vector<String>(3);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        if (n <= 0) {
            logger.info("zero elements in version");
        }
        if (n > 3) {
            logger.info("over three elements in version");
        }
        int[] nArray = new int[3];
        try {
            nArray[0] = Integer.parseInt((String)vector.elementAt(0));
            if (nArray[0] < 0) {
                logger.info("major is less than zero");
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.info("major is not numerical");
        }
        try {
            if (n >= 2) {
                nArray[1] = Integer.parseInt((String)vector.elementAt(1));
                if (nArray[1] < 0) {
                    logger.info("minor is less than zero");
                }
            } else {
                nArray[1] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.info("minor is not numerical");
        }
        try {
            if (n >= 3) {
                nArray[2] = Integer.parseInt((String)vector.elementAt(2));
                if (nArray[2] < 0) {
                    logger.info("service is less than zero");
                }
            } else {
                nArray[2] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.info("service is not numerical");
        }
        Integer[] integerArray = new Integer[]{new Integer(nArray[0]), new Integer(nArray[1]), new Integer(nArray[2])};
        return integerArray;
    }

    public boolean equals(PluginVersionIdentifier pluginVersionIdentifier) {
        return this.major == pluginVersionIdentifier.getMajorComponent() && this.minor == pluginVersionIdentifier.getMinorComponent() && this.service == pluginVersionIdentifier.getServiceComponent();
    }
}

