/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi;

import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.PluginDescriptor;
import com.ibm.ws.PluginRegistry;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.wsspi.PluginParser;
import com.ibm.wsspi.RegistryResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.xml.sax.InputSource;

public class RegistryLoader {
    protected static final Logger logger = Logger.getLogger(RegistryLoader.class.getName());
    PluginParser parser = new PluginParser();
    String[] pluginPaths = null;
    public static final String JNDIlocation = "com.ibm.isc/PluginRegistry";

    public RegistryLoader(String[] stringArray) {
        this.pluginPaths = stringArray;
    }

    public RegistryLoader(URI[] uRIArray) {
        this.pluginPaths = new String[uRIArray.length];
        for (int i = 0; i < uRIArray.length; ++i) {
            this.pluginPaths[i] = uRIArray[i].getPath();
        }
    }

    public RegistryLoader(File[] fileArray) {
        this.pluginPaths = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            this.pluginPaths[i] = fileArray[i].getPath();
        }
    }

    public RegistryLoader() {
    }

    public synchronized void loadRegistry() {
        PluginRegistry pluginRegistry = this.parseRegistry();
        if (pluginRegistry != null) {
            RegistryResolver registryResolver = new RegistryResolver();
            registryResolver.resolve(pluginRegistry);
        }
        this.rebindRegistry(pluginRegistry);
    }

    public synchronized void rebindRegistry(final PluginRegistry pluginRegistry) {
        if (pluginRegistry != null) {
            try {
                SecurityContext.runAsSystem((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            InitialContext initialContext = RegistryLoader.this.getInitialContext();
                            JndiHelper.recursiveRebind((Context)initialContext, (String)RegistryLoader.JNDIlocation, (Object)pluginRegistry);
                        }
                        catch (NamingException namingException) {
                            logger.info("jndi naming error");
                            namingException.printStackTrace();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                logger.info("privilege error");
                privilegedActionException.printStackTrace();
            }
        } else {
            logger.info("registry null, cannot rebind");
        }
    }

    public synchronized void unloadRegistry() {
        try {
            InitialContext initialContext = this.getInitialContext();
            initialContext.unbind(JNDIlocation);
        }
        catch (NamingException namingException) {
            logger.info("jndi error");
            namingException.printStackTrace();
        }
    }

    public synchronized void removePlugin(String string) {
        PluginRegistry pluginRegistry;
        try {
            pluginRegistry = this.getPluginRegistry();
        }
        catch (NamingException namingException) {
            logger.info("jndi error");
            return;
        }
        if (pluginRegistry == null) {
            return;
        }
        pluginRegistry.removePlugin(string);
        RegistryResolver registryResolver = new RegistryResolver();
        registryResolver.resolve(pluginRegistry);
        this.rebindRegistry(pluginRegistry);
    }

    public synchronized PluginRegistry loadRegistryLocal() {
        PluginRegistry pluginRegistry = this.parseRegistry();
        if (pluginRegistry != null) {
            RegistryResolver registryResolver = new RegistryResolver();
            registryResolver.resolve(pluginRegistry);
        }
        this.parser.releaseParser();
        return pluginRegistry == null ? null : pluginRegistry;
    }

    public boolean canBeAddedToRegistry(InputStream inputStream) {
        InputSource inputSource = new InputSource(inputStream);
        PluginDescriptor pluginDescriptor = this.parser.parsePlugin(inputSource);
        if (pluginDescriptor != null) {
            RegistryResolver registryResolver = new RegistryResolver();
            return registryResolver.requiredPluginDescriptor(pluginDescriptor);
        }
        return false;
    }

    public PluginRegistry getPluginRegistry() throws NamingException {
        PluginRegistry pluginRegistry = null;
        InitialContext initialContext = this.getInitialContext();
        pluginRegistry = (PluginRegistry)initialContext.lookup(JNDIlocation);
        if (pluginRegistry == null) {
            logger.info("registry null");
        }
        return pluginRegistry;
    }

    private PluginRegistry parseRegistry() {
        PluginRegistry pluginRegistry;
        try {
            pluginRegistry = this.getPluginRegistry();
        }
        catch (NamingException namingException) {
            logger.finest("jndi lookup failed");
            logger.finest("creating new registry");
            pluginRegistry = new PluginRegistry();
        }
        if (pluginRegistry == null) {
            pluginRegistry = new PluginRegistry();
        }
        if (this.pluginPaths != null) {
            for (int i = 0; i < this.pluginPaths.length; ++i) {
                boolean bl = this.validatePluginPath(this.pluginPaths[i]);
                if (!bl) continue;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(this.pluginPaths[i]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.finest("plugin.xml file not found");
                }
                InputSource inputSource = new InputSource(fileInputStream);
                inputSource.setSystemId(this.pluginPaths[i]);
                PluginDescriptor pluginDescriptor = this.parser.parsePlugin(inputSource);
                if (pluginDescriptor == null) continue;
                pluginRegistry.addPlugin(pluginDescriptor);
            }
        }
        return pluginRegistry;
    }

    private boolean validatePluginPath(String string) {
        File file = null;
        file = new File(string);
        return file == null ? false : file.exists();
    }

    private InitialContext getInitialContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.provider.url", "corbaloc:rir:/NameServiceServerRoot");
        hashtable.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        InitialContext initialContext = new InitialContext(hashtable);
        return initialContext;
    }
}

