/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi;

import com.ibm.ws.Extension;
import com.ibm.ws.ExtensionPoint;
import com.ibm.ws.PluginDescriptor;
import com.ibm.ws.PluginPrerequisite;
import com.ibm.ws.PluginRegistry;
import com.ibm.wsspi.PluginVersionIdentifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class RegistryResolver {
    private static String SEPARATOR = ".";
    private PluginRegistry reg;

    private boolean resolveVersion(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return false;
        }
        if (string2.startsWith(SEPARATOR)) {
            return false;
        }
        if (string2.endsWith(SEPARATOR)) {
            return false;
        }
        if (string2.indexOf(SEPARATOR + SEPARATOR) != -1) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SEPARATOR);
        Vector<String> vector = new Vector<String>(3);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        if (n <= 0) {
            return false;
        }
        if (n > 3) {
            return false;
        }
        int[] nArray = new int[3];
        try {
            nArray[0] = Integer.parseInt((String)vector.elementAt(0));
            if (nArray[0] < 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        try {
            if (n >= 2) {
                nArray[1] = Integer.parseInt((String)vector.elementAt(1));
                if (nArray[1] < 0) {
                    return false;
                }
            } else {
                nArray[1] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        try {
            if (n >= 3) {
                nArray[2] = Integer.parseInt((String)vector.elementAt(2));
                if (nArray[2] < 0) {
                    return false;
                }
            } else {
                nArray[2] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public ExtensionPoint getExtensionPoint(PluginDescriptor pluginDescriptor, String string) {
        if (string == null) {
            return null;
        }
        ExtensionPoint[] extensionPointArray = pluginDescriptor.getDeclaredExtensionPoints();
        if (extensionPointArray == null) {
            return null;
        }
        for (int i = 0; i < extensionPointArray.length; ++i) {
            if (!string.equals(extensionPointArray[i].getSimpleIdentifier())) continue;
            return extensionPointArray[i];
        }
        return null;
    }

    private void resolve() {
        int n;
        PluginDescriptor[] pluginDescriptorArray = this.reg.getPlugins();
        if (pluginDescriptorArray == null || pluginDescriptorArray.length == 0) {
            return;
        }
        ArrayList<PluginDescriptor> arrayList = new ArrayList<PluginDescriptor>(pluginDescriptorArray.length);
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            n = this.requiredPluginDescriptor(pluginDescriptorArray[i]);
            if (n == 0) continue;
            arrayList.add(pluginDescriptorArray[i]);
        }
        PluginDescriptor[] pluginDescriptorArray2 = arrayList.toArray(new PluginDescriptor[arrayList.size()]);
        for (n = 0; n < pluginDescriptorArray2.length; ++n) {
            this.resolvePluginDescriptorPrereqs(pluginDescriptorArray2[n]);
        }
        ArrayList<PluginDescriptor> arrayList2 = new ArrayList<PluginDescriptor>(pluginDescriptorArray2.length);
        for (int i = 0; i < pluginDescriptorArray2.length; ++i) {
            this.resolveAllPrereqsAreActive(pluginDescriptorArray2[i]);
            this.resolvePluginDescriptorExtensions(pluginDescriptorArray2[i]);
            arrayList2.add(pluginDescriptorArray2[i]);
        }
        if (arrayList2.size() == 0) {
            this.reg.clear();
        }
        if (arrayList2.size() < pluginDescriptorArray.length) {
            this.reg.clear();
            PluginDescriptor[] pluginDescriptorArray3 = arrayList2.toArray(new PluginDescriptor[arrayList2.size()]);
            for (int i = 0; i < pluginDescriptorArray3.length; ++i) {
                this.reg.addPlugin(pluginDescriptorArray3[i]);
            }
        }
    }

    public void resolve(PluginRegistry pluginRegistry) {
        this.reg = pluginRegistry;
        this.resolve();
    }

    private boolean resolveExtension(Extension extension) {
        String string = extension.getExtensionPointUniqueId();
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PluginDescriptor pluginDescriptor = this.reg.getPlugin(string2);
        if (pluginDescriptor == null) {
            return false;
        }
        if (!pluginDescriptor.isActive()) {
            return false;
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(pluginDescriptor, string3);
        if (extensionPoint == null) {
            return false;
        }
        Extension[] extensionArray = extensionPoint.getExtensions();
        Extension[] extensionArray2 = null;
        if (extensionArray == null) {
            extensionArray2 = new Extension[1];
        } else {
            extensionArray2 = new Extension[extensionArray.length + 1];
            System.arraycopy(extensionArray, 0, extensionArray2, 0, extensionArray.length);
        }
        extensionArray2[extensionArray2.length - 1] = extension;
        extensionPoint.setExtensions(extensionArray2);
        return true;
    }

    private void resolvePluginDescriptorExtensions(PluginDescriptor pluginDescriptor) {
        Extension[] extensionArray = pluginDescriptor.getDeclaredExtensions();
        if (extensionArray == null || extensionArray.length == 0) {
            return;
        }
        ArrayList<Extension> arrayList = new ArrayList<Extension>(extensionArray.length);
        for (int i = 0; i < extensionArray.length; ++i) {
            boolean bl = this.resolveExtension(extensionArray[i]);
            if (!bl) continue;
            arrayList.add(extensionArray[i]);
        }
        if (arrayList.isEmpty()) {
            pluginDescriptor.setDeclaredExtensions(null);
        }
        if (arrayList.size() < extensionArray.length) {
            pluginDescriptor.setDeclaredExtensions(arrayList.toArray(new Extension[arrayList.size()]));
        }
    }

    private void resolvePluginDescriptorPrereqs(PluginDescriptor pluginDescriptor) {
        PluginPrerequisite[] pluginPrerequisiteArray = pluginDescriptor.getRequires();
        if (pluginPrerequisiteArray == null || pluginPrerequisiteArray.length == 0) {
            pluginDescriptor.markActive();
            return;
        }
        for (int i = 0; i < pluginPrerequisiteArray.length; ++i) {
            boolean bl = this.resolvePrereq(pluginPrerequisiteArray[i]);
            if (!bl) continue;
            pluginDescriptor.markActive();
        }
    }

    private boolean resolvePrereq(PluginPrerequisite pluginPrerequisite) {
        String string = pluginPrerequisite.getUniqueIdentifier();
        PluginVersionIdentifier pluginVersionIdentifier = pluginPrerequisite.getVersionIdentifier();
        PluginDescriptor[] pluginDescriptorArray = this.reg.getPlugins(pluginPrerequisite.getUniqueIdentifier());
        if (pluginDescriptorArray == null) {
            return false;
        }
        for (int i = 0; i < pluginDescriptorArray.length; ++i) {
            String string2 = pluginDescriptorArray[i].getUniqueIdentifier();
            PluginVersionIdentifier pluginVersionIdentifier2 = pluginDescriptorArray[i].getVersionIdentifier();
            if (!string2.equals(string)) continue;
            if (pluginPrerequisite.isMatchedUnspecified() || pluginVersionIdentifier == null) {
                if (pluginPrerequisite.isMatchedUnspecified() || pluginVersionIdentifier == null) {
                    // empty if block
                }
                if (!pluginPrerequisite.isMatchedUnspecified() || pluginVersionIdentifier != null) {
                    // empty if block
                }
                pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
                return true;
            }
            if (pluginPrerequisite.isMatchedAsGreaterOrEqual()) {
                if (!pluginVersionIdentifier2.isGreaterOrEqualTo(pluginVersionIdentifier)) continue;
                pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
                return true;
            }
            if (pluginPrerequisite.isMatchedAsEquivalent()) {
                if (!pluginVersionIdentifier2.isEquivalentTo(pluginVersionIdentifier)) continue;
                pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
                return true;
            }
            if (!pluginPrerequisite.isMatchedAsCompatible() || !pluginVersionIdentifier2.isCompatibleWith(pluginVersionIdentifier)) continue;
            pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
            return true;
        }
        return false;
    }

    public boolean requiredPluginDescriptor(PluginDescriptor pluginDescriptor) {
        int n;
        boolean bl = true;
        boolean bl2 = bl = pluginDescriptor.getUniqueIdentifier() != null && pluginDescriptor.getVersion() != null && pluginDescriptor.getName() != null && this.resolveVersion(pluginDescriptor.getVersion());
        if (!bl) {
            return bl;
        }
        PluginPrerequisite[] pluginPrerequisiteArray = pluginDescriptor.getRequires();
        Extension[] extensionArray = pluginDescriptor.getDeclaredExtensions();
        ExtensionPoint[] extensionPointArray = pluginDescriptor.getDeclaredExtensionPoints();
        if (pluginPrerequisiteArray != null) {
            for (n = 0; n < pluginPrerequisiteArray.length && bl; ++n) {
                bl = bl && this.requiredPrerequisite(pluginPrerequisiteArray[n]);
            }
        }
        if (extensionArray != null) {
            for (n = 0; n < extensionArray.length && bl; ++n) {
                bl = bl && this.requiredExtension(extensionArray[n]);
            }
        }
        if (extensionPointArray != null) {
            for (n = 0; n < extensionPointArray.length && bl; ++n) {
                bl = bl && this.requiredExtensionPoint(extensionPointArray[n]);
            }
        }
        return bl;
    }

    private boolean requiredPrerequisite(PluginPrerequisite pluginPrerequisite) {
        if (pluginPrerequisite.getVersion() != null) {
            return this.resolveVersion(pluginPrerequisite.getVersion()) && pluginPrerequisite.getUniqueIdentifier() != null;
        }
        return pluginPrerequisite.getUniqueIdentifier() != null;
    }

    private boolean requiredExtension(Extension extension) {
        return extension.getExtensionPointUniqueId() != null;
    }

    private boolean requiredExtensionPoint(ExtensionPoint extensionPoint) {
        return extensionPoint.getSimpleIdentifier() != null && extensionPoint.getName() != null;
    }

    private void resolveAllPrereqsAreActive(PluginDescriptor pluginDescriptor) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        PluginPrerequisite[] pluginPrerequisiteArray = pluginDescriptor.getRequires();
        if (pluginPrerequisiteArray != null) {
            n = pluginPrerequisiteArray.length;
            for (int i = 0; i < pluginPrerequisiteArray.length; ++i) {
                if (this.reg.getPlugin(pluginPrerequisiteArray[i].getUniqueIdentifier()) != null) {
                    if (this.reg.getPlugin(pluginPrerequisiteArray[i].getUniqueIdentifier()).isActive()) continue;
                    ++n2;
                    continue;
                }
                ++n3;
            }
            if (n3 < n && n2 < n) {
                pluginDescriptor.markActive();
            } else {
                pluginDescriptor.markInactive();
            }
        }
    }
}

