/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import sun.plugin.security.CertificateStore;
import sun.plugin.util.Trace;
import sun.plugin.util.UserProfile;

public final class PluginHttpsCertStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _deploymentcerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.loading", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (PluginHttpsCertStore.this._deploymentcerts == null) {
                        PluginHttpsCertStore.this._deploymentcerts = KeyStore.getInstance("JKS");
                        PluginHttpsCertStore.this._deploymentcerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        PluginHttpsCertStore.this._deploymentcerts.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.loaded", new Object[]{_filename});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.saving", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    PluginHttpsCertStore.this._deploymentcerts.store(bufferedOutputStream, new char[0]);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.saved", new Object[]{_filename});
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.adding");
        if (!this.contains(certificate)) {
            Random random = new Random();
            boolean bl = false;
            String string = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentcerts.getCertificate(string = "deploymentcert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._deploymentcerts.setCertificateEntry(string, certificate);
            Trace.msgSecurityPrintln("jpihttpscertstore.cert.added", new Object[]{string});
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.removing");
        String string = this._deploymentcerts.getCertificateAlias(certificate);
        if (string != null) {
            this._deploymentcerts.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.removed", new Object[]{string});
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.instore");
        String string = null;
        string = this._deploymentcerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.canverify");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.iterator");
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._deploymentcerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._deploymentcerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    public KeyStore getKeyStore() {
        Trace.msgSecurityPrintln("jpihttpscertstore.cert.getkeystore");
        return this._deploymentcerts;
    }

    static {
        _filename = UserProfile.getHttpsCertificateFile();
    }
}

