/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();

    public String getProperty(final String property) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(property);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FrameworkProperties.getProperty(property);
            }
        }, this.controlContext);
    }

    public String getProperty(final String property, final String def) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(property, def);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FrameworkProperties.getProperty(property, def);
            }
        }, this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperties();
        }
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FrameworkProperties.getProperties();
            }
        }, this.controlContext);
    }

    public FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), append);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file.getAbsolutePath(), append);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public long length(final File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.length());
            }
        }, this.controlContext);
    }

    public boolean exists(final File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public boolean isDirectory(final File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public long lastModified(final File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.lastModified());
            }
        }, this.controlContext);
    }

    public String[] list(final File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.list();
            }
        }, this.controlContext);
    }

    public ZipFile getZipFile(final File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return new ZipFile(file);
        }
        try {
            return (ZipFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ZipFile(file);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public URL getURL(final String protocol, final String host, final int port, final String file, final URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(protocol, host, port, file, handler);
        }
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(protocol, host, port, file, handler);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof MalformedURLException) {
                throw (MalformedURLException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public Thread createThread(final Runnable target, final String name) {
        if (System.getSecurityManager() == null) {
            return new Thread(target, name);
        }
        return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Thread(target, name);
            }
        }, this.controlContext);
    }

    public Object getService(final ServiceReference reference, final BundleContext context) {
        if (System.getSecurityManager() == null) {
            return context.getService(reference);
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return context.getService(reference);
            }
        }, this.controlContext);
    }

    public Class forName(final String name) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(name);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Class.forName(name);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public void open(final ServiceTracker tracker) {
        if (System.getSecurityManager() == null) {
            tracker.open();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tracker.open();
                return null;
            }
        }, this.controlContext);
    }

    public void start(final Bundle bundle, int options) throws BundleException {
        if (System.getSecurityManager() == null) {
            bundle.start();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    bundle.start();
                    return null;
                }
            }, this.controlContext);
            return;
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof BundleException) {
                throw (BundleException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }
}

