/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class TextProcessor {
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final String FILE_SEP_FSLASH = "/";
    private static final String FILE_SEP_BSLASH = "\\";
    private static final String delimiterString = ".:/\\";
    private static final char LRM = '\u200e';
    private static final char LRE = '\u202a';
    private static final char PDF = '\u202c';
    private static boolean isBidi = false;

    static {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        if ("iw".equals(lang) || "ar".equals(lang) || "fa".equals(lang) || "ur".equals(lang)) {
            isBidi = true;
        }
    }

    public static String process(String text) {
        return TextProcessor.process(text, TextProcessor.getDefaultDelimiters());
    }

    public static String process(String str, String delimiter) {
        if (!isBidi || str == null) {
            return str;
        }
        delimiter = delimiter == null ? TextProcessor.getDefaultDelimiters() : delimiter;
        String lastToken = null;
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter, true);
        if (tokenizer.countTokens() == 1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (delimiter.indexOf(token) != -1) {
                if (lastToken == null) {
                    buf.append('\u200e');
                }
                buf.append(token);
                buf.append('\u200e');
            } else {
                boolean skipToken = false;
                char firstChar = token.charAt(0);
                if (firstChar == '\u200e') {
                    if (token.length() == 1) {
                        if (lastToken == null) {
                            buf.append(token);
                        }
                        skipToken = true;
                    } else {
                        token = token.substring(1, token.length());
                        firstChar = token.charAt(0);
                    }
                }
                if (!skipToken) {
                    if (firstChar == '\u202a') {
                        buf.append(token);
                    } else {
                        buf.append('\u202a');
                        buf.append(token);
                        buf.append('\u202c');
                    }
                }
            }
            lastToken = token;
        }
        return buf.toString();
    }

    public static String getDefaultDelimiters() {
        return delimiterString;
    }

    private TextProcessor() {
    }
}

