/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.help.eclipse.webclient;

import com.ibm.storage.console.help.eclipse.webclient.HelpDescriptor;
import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;

public final class AppletRequestor {
    private static final String QUERY_PARAMETER_SEPARATOR = "&";
    private static final String ECLIPSE_APPLET_PARAMETER = "help_path";
    private static final String TARGET_APPLET_PARAMETER = "help_target";
    private static final String PLUGIN_APPLET_PARAMETER = "help_plugin";
    private static final String TOPIC_APPLET_PARAMETER = "help_topic";
    private static final String REQUESTOR_PATH = "webclient/requestor.jsp?";
    private static final String PLUGIN_QUERY_PARAMETER = "plugin=";
    private static final String TOPIC_QUERY_PARAMETER = "topic=";
    private static final String DEFAULT_ECLIPSE_PATH = "/help/";
    private static final String DEFAULT_REQUESTOR_TARGET = "CommandFrame";
    private AppletContext context = null;
    private HelpDescriptor descriptor = new HelpDescriptor();
    private String requestorTarget = null;
    private URL docbase = null;

    public AppletRequestor(Applet applet) {
        this.context = applet.getAppletContext();
        this.docbase = applet.getDocumentBase();
        String parameter = applet.getParameter(ECLIPSE_APPLET_PARAMETER);
        if (parameter != null && (parameter = parameter.trim()).length() > 0) {
            this.setEclipsePath(parameter);
        }
        if ((parameter = applet.getParameter(TARGET_APPLET_PARAMETER)) != null && (parameter = parameter.trim()).length() > 0) {
            this.setRequestorTarget(parameter);
        }
        if ((parameter = applet.getParameter(PLUGIN_APPLET_PARAMETER)) != null && (parameter = parameter.trim()).length() > 0) {
            this.setDefaultPlugin(parameter);
        }
        if ((parameter = applet.getParameter(TOPIC_APPLET_PARAMETER)) != null && (parameter = parameter.trim()).length() > 0) {
            this.showHelp(parameter);
        }
    }

    public void setDefaultPlugin(String id) {
        this.descriptor.setDefaultPlugin(id);
    }

    public String getDefaultPlugin() {
        return this.descriptor.getDefaultPlugin();
    }

    public void setEclipsePath(String path) {
        this.descriptor.setEclipsePath(path);
    }

    public String getEclipsePath() {
        return this.descriptor.getEclipsePath();
    }

    public String getRequestorPath() {
        return this.getEclipsePath() + REQUESTOR_PATH;
    }

    public void setRequestorTarget(String target) {
        this.requestorTarget = target;
    }

    public String getRequestorTarget() {
        return this.requestorTarget != null ? this.requestorTarget : DEFAULT_REQUESTOR_TARGET;
    }

    public void showHelp(String topic) {
        this.showHelp(this.getDefaultPlugin(), topic);
    }

    public void showHelp(String pluginID, String topic) {
        String params = pluginID != null ? PLUGIN_QUERY_PARAMETER + pluginID + QUERY_PARAMETER_SEPARATOR + TOPIC_QUERY_PARAMETER + topic : TOPIC_QUERY_PARAMETER + topic;
        try {
            URL requestURL = new URL(this.docbase, this.getRequestorPath() + params);
            this.context.showDocument(requestURL, this.getRequestorTarget());
        }
        catch (MalformedURLException ex) {
            System.out.println("help request error:\n" + ex.toString());
        }
    }
}

