/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;

abstract class BinaryDecimal
extends NumberDataType
implements VariableSizeDataValue {
    private static final byte[] ONE_2C = new byte[]{1};
    protected byte[] data2c;
    protected int sqlScale;

    BinaryDecimal() {
    }

    public final int typeToBigDecimal() {
        return 3;
    }

    public final int typePrecedence() {
        return 70;
    }

    public final String getTypeName() {
        return "DECIMAL";
    }

    public final int getTypeFormatId() {
        return 200;
    }

    public boolean isNull() {
        return this.data2c == null;
    }

    public void restoreToNull() {
        this.data2c = null;
    }

    protected boolean isNegative() {
        return !this.isNull() && (this.data2c[0] & 0x80) != 0;
    }

    public void setValue(long l) {
        byte[] byArray = this.data2c;
        if (byArray == null || byArray.length < 8) {
            byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        }
        this.data2c = BinaryDecimal.reduceBytes2c(byArray, 0, 8);
        this.sqlScale = 0;
    }

    public final void setValue(int n) {
        byte[] byArray = this.data2c;
        if (byArray == null || byArray.length < 4) {
            byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        }
        this.data2c = BinaryDecimal.reduceBytes2c(byArray, 0, 4);
        this.sqlScale = 0;
    }

    public void setValue(boolean bl) {
        int n = bl ? 1 : 0;
        this.setValue(n);
    }

    public final void setValue(double d) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(d));
    }

    public final void setValue(float f) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(f));
    }

    private void setCoreValue(double d) throws StandardException {
        this.setValue(Double.toString(d));
    }

    public void setValue(Number number) throws StandardException {
        if (number == null) {
            this.setToNull();
        } else {
            this.setValue(number.longValue());
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        switch (dataValueDescriptor.typeToBigDecimal()) {
            case 1: 
            case 3: {
                this.setValue(dataValueDescriptor.getString());
                break;
            }
            case -5: {
                this.setValue(dataValueDescriptor.getLong());
                break;
            }
            default: {
                super.setFrom(dataValueDescriptor);
            }
        }
    }

    public final int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "INTEGER");
    }

    public final byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -128L && l <= 127L) {
                return (byte)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "TINYINT");
    }

    public final short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -32768L && l <= 32767L) {
                return (short)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "SMALLINT");
    }

    public final NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        return this.plusNN(numberDataValue, numberDataValue2, numberDataValue3);
    }

    public final NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        return this.timesNN(numberDataValue, numberDataValue2, numberDataValue3);
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3, -1);
    }

    public final NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        return this.divideNN(numberDataValue, numberDataValue2, numberDataValue3, n);
    }

    public final NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        return this.minusNN(numberDataValue, numberDataValue2, numberDataValue3);
    }

    public NumberDataValue minusNN(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return this.plusNN(numberDataValue, numberDataValue2.minus(numberDataValue3), numberDataValue3);
    }

    public abstract NumberDataValue timesNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue plusNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue divideNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3, int var4) throws StandardException;

    private static byte[] reduceBytes2c(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 - 1 && byArray[n + n3] == 0 && (byArray[n + n3 + 1] & 0x80) == 0; ++n3) {
        }
        if (n3 == 0) {
            while (n3 < n2 - 1 && byArray[n + n3] == -1 && (byArray[n + n3 + 1] & 0xFFFFFF80) != 0) {
                ++n3;
            }
        }
        if (n3 != 0 || byArray.length != n2) {
            byte[] byArray2 = new byte[n2 - n3];
            System.arraycopy(byArray, n + n3, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        return this.sqlScale;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.sqlScale);
        objectOutput.writeByte(this.data2c.length);
        objectOutput.write(this.data2c);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.sqlScale = objectInput.readUnsignedByte();
        int n = objectInput.readUnsignedByte();
        if (this.data2c == null || n != this.data2c.length) {
            this.data2c = new byte[n];
        }
        objectInput.readFully(this.data2c);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.sqlScale = arrayInputStream.readUnsignedByte();
        int n = arrayInputStream.readUnsignedByte();
        if (this.data2c == null || n != this.data2c.length) {
            this.data2c = new byte[n];
        }
        arrayInputStream.readFully(this.data2c);
    }

    public final int getLength() {
        return this.getDecimalValuePrecision();
    }

    public DataValueDescriptor getClone() {
        BinaryDecimal binaryDecimal = (BinaryDecimal)this.getNewNull();
        if (this.data2c != null) {
            binaryDecimal.data2c = new byte[this.data2c.length];
            System.arraycopy(this.data2c, 0, binaryDecimal.data2c, 0, this.data2c.length);
            binaryDecimal.sqlScale = this.sqlScale;
        }
        return binaryDecimal;
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws StandardException, SQLException {
        throw StandardException.newException("0A000.S");
    }

    public int estimateMemoryUsage() {
        return 0;
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        try {
            return (int)this.getLong();
        }
        catch (StandardException standardException) {
            return 0;
        }
    }
}

