/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.InputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CloneableObject;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;

public abstract class DataType
implements DataValueDescriptor,
CloneableObject {
    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    public Date getDate(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    public Time getTime(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    public InputStream getStream() throws StandardException {
        throw this.dataTypeConversion(MessageService.getTextMessage("42Z11.U"));
    }

    public String getTraceString() throws StandardException {
        return this.getString();
    }

    public final BooleanDataValue isNullOp() {
        return SQLBoolean.truthValue(this.isNull());
    }

    public final BooleanDataValue isNotNull() {
        return SQLBoolean.truthValue(!this.isNull());
    }

    public void setValue(Time time) throws StandardException {
        this.setValue(time, (Calendar)null);
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    public void setValue(Timestamp timestamp) throws StandardException {
        this.setValue(timestamp, (Calendar)null);
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    public void setValue(Date date) throws StandardException {
        this.setValue(date, (Calendar)null);
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    public void setValue(String string) throws StandardException {
        this.throwLangSetMismatch("java.lang.String");
    }

    public void setValue(int n) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    public void setValue(double d) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    public void setValue(float f) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    public void setValue(short s) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    public void setValue(long l) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    public void setValue(byte by) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    public void setValue(boolean bl) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    public void setValue(byte[] byArray) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    public void setBigDecimal(Number number) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    public final void setValue(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            this.setToNull();
            return;
        }
        try {
            this.setFrom(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            String string = standardException.getMessageId();
            if ("22003".equals(string)) {
                throw this.outOfRange();
            }
            if ("22018".equals(string)) {
                throw this.invalidFormat();
            }
            throw standardException;
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        throw StandardException.newException("0A000.S");
    }

    public void setToNull() {
        this.restoreToNull();
    }

    public void setObjectForCast(Object object, boolean bl, String string) throws StandardException {
        this.setValue(object);
    }

    public void setValue(Object object) throws StandardException {
        if (object == null) {
            this.setToNull();
        } else {
            this.throwLangSetMismatch(object);
        }
    }

    public Object getObject() throws StandardException {
        throw this.dataTypeConversion("java.lang.Object");
    }

    protected void genericSetObject(Object object) throws StandardException {
        this.throwLangSetMismatch(object);
    }

    public Object cloneObject() {
        return this.getClone();
    }

    protected String getNationalString(LocaleFinder localeFinder) throws StandardException {
        return this.getString();
    }

    public void throwLangSetMismatch(Object object) throws StandardException {
        this.throwLangSetMismatch(object.getClass().getName());
    }

    void throwLangSetMismatch(String string) throws StandardException {
        throw StandardException.newException("XCL12.S", string, (Object)this.getTypeName());
    }

    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setObject(n, this.getObject());
    }

    public void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateObject(n, this.getObject());
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor);
    }

    public int typePrecedence() {
        return -1;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) == 0);
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) != 0);
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) < 0);
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) > 0);
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) <= 0);
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) >= 0);
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return dataValueDescriptor.compare(DataType.flip(n), this, bl, bl2);
        }
        int n2 = this.compare(dataValueDescriptor);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 == 0;
            }
            case 3: {
                return n2 <= 0;
            }
            case 4: {
                return n2 > 0;
            }
            case 5: {
                return n2 >= 0;
            }
        }
        return false;
    }

    protected static int flip(int n) {
        switch (n) {
            case 1: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 2;
            }
        }
        return n;
    }

    public DataValueDescriptor coalesce(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor dataValueDescriptor) throws StandardException {
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            if (dataValueDescriptorArray[i].isNull()) continue;
            dataValueDescriptor.setValue(dataValueDescriptorArray[i]);
            return dataValueDescriptor;
        }
        dataValueDescriptor.setToNull();
        return dataValueDescriptor;
    }

    public BooleanDataValue in(DataValueDescriptor dataValueDescriptor, DataValueDescriptor[] dataValueDescriptorArray, boolean bl) throws StandardException {
        BooleanDataValue booleanDataValue;
        int n;
        BooleanDataValue booleanDataValue2 = null;
        if (dataValueDescriptor.isNull()) {
            return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptorArray[0], false);
        }
        int n2 = 0;
        int n3 = dataValueDescriptorArray.length;
        if (bl) {
            while (n3 - n2 > 2) {
                n = (n3 - n2) / 2 + n2;
                booleanDataValue2 = this.equals(dataValueDescriptor, dataValueDescriptorArray[n]);
                if (booleanDataValue2.equals(true)) {
                    return booleanDataValue2;
                }
                booleanDataValue = this.greaterThan(dataValueDescriptorArray[n], dataValueDescriptor);
                if (booleanDataValue.equals(true)) {
                    n3 = n;
                    continue;
                }
                n2 = n;
            }
        }
        for (n = n2; !(n >= n3 || (booleanDataValue2 = this.equals(dataValueDescriptor, dataValueDescriptorArray[n])).equals(true) || bl && (booleanDataValue = this.greaterThan(dataValueDescriptorArray[n], dataValueDescriptor)).equals(true)); ++n) {
        }
        return booleanDataValue2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataValueDescriptor)) {
            return false;
        }
        try {
            return this.compare(2, (DataValueDescriptor)object, true, false);
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    public void setValue(InputStream inputStream, int n) throws StandardException {
        this.throwLangSetMismatch("java.io.InputStream");
    }

    public void checkHostVariable(int n) throws StandardException {
    }

    protected final StandardException dataTypeConversion(String string) {
        return StandardException.newException("22005", string, (Object)this.getTypeName());
    }

    protected final StandardException outOfRange() {
        return StandardException.newException("22003", this.getTypeName());
    }

    protected final StandardException invalidFormat() {
        return StandardException.newException("22018", this.getTypeName());
    }
}

