/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.StatementNode;

public abstract class DMLStatementNode
extends StatementNode {
    public ResultSetNode resultSet;
    static /* synthetic */ Class class$org$apache$derby$impl$sql$compile$FromBaseTable;
    static /* synthetic */ Class class$org$apache$derby$impl$sql$compile$StaticMethodCallNode;

    public void init(Object object) {
        this.resultSet = (ResultSetNode)object;
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getResultSetNode() {
        return this.resultSet;
    }

    public QueryTreeNode bind(DataDictionary dataDictionary) throws StandardException {
        this.bindTables(dataDictionary);
        this.bindExpressions();
        return this;
    }

    public QueryTreeNode bindResultSetsWithTables(DataDictionary dataDictionary) throws StandardException {
        this.bindTables(dataDictionary);
        this.bindExpressionsWithTables();
        return this;
    }

    protected void bindTables(DataDictionary dataDictionary) throws StandardException {
        this.resultSet = this.resultSet.bindNonVTITables(dataDictionary, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.resultSet = this.resultSet.bindVTITables((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
    }

    protected void bindExpressions() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressions(fromList);
    }

    protected void bindExpressionsWithTables() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressionsWithTables(fromList);
    }

    int activationKind() {
        Vector vector = this.getCompilerContext().getParameterList();
        if (vector != null && vector.size() > 0) {
            return 2;
        }
        return 1;
    }

    public QueryTreeNode optimize() throws StandardException {
        this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        this.resultSet = this.resultSet.optimize(this.getDataDictionary(), null, 1.0);
        this.resultSet = this.resultSet.modifyAccessPaths();
        if (this instanceof CursorNode) {
            ResultSetNode resultSetNode = this.resultSet;
            ResultColumnList resultColumnList = this.resultSet.getResultColumns();
            ResultColumnList resultColumnList2 = resultColumnList.copyListAndObjects();
            this.resultSet.setResultColumns(resultColumnList2);
            resultColumnList.genVirtualColumnNodes(this.resultSet, resultColumnList2);
            this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(123, this.resultSet, resultColumnList, null, this.getContextManager());
            if (resultSetNode.getReferencedTableMap() != null) {
                this.resultSet.setReferencedTableMap((JBitSet)resultSetNode.getReferencedTableMap().clone());
            }
        }
        return this;
    }

    public ResultDescription makeResultDescription() {
        ExecutionContext executionContext = (ExecutionContext)this.getContextManager().getContext("ExecutionContext");
        ResultColumnDescriptor[] resultColumnDescriptorArray = this.resultSet.makeResultDescriptors(executionContext);
        String string = this.statementToString();
        return executionContext.getExecutionFactory().getResultDescription(resultColumnDescriptorArray, string);
    }

    void generateParameterValueSet(ActivationClassBuilder activationClassBuilder) throws StandardException {
        int n;
        Vector vector = this.getCompilerContext().getParameterList();
        int n2 = n = vector == null ? 0 : vector.size();
        if (n <= 0) {
            return;
        }
        ParameterNode.generateParameterValueSet(activationClassBuilder, n, vector);
    }

    public boolean isAtomic() throws StandardException {
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(class$org$apache$derby$impl$sql$compile$FromBaseTable == null ? (class$org$apache$derby$impl$sql$compile$FromBaseTable = DMLStatementNode.class$("org.apache.derby.impl.sql.compile.FromBaseTable")) : class$org$apache$derby$impl$sql$compile$FromBaseTable, class$org$apache$derby$impl$sql$compile$StaticMethodCallNode == null ? (class$org$apache$derby$impl$sql$compile$StaticMethodCallNode = DMLStatementNode.class$("org.apache.derby.impl.sql.compile.StaticMethodCallNode")) : class$org$apache$derby$impl$sql$compile$StaticMethodCallNode);
        this.accept(hasNodeVisitor);
        return hasNodeVisitor.hasNode();
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        if (visitor.skipChildren(this)) {
            return visitor.visit(this);
        }
        if (this.resultSet != null && !visitor.stopTraversal()) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(visitor);
        }
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

