/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Set;
import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class ResultSetNode
extends QueryTreeNode {
    int resultSetNumber;
    JBitSet referencedTableMap;
    ResultColumnList resultColumns;
    boolean statementResultSet;
    boolean cursorTargetTable;
    boolean insertSource;
    CostEstimate costEstimate;
    CostEstimate scratchCostEstimate;
    Optimizer optimizer;
    CostEstimate finalCostEstimate;

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        return this.finalCostEstimate;
    }

    public void assignResultSetNumber() throws StandardException {
        this.resultSetNumber = this.getCompilerContext().getNextResultSetNumber();
        this.resultColumns.setResultSetNumber(this.resultSetNumber);
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        return this;
    }

    public ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        return this;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
    }

    public void bindExpressionsWithTables(FromList fromList) throws StandardException {
    }

    public void bindTargetExpressions(FromList fromList) throws StandardException {
    }

    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            TypeId typeId;
            ResultColumn resultColumn;
            ResultColumn resultColumn2 = (ResultColumn)this.resultColumns.elementAt(i);
            ValueNode valueNode = resultColumn2.getExpression();
            if (valueNode.isParameterNode()) {
                resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                ((ParameterNode)valueNode).setDescriptor(resultColumn.getTypeServices());
                continue;
            }
            if (valueNode instanceof CharConstantNode) {
                resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                typeId = resultColumn.getTypeId();
                if (typeId.isStringTypeId()) {
                    if (typeId.getJDBCTypeId() == 1) continue;
                    int n2 = valueNode.getTypeServices().getMaximumWidth();
                    valueNode.setType(new DataTypeDescriptor(typeId, true, n2));
                    continue;
                }
                if (!typeId.isBitTypeId()) continue;
                if (typeId.getJDBCTypeId() == -3) {
                    TypeId typeId2 = TypeId.getBuiltInTypeId(12);
                    valueNode.setType(new DataTypeDescriptor(typeId2, true));
                    resultColumnList.setElementAt(resultColumn, i);
                    continue;
                }
                if (typeId.getJDBCTypeId() != -4) continue;
                TypeId typeId3 = TypeId.getBuiltInTypeId(-1);
                valueNode.setType(new DataTypeDescriptor(typeId3, true));
                resultColumnList.setElementAt(resultColumn, i);
                continue;
            }
            if (!(valueNode instanceof BitConstantNode)) continue;
            resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            typeId = resultColumn.getTypeId();
            if (typeId.isBitTypeId()) {
                if (typeId.getJDBCTypeId() == -2 || typeId.getJDBCTypeId() == 2004) continue;
                int n3 = valueNode.getTypeServices().getMaximumWidth();
                valueNode.setType(new DataTypeDescriptor(typeId, true, n3));
                continue;
            }
            if (!typeId.isStringTypeId()) continue;
            if (typeId.getJDBCTypeId() == 12) {
                TypeId typeId4 = TypeId.getBuiltInTypeId(-3);
                valueNode.setType(new DataTypeDescriptor(typeId4, true));
                resultColumnList.setElementAt(resultColumn, i);
                continue;
            }
            if (typeId.getJDBCTypeId() != -1) continue;
            TypeId typeId5 = TypeId.getBuiltInTypeId(-4);
            valueNode.setType(new DataTypeDescriptor(typeId5, true));
            resultColumnList.setElementAt(resultColumn, i);
        }
    }

    public void setInsertSource() {
        this.insertSource = true;
    }

    public void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
    }

    public ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        return null;
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    public void setResultToBooleanTrueNode(boolean bl) throws StandardException {
        ResultColumn resultColumn;
        if (this.resultColumns.elementAt(0) instanceof AllResultColumn) {
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "", null, this.getContextManager());
        } else {
            if (bl) {
                return;
            }
            resultColumn = (ResultColumn)this.resultColumns.elementAt(0);
            if (resultColumn.getExpression().isBooleanTrue()) {
                return;
            }
        }
        BooleanConstantNode booleanConstantNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        resultColumn.setExpression(booleanConstantNode);
        resultColumn.setType(booleanConstantNode.getTypeServices());
        resultColumn.setVirtualColumnId(1);
        this.resultColumns.setElementAt(resultColumn, 0);
    }

    public FromList getFromList() throws StandardException {
        return (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        this.resultColumns.bindResultColumnsToExpressions();
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        if (this instanceof SelectNode) {
            this.resultColumns.expandAllsAndNameColumns(((SelectNode)this).fromList);
        }
        if (resultColumnList != null) {
            this.resultColumns.copyResultColumnNames(resultColumnList);
        }
        if (resultColumnList != null) {
            if (tableDescriptor != null) {
                this.resultColumns.bindResultColumnsByName(tableDescriptor, dMLStatementNode);
            } else {
                this.resultColumns.bindResultColumnsByName(fromVTI.getResultColumns(), fromVTI, dMLStatementNode);
            }
        } else {
            this.resultColumns.bindResultColumnsByPosition(tableDescriptor);
        }
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        return null;
    }

    void projectResultColumns() throws StandardException {
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return null;
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        return null;
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    ResultSetNode genProjectRestrictForReordering() throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns, false);
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, null, this.getContextManager());
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        return null;
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        return this;
    }

    public ResultSetNode modifyAccessPaths(PredicateList predicateList) throws StandardException {
        return this.modifyAccessPaths();
    }

    ResultColumnDescriptor[] makeResultDescriptors(ExecutionContext executionContext) {
        return this.resultColumns.makeResultDescriptors(executionContext);
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        return this.resultColumns.columnTypesAndLengthsMatch();
    }

    public void setResultColumns(ResultColumnList resultColumnList) {
        this.resultColumns = resultColumnList;
    }

    public ResultColumnList getResultColumns() {
        return this.resultColumns;
    }

    public void setReferencedTableMap(JBitSet jBitSet) {
        this.referencedTableMap = jBitSet;
    }

    public JBitSet getReferencedTableMap() {
        return this.referencedTableMap;
    }

    public void fillInReferencedTableMap(JBitSet jBitSet) {
    }

    public void rejectParameters() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectParameters();
        }
    }

    public void rejectXMLValues() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectXMLValues();
        }
    }

    public void renameGeneratedResultNames() throws StandardException {
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (!resultColumn.isNameGenerated()) continue;
            resultColumn.setName(Integer.toString(i + 1));
        }
    }

    public void markStatementResultSet() {
        this.statementResultSet = true;
    }

    void closeMethodArgument(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) {
        if (this.statementResultSet) {
            expressionClassBuilder.pushResultSetClosedMethodFieldAccess(methodBuilder);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
    }

    public ResultSetNode enhanceRCLForInsert(int n, int[] nArray, DataDictionary dataDictionary, TableDescriptor tableDescriptor, FromVTI fromVTI) throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n2 = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = null;
            resultColumn = nArray[i] != -1 ? this.resultColumns.getResultColumn(nArray[i] + 1) : this.genNewRCForInsert(tableDescriptor, fromVTI, i + 1, dataDictionary);
            resultColumnList.addResultColumn(resultColumn);
        }
        this.resultColumns = resultColumnList;
        return this;
    }

    ResultColumn genNewRCForInsert(TableDescriptor tableDescriptor, FromVTI fromVTI, int n, DataDictionary dataDictionary) throws StandardException {
        ResultColumn resultColumn = null;
        if (fromVTI != null) {
            resultColumn = fromVTI.getResultColumns().getResultColumn(n);
            resultColumn = resultColumn.cloneMe();
            resultColumn.setExpressionToNullNode();
        } else {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            DefaultInfoImpl defaultInfoImpl = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
            if (defaultInfoImpl != null && !columnDescriptor.isAutoincrement()) {
                String string = defaultInfoImpl.getDefaultText();
                ValueNode valueNode = this.parseDefault(string);
                valueNode = valueNode.bindExpression(this.getFromList(), null, null);
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, valueNode.getTypeServices(), valueNode, this.getContextManager());
                DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
                this.getCompilerContext().createDependency(defaultDescriptor);
            } else if (columnDescriptor.isAutoincrement()) {
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDescriptor, null, this.getContextManager());
                resultColumn.setAutoincrementGenerated();
            } else {
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, dataTypeDescriptor, this.getNullNode(dataTypeDescriptor.getTypeId(), this.getContextManager()), this.getContextManager());
            }
        }
        resultColumn.markGeneratedForUnmatchedColumnInInsert();
        return resultColumn;
    }

    public ValueNode parseDefault(String string) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CompilerContext compilerContext = this.getCompilerContext();
        String string2 = "VALUES " + string;
        CompilerContext compilerContext2 = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext2.getParser();
        QueryTreeNode queryTreeNode = parser.parseStatement(string2);
        ValueNode valueNode = ((ResultColumn)((CursorNode)queryTreeNode).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        languageConnectionContext.popCompilerContext(compilerContext2);
        return valueNode;
    }

    public ResultDescription makeResultDescription() {
        ExecutionContext executionContext = (ExecutionContext)this.getContextManager().getContext("ExecutionContext");
        ResultColumnDescriptor[] resultColumnDescriptorArray = this.makeResultDescriptors(executionContext);
        return executionContext.getExecutionFactory().getResultDescription(resultColumnDescriptorArray, null);
    }

    boolean isUpdatableCursor(DataDictionary dataDictionary) throws StandardException {
        return false;
    }

    FromTable getCursorTargetTable() {
        return null;
    }

    public boolean markAsCursorTargetTable() {
        return false;
    }

    void notCursorTargetTable() {
        this.cursorTargetTable = false;
    }

    public ResultSetNode genProjectRestrict() throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns);
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, null, this.getContextManager());
    }

    protected ResultSetNode genProjectRestrict(int n) throws StandardException {
        return this.genProjectRestrict();
    }

    public NormalizeResultSetNode genNormalizeResultSetNode(ResultSetNode resultSetNode, boolean bl) throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns);
        NormalizeResultSetNode normalizeResultSetNode = (NormalizeResultSetNode)this.getNodeFactory().getNode(122, resultSetNode, resultColumnList, null, new Boolean(bl), this.getContextManager());
        if (resultSetNode.getReferencedTableMap() != null) {
            normalizeResultSetNode.setReferencedTableMap((JBitSet)resultSetNode.getReferencedTableMap().clone());
        }
        return normalizeResultSetNode;
    }

    public void generateNormalizationResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n, ResultDescription resultDescription) throws StandardException {
        int n2 = activationClassBuilder.addItem(resultDescription);
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(false);
        this.closeMethodArgument(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }

    public ResultSetNode changeAccessPath() throws StandardException {
        return this;
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return false;
    }

    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return false;
    }

    public boolean isOneRowResultSet() throws StandardException {
        return false;
    }

    public boolean isNotExists() {
        return false;
    }

    protected Optimizer getOptimizer(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, RequiredRowOrdering requiredRowOrdering) throws StandardException {
        if (this.optimizer == null) {
            OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
            this.optimizer = optimizerFactory.getOptimizer(optimizableList, optimizablePredicateList, dataDictionary, requiredRowOrdering, this.getCompilerContext().getNumTables(), this.getLanguageConnectionContext());
        }
        this.optimizer.prepForNextRound();
        return this.optimizer;
    }

    protected OptimizerImpl getOptimizerImpl() {
        return (OptimizerImpl)this.optimizer;
    }

    protected CostEstimate getNewCostEstimate() throws StandardException {
        OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
        return optimizerFactory.getCostEstimate();
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.resultColumns != null && !visitor.stopTraversal()) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(visitor);
        }
        return visitable;
    }

    public ResultSetNode considerMaterialization(JBitSet jBitSet) throws StandardException {
        return this;
    }

    public boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return false;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return null;
    }

    abstract void decrementLevel(int var1);

    void pushOrderByList(OrderByList orderByList) {
    }

    public void generateResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        System.out.println("I am a " + this.getClass());
    }

    public int updateTargetLockMode() {
        return 7;
    }

    void notFlattenableJoin() {
    }

    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, Vector vector) throws StandardException {
        return false;
    }

    boolean returnsAtMostOneRow() {
        return false;
    }

    void replaceDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
    }

    boolean isPossibleDistinctScan(Set set) {
        return false;
    }

    void markForDistinctScan() {
    }

    void markOrderingDependent() {
    }

    protected static final int numDistinctAggregates(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            n += ((AggregateNode)vector.elementAt(i)).isDistinct() ? 1 : 0;
        }
        return n;
    }

    public JBitSet LOJgetReferencedTables(int n) throws StandardException {
        if (this instanceof FromTable && ((FromTable)this).tableNumber != -1) {
            JBitSet jBitSet = new JBitSet(n);
            jBitSet.set(((FromTable)this).tableNumber);
            return jBitSet;
        }
        return null;
    }
}

