/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public abstract class StatementNode
extends QueryTreeNode {
    static final int NEED_DDL_ACTIVATION = 5;
    static final int NEED_CURSOR_ACTIVATION = 4;
    static final int NEED_PARAM_ACTIVATION = 2;
    static final int NEED_ROW_ACTIVATION = 1;
    static final int NEED_NOTHING_ACTIVATION = 0;

    public boolean isAtomic() throws StandardException {
        return true;
    }

    public String toString() {
        return "";
    }

    public abstract String statementToString();

    abstract int activationKind();

    protected TableDescriptor lockTableForCompilation(TableDescriptor tableDescriptor) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (dataDictionary.getCacheMode() == 1) {
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            ConglomerateController conglomerateController = transactionController.openConglomerate(tableDescriptor.getHeapConglomerateId(), false, 68, 6, 5);
            conglomerateController.close();
            String string = tableDescriptor.getName();
            tableDescriptor = this.getTableDescriptor(tableDescriptor.getName(), this.getSchemaDescriptor(tableDescriptor.getSchemaName()));
            if (tableDescriptor == null) {
                throw StandardException.newException("42X05", string);
            }
        }
        return tableDescriptor;
    }

    public GeneratedClass generate(ByteArray byteArray) throws StandardException {
        String string;
        int n = this.activationKind();
        switch (n) {
            case 4: {
                string = "org.apache.derby.impl.sql.execute.CursorActivation";
                break;
            }
            case 5: {
                return this.getClassFactory().loadGeneratedClass("org.apache.derby.impl.sql.execute.ConstantActionActivation", null);
            }
            case 0: 
            case 1: 
            case 2: {
                string = "org.apache.derby.impl.sql.execute.BaseActivation";
                break;
            }
            default: {
                throw StandardException.newException("42Z53", String.valueOf(n));
            }
        }
        ActivationClassBuilder activationClassBuilder = new ActivationClassBuilder(string, this.getCompilerContext());
        MethodBuilder methodBuilder = activationClassBuilder.getExecuteMethod();
        methodBuilder.pushThis();
        methodBuilder.getField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        methodBuilder.conditionalIfNull();
        MethodBuilder methodBuilder2 = activationClassBuilder.getClassBuilder().newMethodBuilder(4, "org.apache.derby.iapi.sql.ResultSet", "fillResultSet");
        methodBuilder2.addThrownException("org.apache.derby.iapi.error.StandardException");
        this.generate(activationClassBuilder, methodBuilder2);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)182, null, "fillResultSet", "org.apache.derby.iapi.sql.ResultSet", 0);
        methodBuilder.startElseCode();
        methodBuilder.pushThis();
        methodBuilder.getField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        methodBuilder.completeConditional();
        methodBuilder.pushThis();
        methodBuilder.swap();
        methodBuilder.putField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        methodBuilder.endStatement();
        activationClassBuilder.finishExecuteMethod(this instanceof CursorNode);
        activationClassBuilder.finishConstructor();
        try {
            GeneratedClass generatedClass = activationClassBuilder.getGeneratedClass(byteArray);
            return generatedClass;
        }
        catch (StandardException standardException) {
            String string2 = standardException.getMessageId();
            if ("XBCM4.S".equals(string2) || "XBCM1.S".equals(string2)) {
                throw StandardException.newException("42ZA0", standardException);
            }
            throw standardException;
        }
    }
}

