/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;

final class GenericStatementContext
extends ContextImpl
implements StatementContext {
    private final TransactionController tc;
    private boolean setSavePoint;
    private String internalSavePointName;
    private ResultSet topResultSet;
    private ArrayList dependencies;
    private NoPutResultSet[] subqueryTrackingArray;
    private NoPutResultSet[] materializedSubqueries;
    private final LanguageConnectionContext lcc;
    private boolean inUse = true;
    private boolean parentInTrigger;
    private boolean isAtomic;
    private boolean isSystemCode;
    private boolean rollbackParentContext;
    private String stmtText;
    private ParameterValueSet pvs;
    private short sqlAllowed = (short)-1;

    GenericStatementContext(LanguageConnectionContext languageConnectionContext, TransactionController transactionController) {
        super(languageConnectionContext.getContextManager(), "StatementContext");
        this.lcc = languageConnectionContext;
        this.tc = transactionController;
        this.internalSavePointName = languageConnectionContext.getUniqueSavepointName();
    }

    public void setInUse(boolean bl, boolean bl2, String string, ParameterValueSet parameterValueSet) {
        this.inUse = true;
        this.parentInTrigger = bl;
        this.isAtomic = bl2;
        this.stmtText = string;
        this.pvs = parameterValueSet;
        this.rollbackParentContext = false;
    }

    public void clearInUse() {
        this.stuffTopResultSet(null, null);
        this.inUse = false;
        this.parentInTrigger = false;
        this.isAtomic = false;
        this.stmtText = null;
        this.sqlAllowed = (short)-1;
        this.isSystemCode = false;
        this.rollbackParentContext = false;
    }

    public void setSavePoint() throws StandardException {
        this.pleaseBeOnStack();
        if (this.tc != null) {
            this.tc.setSavePoint(this.internalSavePointName, null);
        }
        this.setSavePoint = true;
    }

    public void resetSavePoint() throws StandardException {
        if (this.inUse && this.setSavePoint && this.tc != null) {
            this.tc.setSavePoint(this.internalSavePointName, null);
        }
    }

    public void clearSavePoint() throws StandardException {
        this.pleaseBeOnStack();
        if (this.tc != null) {
            this.tc.releaseSavePoint(this.internalSavePointName, null);
        }
        this.setSavePoint = false;
    }

    public void setTopResultSet(ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) throws StandardException {
        this.pleaseBeOnStack();
        if (this.materializedSubqueries != null) {
            if (noPutResultSetArray != null) {
                for (int i = 0; i < noPutResultSetArray.length; ++i) {
                    if (this.subqueryTrackingArray[i] == null) continue;
                    noPutResultSetArray[i] = this.materializedSubqueries[i];
                }
            } else {
                noPutResultSetArray = this.materializedSubqueries;
            }
            this.materializedSubqueries = null;
        }
        this.stuffTopResultSet(resultSet, noPutResultSetArray);
    }

    private void stuffTopResultSet(ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) {
        this.topResultSet = resultSet;
        this.subqueryTrackingArray = noPutResultSetArray;
        this.dependencies = null;
    }

    public void setSubqueryResultSet(int n, NoPutResultSet noPutResultSet, int n2) throws StandardException {
        this.pleaseBeOnStack();
        if (this.subqueryTrackingArray == null) {
            if (this.topResultSet == null) {
                this.subqueryTrackingArray = new NoPutResultSet[n2];
                this.materializedSubqueries = new NoPutResultSet[n2];
            } else {
                this.subqueryTrackingArray = this.topResultSet.getSubqueryTrackingArray(n2);
            }
        }
        this.subqueryTrackingArray[n] = noPutResultSet;
        if (this.materializedSubqueries != null) {
            this.materializedSubqueries[n] = noPutResultSet;
        }
    }

    public NoPutResultSet[] getSubqueryTrackingArray() throws StandardException {
        this.pleaseBeOnStack();
        return this.subqueryTrackingArray;
    }

    public void addDependency(Dependency dependency) throws StandardException {
        this.pleaseBeOnStack();
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(dependency);
    }

    public boolean inTrigger() {
        return this.parentInTrigger;
    }

    public void cleanupOnError(Throwable throwable) throws StandardException {
        int n;
        int n2 = n = throwable instanceof StandardException ? ((StandardException)throwable).getSeverity() : 20000;
        if (!this.inUse) {
            return;
        }
        if (this.topResultSet != null) {
            this.topResultSet.cleanUp();
        }
        if (this.subqueryTrackingArray != null) {
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                this.subqueryTrackingArray[i].cleanUp();
            }
        }
        if (this.dependencies != null) {
            DependencyManager dependencyManager = this.lcc.getDataDictionary().getDependencyManager();
            Iterator iterator = this.dependencies.iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                dependencyManager.clearInMemoryDependency(dependency);
            }
            this.dependencies = null;
        }
        if (n <= 20000 && this.setSavePoint) {
            this.lcc.internalRollbackToSavepoint(this.internalSavePointName, false, null);
            this.clearSavePoint();
        }
        if (n >= 30000) {
            this.setSavePoint = false;
        }
        this.lcc.popStatementContext(this, throwable);
    }

    public boolean isLastHandler(int n) {
        return this.inUse && !this.rollbackParentContext && (n == 20000 || n == 0);
    }

    public boolean onStack() {
        return this.inUse;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    public String getStatementText() {
        return this.stmtText;
    }

    private void pleaseBeOnStack() throws StandardException {
        if (!this.inUse) {
            throw StandardException.newException("40XC0");
        }
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void setSQLAllowed(short s, boolean bl) {
        if (bl || s > this.sqlAllowed) {
            this.sqlAllowed = s;
        }
    }

    public short getSQLAllowed() {
        if (!this.inUse) {
            return 3;
        }
        return this.sqlAllowed;
    }

    public void setParentRollback() {
        this.rollbackParentContext = true;
    }

    public void setSystemCode() {
        this.isSystemCode = true;
    }

    public boolean getSystemCode() {
        return this.isSystemCode;
    }

    public StringBuffer appendErrorInfo() {
        StringBuffer stringBuffer = ((ContextImpl)((Object)this.lcc)).appendErrorInfo();
        if (stringBuffer != null) {
            stringBuffer.append("Failed Statement is: ");
            stringBuffer.append(this.getStatementText());
            if (this.pvs != null && this.pvs.getParameterCount() > 0) {
                String string = " with " + this.pvs.getParameterCount() + " parameters " + this.pvs.toString();
                stringBuffer.append(string);
            }
        }
        return stringBuffer;
    }
}

