/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.execute.JarDDL;

class JarUtil {
    private String schemaName;
    private String sqlName;
    private LanguageConnectionContext lcc;
    private FileResource fr;
    private DataDictionary dd;
    private DataDescriptorGenerator ddg;

    private JarUtil(String string, String string2) throws StandardException {
        this.schemaName = string;
        this.sqlName = string2;
        this.lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        this.fr = this.lcc.getTransactionExecute().getFileHandler();
        this.dd = this.lcc.getDataDictionary();
        this.ddg = this.dd.getDataDescriptorGenerator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long add(String string, String string2, String string3) throws StandardException {
        long l;
        JarUtil jarUtil = new JarUtil(string, string2);
        InputStream inputStream = null;
        try {
            try {
                inputStream = JarUtil.openJarURL(string3);
                l = jarUtil.add(inputStream);
                Object var8_7 = null;
            }
            catch (IOException iOException) {
                throw StandardException.newException("46001", iOException, (Object)string3);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return l;
        }
        if (inputStream == null) return l;
        inputStream.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long add(InputStream inputStream) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor != null) {
            throw StandardException.newException("X0Y32.S", fileInfoDescriptor.getDescriptorType(), (Object)this.sqlName, (Object)fileInfoDescriptor.getSchemaDescriptor().getDescriptorType(), (Object)this.schemaName);
        }
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            String string = JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar());
            long l = this.setJar(string, inputStream, true, 0L);
            fileInfoDescriptor = this.ddg.newFileInfoDescriptor(null, schemaDescriptor, this.sqlName, l);
            this.dd.addDescriptor(fileInfoDescriptor, schemaDescriptor, 12, false, this.lcc.getTransactionExecute());
            long l2 = l;
            return l2;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    static void drop(String string, String string2) throws StandardException {
        JarUtil jarUtil = new JarUtil(string, string2);
        jarUtil.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() throws StandardException {
        String[][] stringArray;
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", this.sqlName, (Object)this.schemaName);
        }
        String string = PropertyUtil.getServiceProperty(this.lcc.getTransactionExecute(), "derby.database.classpath");
        if (string != null) {
            stringArray = IdUtil.parseDbClassPath(string, this.lcc.getIdentifierCasing() != 1);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray.length != 2 || !stringArray[i][0].equals(this.schemaName) || !stringArray[i][1].equals(this.sqlName)) continue;
                bl = true;
            }
            if (bl) {
                throw StandardException.newException("X0X07.S", IdUtil.mkQualifiedName(this.schemaName, this.sqlName), (Object)string);
            }
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            stringArray = this.dd.getDependencyManager();
            stringArray.invalidateFor(fileInfoDescriptor, 17, this.lcc);
            this.dd.dropFileInfoDescriptor(fileInfoDescriptor);
            this.fr.remove(JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), fileInfoDescriptor.getGenerationId());
        }
        finally {
            this.notifyLoader(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long replace(String string, String string2, String string3) throws StandardException {
        long l;
        JarUtil jarUtil = new JarUtil(string, string2);
        InputStream inputStream = null;
        try {
            try {
                inputStream = JarUtil.openJarURL(string3);
                l = jarUtil.replace(inputStream);
                Object var8_7 = null;
            }
            catch (IOException iOException) {
                throw StandardException.newException("46001", iOException, (Object)string3);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return l;
        }
        if (inputStream == null) return l;
        inputStream.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replace(InputStream inputStream) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", this.sqlName, (Object)this.schemaName);
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            this.dd.dropFileInfoDescriptor(fileInfoDescriptor);
            String string = JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar());
            long l = this.setJar(string, inputStream, false, fileInfoDescriptor.getGenerationId());
            FileInfoDescriptor fileInfoDescriptor2 = this.ddg.newFileInfoDescriptor(fileInfoDescriptor.getUUID(), fileInfoDescriptor.getSchemaDescriptor(), this.sqlName, l);
            this.dd.addDescriptor(fileInfoDescriptor2, fileInfoDescriptor.getSchemaDescriptor(), 12, false, this.lcc.getTransactionExecute());
            long l2 = l;
            return l2;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    private FileInfoDescriptor getInfo() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        return this.dd.getFileInfoDescriptor(schemaDescriptor, this.sqlName);
    }

    private void notifyLoader(boolean bl) throws StandardException {
        ClassFactory classFactory = this.lcc.getLanguageConnectionFactory().getClassFactory();
        classFactory.notifyModifyJar(bl);
    }

    private static InputStream openJarURL(final String string) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return new URL(string).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        return new FileInputStream(string);
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private long setJar(final String string, final InputStream inputStream, final boolean bl, final long l) throws StandardException {
        try {
            return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    long l2 = bl ? JarUtil.this.fr.add(string, inputStream) : JarUtil.this.fr.replace(string, l, inputStream);
                    return new Long(l2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }
}

