/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11MechPar_PBE;
import com.ibm.pkcs11.PKCS11MechPar_RC2;
import com.ibm.pkcs11.PKCS11MechPar_RC2_CBC;
import com.ibm.pkcs11.PKCS11MechPar_RC2_GENMAC;
import com.ibm.pkcs11.PKCS11MechPar_RC5;
import com.ibm.pkcs11.PKCS11MechPar_RC5_CBC;
import com.ibm.pkcs11.PKCS11MechPar_RC5_GENMAC;
import com.ibm.pkcs11.PKCS11Object;
import java.lang.reflect.Field;
import java.math.BigInteger;

public abstract class PKCS11Mechanism {
    public static final int RSA_PKCS_KEY_PAIR_GEN = 0;
    public static final int RSA_PKCS = 1;
    public static final int RSA_9796 = 2;
    public static final int RSA_X_509 = 3;
    public static final int MD2_RSA_PKCS = 4;
    public static final int MD5_RSA_PKCS = 5;
    public static final int SHA1_RSA_PKCS = 6;
    public static final int RIPEMD128_RSA_PKCS = 7;
    public static final int RIPEMD160_RSA_PKCS = 8;
    public static final int RSA_PKCS_OAEP = 9;
    public static final int RSA_X9_31_KEY_PAIR_GEN = 10;
    public static final int RSA_X9_31 = 11;
    public static final int SHA1_RSA_X9_31 = 12;
    public static final int RSA_PKCS_PSS = 13;
    public static final int SHA1_RSA_PKCS_PSS = 14;
    public static final int DSA_KEY_PAIR_GEN = 16;
    public static final int DSA = 17;
    public static final int DSA_SHA1 = 18;
    public static final int DH_PKCS_KEY_PAIR_GEN = 32;
    public static final int DH_PKCS_DERIVE = 33;
    public static final int X9_42_DH_KEY_PAIR_GEN = 48;
    public static final int X9_42_DH_DERIVE = 49;
    public static final int X9_42_DH_HYBRID_DERIVE = 50;
    public static final int X9_42_MQV_DERIVE = 51;
    public static final int SHA256_RSA_PKCS = 64;
    public static final int SHA384_RSA_PKCS = 65;
    public static final int SHA512_RSA_PKCS = 66;
    public static final int SHA256_RSA_PKCS_PSS = 67;
    public static final int SHA384_RSA_PKCS_PSS = 68;
    public static final int SHA512_RSA_PKCS_PSS = 69;
    public static final int RC2_KEY_GEN = 256;
    public static final int RC2_ECB = 257;
    public static final int RC2_CBC = 258;
    public static final int RC2_MAC = 259;
    public static final int RC2_MAC_GENERAL = 260;
    public static final int RC2_CBC_PAD = 261;
    public static final int RC4_KEY_GEN = 272;
    public static final int RC4 = 273;
    public static final int DES_KEY_GEN = 288;
    public static final int DES_ECB = 289;
    public static final int DES_CBC = 290;
    public static final int DES_MAC = 291;
    public static final int DES_MAC_GENERAL = 292;
    public static final int DES_CBC_PAD = 293;
    public static final int DES2_KEY_GEN = 304;
    public static final int DES3_KEY_GEN = 305;
    public static final int DES3_ECB = 306;
    public static final int DES3_CBC = 307;
    public static final int DES3_MAC = 308;
    public static final int DES3_MAC_GENERAL = 309;
    public static final int DES3_CBC_PAD = 310;
    public static final int CDMF_KEY_GEN = 320;
    public static final int CDMF_ECB = 321;
    public static final int CDMF_CBC = 322;
    public static final int CDMF_MAC = 323;
    public static final int CDMF_MAC_GENERAL = 324;
    public static final int CDMF_CBC_PAD = 325;
    public static final int MD2 = 512;
    public static final int MD2_HMAC = 513;
    public static final int MD2_HMAC_GENERAL = 514;
    public static final int MD5 = 528;
    public static final int MD5_HMAC = 529;
    public static final int MD5_HMAC_GENERAL = 530;
    public static final int SHA_1 = 544;
    public static final int SHA_1_HMAC = 545;
    public static final int SHA_1_HMAC_GENERAL = 546;
    public static final int RIPEMD128 = 560;
    public static final int RIPEMD128_HMAC = 561;
    public static final int RIPEMD128_HMAC_GENERAL = 562;
    public static final int RIPEMD160 = 576;
    public static final int RIPEMD160_HMAC = 577;
    public static final int RIPEMD160_HMAC_GENERAL = 578;
    public static final int SHA256 = 592;
    public static final int SHA256_HMAC = 593;
    public static final int SHA256_HMAC_GENERAL = 594;
    public static final int SHA384 = 608;
    public static final int SHA384_HMAC = 609;
    public static final int SHA384_HMAC_GENERAL = 610;
    public static final int SHA512 = 624;
    public static final int SHA512_HMAC = 625;
    public static final int SHA512_HMAC_GENERAL = 626;
    public static final int CAST_KEY_GEN = 768;
    public static final int CAST_ECB = 769;
    public static final int CAST_CBC = 770;
    public static final int CAST_MAC = 771;
    public static final int CAST_MAC_GENERAL = 772;
    public static final int CAST_CBC_PAD = 773;
    public static final int CAST3_KEY_GEN = 784;
    public static final int CAST3_ECB = 785;
    public static final int CAST3_CBC = 786;
    public static final int CAST3_MAC = 787;
    public static final int CAST3_MAC_GENERAL = 788;
    public static final int CAST3_CBC_PAD = 789;
    public static final int CAST5_KEY_GEN = 800;
    public static final int CAST128_KEY_GEN = 800;
    public static final int CAST5_ECB = 801;
    public static final int CAST128_ECB = 801;
    public static final int CAST5_CBC = 802;
    public static final int CAST128_CBC = 802;
    public static final int CAST5_MAC = 803;
    public static final int CAST128_MAC = 803;
    public static final int CAST5_MAC_GENERAL = 804;
    public static final int CAST128_MAC_GENERAL = 804;
    public static final int CAST5_CBC_PAD = 805;
    public static final int CAST128_CBC_PAD = 805;
    public static final int RC5_KEY_GEN = 816;
    public static final int RC5_ECB = 817;
    public static final int RC5_CBC = 818;
    public static final int RC5_MAC = 819;
    public static final int RC5_MAC_GENERAL = 820;
    public static final int RC5_CBC_PAD = 821;
    public static final int IDEA_KEY_GEN = 832;
    public static final int IDEA_ECB = 833;
    public static final int IDEA_CBC = 834;
    public static final int IDEA_MAC = 835;
    public static final int IDEA_MAC_GENERAL = 836;
    public static final int IDEA_CBC_PAD = 837;
    public static final int GENERIC_SECRET_KEY_GEN = 848;
    public static final int CONCATENATE_BASE_AND_KEY = 864;
    public static final int CONCATENATE_BASE_AND_DATA = 866;
    public static final int CONCATENATE_DATA_AND_BASE = 867;
    public static final int XOR_BASE_AND_DATA = 868;
    public static final int EXTRACT_KEY_FROM_KEY = 869;
    public static final int SSL3_PRE_MASTER_KEY_GEN = 880;
    public static final int SSL3_MASTER_KEY_DERIVE = 881;
    public static final int SSL3_KEY_AND_MAC_DERIVE = 882;
    public static final int SSL3_MASTER_KEY_DERIVE_DH = 883;
    public static final int TLS_PRE_MASTER_KEY_GEN = 884;
    public static final int TLS_MASTER_KEY_DERIVE = 885;
    public static final int TLS_KEY_AND_MAC_DERIVE = 886;
    public static final int TLS_MASTER_KEY_DERIVE_DH = 887;
    public static final int TLS_PRF = 888;
    public static final int SSL3_MD5_MAC = 896;
    public static final int SSL3_SHA1_MAC = 897;
    public static final int MD5_KEY_DERIVATION = 912;
    public static final int MD2_KEY_DERIVATION = 913;
    public static final int SHA1_KEY_DERIVATION = 914;
    public static final int SHA256_KEY_DERIVATION = 915;
    public static final int SHA384_KEY_DERIVATION = 916;
    public static final int SHA512_KEY_DERIVATION = 917;
    public static final int PBE_MD2_DES_CBC = 928;
    public static final int PBE_MD5_DES_CBC = 929;
    public static final int PBE_MD5_CAST_CBC = 930;
    public static final int PBE_MD5_CAST3_CBC = 931;
    public static final int PBE_MD5_CAST5_CBC = 932;
    public static final int PBE_MD5_CAST128_CBC = 932;
    public static final int PBE_SHA1_CAST5_CBC = 933;
    public static final int PBE_SHA1_CAST128_CBC = 933;
    public static final int PBE_SHA1_RC4_128 = 934;
    public static final int PBE_SHA1_RC4_40 = 935;
    public static final int PBE_SHA1_DES3_EDE_CBC = 936;
    public static final int PBE_SHA1_DES2_EDE_CBC = 937;
    public static final int PBE_SHA1_RC2_128_CBC = 938;
    public static final int PBE_SHA1_RC2_40_CBC = 939;
    public static final int PKCS5_PBKD2 = 944;
    public static final int PBA_SHA1_WITH_SHA1_HMAC = 960;
    public static final int KEY_WRAP_LYNKS = 1024;
    public static final int KEY_WRAP_SET_OAEP = 1025;
    public static final int SKIPJACK_KEY_GEN = 4096;
    public static final int SKIPJACK_ECB64 = 4097;
    public static final int SKIPJACK_CBC64 = 4098;
    public static final int SKIPJACK_OFB64 = 4099;
    public static final int SKIPJACK_CFB64 = 4100;
    public static final int SKIPJACK_CFB32 = 4101;
    public static final int SKIPJACK_CFB16 = 4102;
    public static final int SKIPJACK_CFB8 = 4103;
    public static final int SKIPJACK_WRAP = 4104;
    public static final int SKIPJACK_PRIVATE_WRAP = 4105;
    public static final int SKIPJACK_RELAYX = 4106;
    public static final int KEA_KEY_PAIR_GEN = 4112;
    public static final int KEA_KEY_DERIVE = 4113;
    public static final int FORTEZZA_TIMESTAMP = 4128;
    public static final int BATON_KEY_GEN = 4144;
    public static final int BATON_ECB128 = 4145;
    public static final int BATON_ECB96 = 4146;
    public static final int BATON_CBC128 = 4147;
    public static final int BATON_COUNTER = 4148;
    public static final int BATON_SHUFFLE = 4149;
    public static final int BATON_WRAP = 4150;
    public static final int ECDSA_KEY_PAIR_GEN = 4160;
    public static final int EC_KEY_PAIR_GEN = 4160;
    public static final int ECDSA = 4161;
    public static final int ECDSA_SHA1 = 4162;
    public static final int ECDH1_DERIVE = 4176;
    public static final int ECDH1_COFACTOR_DERIVE = 4177;
    public static final int ECMQV_DERIVE = 4178;
    public static final int JUNIPER_KEY_GEN = 4192;
    public static final int JUNIPER_ECB128 = 4193;
    public static final int JUNIPER_CBC128 = 4194;
    public static final int JUNIPER_COUNTER = 4195;
    public static final int JUNIPER_SHUFFLE = 4196;
    public static final int JUNIPER_WRAP = 4197;
    public static final int FASTHASH = 4208;
    public static final int AES_KEY_GEN = 4224;
    public static final int AES_ECB = 4225;
    public static final int AES_CBC = 4226;
    public static final int AES_MAC = 4227;
    public static final int AES_MAC_GENERAL = 4228;
    public static final int AES_CBC_PAD = 4229;
    public static final int BLOWFISH_KEY_GEN = 4240;
    public static final int BLOWFISH_CBC = 4241;
    public static final int TWOFISH_KEY_GEN = 4242;
    public static final int TWOFISH_CBC = 4243;
    public static final int DSA_PARAMETER_GEN = 8192;
    public static final int DH_PKCS_PARAMETER_GEN = 8193;
    public static final int X9_42_DH_PARAMETER_GEN = 8194;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;

    public static String typeToString(int type) {
        Field[] mechanisms = PKCS11Mechanism.class.getFields();
        for (int i = 0; i < mechanisms.length; ++i) {
            try {
                if (!mechanisms[i].getType().getName().equals("int") || mechanisms[i].getInt(null) != type) continue;
                return mechanisms[i].getName();
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                break;
            }
        }
        return "0x" + Integer.toHexString(type);
    }

    public static Class paramClass(int type) throws PKCS11Exception {
        if ((type & Integer.MIN_VALUE) != 0) {
            return null;
        }
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 48: 
            case 64: 
            case 65: 
            case 66: 
            case 256: 
            case 272: 
            case 273: 
            case 288: 
            case 289: 
            case 291: 
            case 304: 
            case 305: 
            case 306: 
            case 308: 
            case 320: 
            case 321: 
            case 323: 
            case 512: 
            case 513: 
            case 528: 
            case 529: 
            case 544: 
            case 545: 
            case 560: 
            case 561: 
            case 576: 
            case 577: 
            case 592: 
            case 593: 
            case 608: 
            case 609: 
            case 624: 
            case 625: 
            case 768: 
            case 769: 
            case 771: 
            case 784: 
            case 785: 
            case 787: 
            case 800: 
            case 801: 
            case 803: 
            case 816: 
            case 832: 
            case 833: 
            case 835: 
            case 848: 
            case 912: 
            case 913: 
            case 914: 
            case 1024: 
            case 4096: 
            case 4104: 
            case 4112: 
            case 4128: 
            case 4144: 
            case 4150: 
            case 4160: 
            case 4161: 
            case 4162: 
            case 4192: 
            case 4197: 
            case 4208: 
            case 4224: 
            case 4225: 
            case 4227: 
            case 4240: 
            case 4242: 
            case 8192: 
            case 8193: 
            case 8194: {
                return null;
            }
            case 33: {
                return BigInteger.class;
            }
            case 292: 
            case 309: 
            case 324: 
            case 514: 
            case 530: 
            case 546: 
            case 562: 
            case 578: 
            case 594: 
            case 610: 
            case 626: 
            case 772: 
            case 788: 
            case 804: 
            case 836: 
            case 896: 
            case 897: 
            case 4228: {
                return Integer.class;
            }
            case 869: {
                return Integer.class;
            }
            case 864: {
                return PKCS11Object.class;
            }
            case 290: 
            case 293: 
            case 307: 
            case 310: 
            case 322: 
            case 325: 
            case 770: 
            case 773: 
            case 786: 
            case 789: 
            case 802: 
            case 805: 
            case 834: 
            case 837: 
            case 4226: 
            case 4229: 
            case 4241: 
            case 4243: {
                return byte[].class;
            }
            case 4097: 
            case 4098: 
            case 4099: 
            case 4100: 
            case 4101: 
            case 4102: 
            case 4103: 
            case 4145: 
            case 4146: 
            case 4147: 
            case 4148: 
            case 4149: 
            case 4193: 
            case 4194: 
            case 4195: 
            case 4196: {
                return byte[].class;
            }
            case 257: 
            case 259: {
                return PKCS11MechPar_RC2.class;
            }
            case 258: 
            case 261: {
                return PKCS11MechPar_RC2_CBC.class;
            }
            case 260: {
                return PKCS11MechPar_RC2_GENMAC.class;
            }
            case 817: 
            case 819: {
                return PKCS11MechPar_RC5.class;
            }
            case 818: 
            case 821: {
                return PKCS11MechPar_RC5_CBC.class;
            }
            case 820: {
                return PKCS11MechPar_RC5_GENMAC.class;
            }
            case 928: 
            case 929: 
            case 930: 
            case 931: 
            case 932: 
            case 933: 
            case 934: 
            case 935: 
            case 936: 
            case 937: 
            case 938: 
            case 939: 
            case 960: {
                return PKCS11MechPar_PBE.class;
            }
        }
        throw new PKCS11Exception("no parameter encoding available yet!");
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        sb.append("  * <TR> <TH> mechnism type     <TH> parameter type\n");
        Field[] mechanisms = PKCS11Mechanism.class.getFields();
        for (int i = 0; i < mechanisms.length; ++i) {
            if (!mechanisms[i].getType().getName().equals("int")) continue;
            sb.append("  * <TR> <TD> <TT>").append(mechanisms[i].getName());
            sb.append("</TT> <TD> ");
            try {
                String cn;
                Class c = PKCS11Mechanism.paramClass(mechanisms[i].getInt(null));
                if (c == null) {
                    cn = "null";
                } else {
                    cn = c.getName();
                    if ((cn = cn.substring(cn.lastIndexOf(46) + 1)).equals("[B")) {
                        cn = "byte[]";
                    }
                }
                sb.append("<TT>").append(cn).append("</TT>");
            }
            catch (PKCS11Exception e) {
                sb.append("<I>not yet defined</I>");
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            sb.append("\n");
        }
        sb.append("  * </TABLE> <P>\n");
        System.out.println(sb.toString());
    }
}

