/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.AuthenticatedSafe;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.BasicPFX;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.CrlBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.SafeContents;
import com.ibm.security.pkcs12.SafeContentsBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PKCS12PFX
extends BasicPFX
implements Cloneable {
    private static String SLASH = "/";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12PFX";

    public PKCS12PFX() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS12PFX");
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS12PFX", provider);
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(byte[] der) throws IOException {
        this();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS12PFX", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(byte[] der, String provider) throws IOException {
        this(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCS12PFX", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "PKCS12PFX", parms);
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCS12PFX", parms);
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            return new PKCS12PFX(derout.toByteArray(), this.provider);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public synchronized void addBag(Object obj, PKCSAttributes attrs) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "addBag", obj, attrs);
        }
        SafeBag[] bags = this.buildSafeBags(obj, attrs);
        this.addSafeBags(bags);
        if (debug != null) {
            debug.exit(16384L, className, "addBag");
        }
    }

    public synchronized void addBagWithPasswordPrivacy(Object obj, PKCSAttributes attrs, String cipherAlg, char[] pwd) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{obj, attrs, cipherAlg, pwd};
            debug.entry(16384L, (Object)className, "addBagWithPasswordPrivacy", parms);
        }
        SafeBag[] bags = this.buildSafeBags(obj, attrs);
        this.addSafeBagsWithPasswordPrivacy(bags, cipherAlg, pwd);
        if (debug != null) {
            debug.exit(16384L, className, "addBagWithPasswordPrivacy");
        }
    }

    public synchronized void addBagWithPubkeyPrivacy(Object obj, PKCSAttributes attrs, Certificate[] certs) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{obj, attrs, certs};
            debug.entry(16384L, (Object)className, "addBagWithPubkeyPrivacy", parms);
        }
        SafeBag[] bags = this.buildSafeBags(obj, attrs);
        this.addSafeBagsWithPubkeyPrivacy(bags, certs);
        if (debug != null) {
            debug.exit(16384L, className, "addBagWithPubkeyPrivacy");
        }
    }

    public synchronized void addSafeBags(SafeBag[] bags) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addSafeBags", bags);
        }
        SafeContents safeContents = new SafeContents(bags, this.provider);
        byte[] contents = safeContents.encode();
        Data data = new Data(this.provider);
        data.setData(contents);
        ContentInfo cinfo = new ContentInfo(data, this.provider);
        this.addContentToAuthSafe(cinfo);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBags");
        }
    }

    public synchronized void addSafeBagsWithPasswordPrivacy(SafeBag[] bags, String cipherAlg, char[] pwd) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{bags, cipherAlg, pwd};
            debug.entry(16384L, (Object)className, "addSafeBagsWithPasswordPrivacy", parms);
        }
        super.addSafeBagsWithPasswordPrivacy(bags, cipherAlg, pwd);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBagsWithPasswordPrivacy");
        }
    }

    public synchronized void addSafeBagsWithPubkeyPrivacy(SafeBag[] bags, Certificate[] certs) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "addSafeBagsWithPubkeyPrivacy", bags, certs);
        }
        SafeContents safeContents = new SafeContents(bags, this.provider);
        byte[] contents = safeContents.encode();
        Data data = new Data(this.provider);
        data.setData(contents);
        ContentInfo cinfo = new ContentInfo(data, this.provider);
        EnvelopedData envData = new EnvelopedData(certs, cinfo, "DESede", 168, null, this.provider);
        ContentInfo cinfo2 = new ContentInfo(envData, this.provider);
        this.addContentToAuthSafe(cinfo2);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBagsWithPubkeyPrivacy");
        }
    }

    public synchronized void applySignature(String digestAlg, String signatureAlg, Certificate cert, PrivateKey key) throws PKCSException, NoSuchAlgorithmException, IOException {
        ContentInfo cinfo;
        if (debug != null) {
            Object[] parms = new Object[]{digestAlg, signatureAlg, cert, key};
            debug.entry(16384L, (Object)className, "applySignature", parms);
        }
        this.macData = null;
        this.authSafe = this.authSafeContents.toContentInfo();
        String alg = digestAlg + SLASH + signatureAlg;
        SignedData signedData = new SignedData(cert, this.authSafe, alg, key, false, this.provider);
        this.authSafe = cinfo = new ContentInfo(signedData, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "applySignature");
        }
    }

    public boolean verifySignature(Certificate cert) throws IOException, PKCSException, NoSuchAlgorithmException {
        ContentInfo cinfo;
        boolean verified = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifySignature", cert);
        }
        SignedData signedData = null;
        if (this.authSafe.getContentType().equals(PKCSOID.SIGNED_DATA_OID)) {
            signedData = (SignedData)this.authSafe.getContent();
            verified = signedData.verify(cert);
        }
        if (verified && (cinfo = signedData.getEncapsulatedContentInfo().getContentInfo()).getContentType().equals(PKCSOID.DATA_OID)) {
            Data data = (Data)cinfo.getContent();
            this.verifiedContents = new AuthenticatedSafe(data.getData(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verifySignature", verified);
        }
        return verified;
    }

    public boolean hasDigitalSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "hasDigitalSignature");
        }
        if (this.authSafe != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasDigitalSignature_1", this.authSafe.getContentType().equals(PKCSOID.SIGNED_DATA_OID));
            }
            return this.authSafe.getContentType().equals(PKCSOID.SIGNED_DATA_OID);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasDigitalSignature_2", false);
        }
        return false;
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.authSafe == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Data integrity protection must be applied to this PFX before encoding.");
            }
            throw new IOException("Data integrity protection must be applied to this PFX before encoding.");
        }
        super.encode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
            debug.exit(16384L, (Object)className, "equals", super.equals(other));
        }
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString());
        }
        return super.toString();
    }

    public synchronized void applyMac(char[] pwd) throws PKCSException, NoSuchAlgorithmException, IOException {
        int iterations = 2000;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "applyMac", (Object)pwd);
        }
        super.applyMac(pwd, iterations);
        if (debug != null) {
            debug.exit(16384L, className, "applyMac");
        }
    }

    public boolean verifyMac(char[] pwd) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifyMac", (Object)pwd);
            debug.exit(16384L, (Object)className, "verifyMac", super.verifyMac(pwd));
        }
        return super.verifyMac(pwd);
    }

    public MacData getMacData() {
        if (debug != null) {
            debug.entry(16384L, className, "getMacData");
            debug.exit(16384L, (Object)className, "getMacData", super.getMacData());
        }
        return super.getMacData();
    }

    public Certificate[] getCertificates(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, className, "getCertificates");
        }
        if (pwd != null || key != null || cert != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates_1", super.getCertificates(pwd, key, cert, true));
            }
            return super.getCertificates(pwd, key, cert, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates_2", super.getCertificates(pwd, key, cert, false));
        }
        return super.getCertificates(pwd, key, cert, false);
    }

    public Certificate[] getAllCertificates(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getAllCertificates", parms);
            debug.exit(16384L, (Object)className, "getAllCertificates", super.getCertificates(pwd, key, cert, false));
        }
        return super.getCertificates(pwd, key, cert, false);
    }

    public CRL[] getCRLs(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getCRLs", parms);
        }
        if (pwd != null || key != null || cert != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs_1", super.getCRLs(pwd, key, cert, true));
            }
            return super.getCRLs(pwd, key, cert, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs_2", super.getCRLs(pwd, key, cert, false));
        }
        return super.getCRLs(pwd, key, cert, false);
    }

    public CRL[] getAllCRLs(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getAllCRLs", parms);
            debug.exit(16384L, (Object)className, "getAllCRLs", super.getCRLs(pwd, key, cert, false));
        }
        return super.getCRLs(pwd, key, cert, false);
    }

    public PrivateKeyInfo[] getPrivateKeys(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getPrivateKeys", parms);
        }
        if (pwd != null || key != null || cert != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeys_1", super.getPrivateKeys(pwd, key, cert, true));
            }
            return super.getPrivateKeys(pwd, key, cert, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPrivateKeys_2", super.getPrivateKeys(pwd, key, cert, false));
        }
        return super.getPrivateKeys(pwd, key, cert, false);
    }

    public PrivateKeyInfo[] getAllPrivateKeys(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getAllPrivateKeys", parms);
            debug.exit(16384L, (Object)className, "getAllPrivateKeys", super.getPrivateKeys(pwd, key, cert, false));
        }
        return super.getPrivateKeys(pwd, key, cert, false);
    }

    public EncryptedPrivateKeyInfo[] getShroudedKeys(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getShroudedKeys", parms);
        }
        if (pwd != null || key != null || cert != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeys_1", super.getShroudedKeys(pwd, key, cert, true));
            }
            return super.getShroudedKeys(pwd, key, cert, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeys_2", super.getShroudedKeys(pwd, key, cert, false));
        }
        return super.getShroudedKeys(pwd, key, cert, false);
    }

    public EncryptedPrivateKeyInfo[] getAllShroudedKeys(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getAllShroundedKeys", parms);
            debug.exit(16384L, (Object)className, "getAllShroundedKeys", super.getShroudedKeys(pwd, key, cert, false));
        }
        return super.getShroudedKeys(pwd, key, cert, false);
    }

    public SafeContents[] getSafeContents(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getSafeContents", parms);
        }
        if (pwd != null || key != null || cert != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSafeContents_1", super.getSafeContents(pwd, key, cert, true));
            }
            return super.getSafeContents(pwd, key, cert, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeContents_2", super.getSafeContents(pwd, key, cert, false));
        }
        return super.getSafeContents(pwd, key, cert, false);
    }

    public SafeContents[] getAllSafeContents(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getAllSafeContents", parms);
            debug.exit(16384L, (Object)className, "getAllSafeContents", super.getSafeContents(pwd, key, cert, false));
        }
        return super.getSafeContents(pwd, key, cert, false);
    }

    public SafeBag[] getSafeBags(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getSafeBags", parms);
        }
        if (pwd != null || key != null || cert != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSafeBags_1", super.getSafeBags(pwd, key, cert, true));
            }
            return super.getSafeBags(pwd, key, cert, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeBags_2", super.getSafeBags(pwd, key, cert, false));
        }
        return super.getSafeBags(pwd, key, cert, false);
    }

    public SafeBag[] getAllSafeBags(char[] pwd, PrivateKey key, Certificate cert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert};
            debug.entry(16384L, (Object)className, "getAllSafeBags", parms);
            debug.exit(16384L, (Object)className, "getAllSafeBags", super.getSafeBags(pwd, key, cert, false));
        }
        return super.getSafeBags(pwd, key, cert, false);
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        super.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private SafeBag[] buildSafeBags(Object obj, PKCSAttributes attrs) throws PKCSException, IOException {
        PKCSDerObject bag;
        if (debug != null) {
            debug.entry(16384L, className, "buildSafeBags", obj, attrs);
        }
        if (obj instanceof PrivateKeyInfo) {
            bag = new KeyBag((PrivateKeyInfo)obj, this.provider);
        } else if (obj instanceof EncryptedPrivateKeyInfo) {
            bag = new ShroudedKeyBag((EncryptedPrivateKeyInfo)obj, this.provider);
        } else if (obj instanceof Certificate) {
            bag = new CertBag((Certificate)obj, this.provider);
        } else if (obj instanceof CRL) {
            bag = new CrlBag((CRL)obj, this.provider);
        } else if (obj instanceof SafeContents) {
            bag = new SafeContentsBag((SafeContents)obj, this.provider);
        } else {
            String name = obj.getClass().getName();
            if (debug != null) {
                debug.text(16384L, className, "buildSafeBags", "Unsupported input object class: " + name);
            }
            throw new IllegalArgumentException("Unsupported input object class: " + name);
        }
        SafeBag[] safeBag = new SafeBag[]{new SafeBag((Bag)((Object)bag), attrs, this.provider)};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "buildSafeBags", safeBag);
        }
        return safeBag;
    }

    ContentInfo protectWithPasswordPrivacy(byte[] contents, String digestAlg, String cipherAlg, char[] pwd) throws IOException, PKCSException, NoSuchAlgorithmException {
        AlgorithmId algid;
        AlgorithmId tmpAlgId;
        byte[] encryptedContents;
        Cipher cipher;
        SecretKey key;
        AlgorithmParameters params = null;
        if (debug != null) {
            Object[] parms = new Object[]{contents, digestAlg, cipherAlg, pwd};
            debug.entry(16384L, (Object)className, "protectWithPasswordPrivacy", parms);
        }
        String cipherName = "PBEWith" + digestAlg + "And" + cipherAlg;
        PBEKeySpec keySpec = new PBEKeySpec(pwd);
        try {
            SecretKeyFactory keyFact = this.provider != null ? SecretKeyFactory.getInstance("PBEWithSha1AndRC2", this.provider) : SecretKeyFactory.getInstance("PBEWithSha1AndRC2");
            key = keyFact.generateSecret(keySpec);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e2);
            }
            throw new PKCSException(e2, "Unable to encrypt bag contents (" + e2.toString() + ")");
        }
        int saltLen = 8;
        String alg = cipherAlg.toUpperCase(Locale.US);
        if (alg.indexOf("DES") != -1) {
            saltLen = 20;
        }
        byte[] salt = new byte[saltLen];
        SecureRandom random = null;
        try {
            random = this.provider != null ? SecureRandom.getInstance("IBMSecureRandom", this.provider) : SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", nsae);
            }
            random = new SecureRandom();
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", nspe);
            }
            throw new PKCSException("provider " + this.provider + " not found");
        }
        random.nextBytes(salt);
        int num = random.nextInt();
        BigInteger tmp = BigInteger.valueOf(num);
        BigInteger tmp2 = BigInteger.valueOf(100L);
        int iCount = 2000;
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iCount);
        try {
            params = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
            params.init(paramSpec);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e2);
            }
            throw new PKCSException(e2, "Unable to encrypt bag contents (" + e2.toString() + ")");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance(cipherName, this.provider) : Cipher.getInstance(cipherName);
            cipher.init(1, (Key)key, params);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e2);
            }
            throw new PKCSException(e2, "Unable to encrypt bag contents (" + e2.toString() + ")");
        }
        try {
            encryptedContents = cipher.doFinal(contents);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e);
            }
            throw new PKCSException(e, "Unable to encrypt bag contents (" + e.toString() + ")");
        }
        AlgorithmParameters cipherParams = cipher.getParameters();
        byte[] encodedParms = null;
        if (cipherParams != null) {
            encodedParms = cipherParams.getEncoded();
        }
        try {
            tmpAlgId = AlgorithmId.get(cipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e);
            }
            throw new PKCSException(e, "Unsupported password-based encryption algorithm: " + cipher.getAlgorithm());
        }
        if (encodedParms != null) {
            ObjectIdentifier oid = tmpAlgId.getOID();
            algid = new AlgorithmId(oid, encodedParms, this.provider);
        } else {
            algid = tmpAlgId;
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSOID.DATA_OID, algid, encryptedContents, this.provider);
        EncryptedData encryptedData = new EncryptedData(eci, null, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protectWithPasswordPrivacy", new ContentInfo(encryptedData, this.provider));
        }
        return new ContentInfo(encryptedData, this.provider);
    }

    private ContentInfo[] getPFXContents() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getPFXContents");
        }
        if (this.verifiedContents != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPFXContents_1", this.verifiedContents.getContentInfos());
            }
            return this.verifiedContents.getContentInfos();
        }
        if (this.authSafe != null) {
            Data data;
            if (this.authSafe.getContentType().equals(PKCSOID.DATA_OID)) {
                data = (Data)this.authSafe.getContent();
            } else {
                SignedData sd = (SignedData)this.authSafe.getContent();
                ContentInfo cinfo = sd.getEncapsulatedContentInfo().getContentInfo();
                data = (Data)cinfo.getContent();
            }
            AuthenticatedSafe as = new AuthenticatedSafe(data.getData(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPFXContents_2", as.getContentInfos());
            }
            return as.getContentInfos();
        }
        if (this.authSafeContents != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPFXContents_3", this.authSafeContents.getContentInfos());
            }
            return this.authSafeContents.getContentInfos();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPFXContents_4", new ContentInfo[0]);
        }
        return new ContentInfo[0];
    }
}

