/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class SafeBag
extends PKCSDerObject
implements Cloneable {
    private Bag bag;
    private ObjectIdentifier oid;
    private Object value;
    private byte[] encodedValue;
    private PKCSAttributes attrSet;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SafeBag";
    private volatile int cachedHashVal = 0;

    public SafeBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(Bag bag, PKCSAttributes attrs) throws IOException {
        this(bag, attrs, null);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", bag, attrs);
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(Bag bag, PKCSAttributes attrs, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{bag, attrs, provider};
            debug.entry(16384L, (Object)className, "SafeBag", parms);
        }
        this.bag = bag;
        ObjectIdentifier bagOid = bag.getObjectIdentifier();
        this.oid = bagOid.equals(PKCSOID.X509CERTBAG_OID) || bagOid.equals(PKCSOID.SDSICERTBAG_OID) || bagOid.equals(PKCSOID.X509_CERT_OID) || bagOid.equals(PKCSOID.SDSI_CERT_OID) ? PKCSOID.CERTBAG_OID : (bagOid.equals(PKCSOID.X509CRLBAG_OID) || bagOid.equals(PKCSOID.X509_CRL_OID) ? PKCSOID.CRLBAG_OID : bagOid);
        this.value = bag.getValue();
        DerOutputStream derout = new DerOutputStream();
        PKCSDerObject pbag = (PKCSDerObject)((Object)bag);
        pbag.encode(derout);
        byte[] encoding = derout.toByteArray();
        this.encodedValue = encoding;
        this.attrSet = attrs;
        if (debug != null) {
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", filename, new Boolean(base64));
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", filename, new Boolean(base64));
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public void encode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        bytes.putOID(this.oid);
        DerOutputStream tmpout = new DerOutputStream();
        tmpout.write(this.encodedValue);
        DerValue der = new DerValue(this.encodedValue);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        if (this.attrSet != null) {
            this.attrSet.encode(bytes);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public SafeBag addAttributes(PKCSAttribute[] attrs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttributes", attrs);
        }
        SafeBag sb = (SafeBag)this.clone();
        if (attrs == null || attrs.length == 0) {
            return sb;
        }
        if (sb.attrSet == null) {
            sb.attrSet = new PKCSAttributes(attrs, this.provider);
        } else {
            for (int i = 0; i < attrs.length; ++i) {
                sb.attrSet = sb.attrSet.addAttribute(attrs[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttributes", sb);
        }
        return sb;
    }

    public SafeBag replaceAttributes(PKCSAttributes attrs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "replaceAttributes", attrs);
        }
        SafeBag sb = (SafeBag)this.clone();
        sb.attrSet = attrs;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "replaceAttributes", sb);
        }
        return sb;
    }

    public PKCSAttributes getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
        }
        if (this.attrSet == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttributes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttributes_2", (PKCSAttributes)this.attrSet.clone());
        }
        return (PKCSAttributes)this.attrSet.clone();
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier myoid = null;
        try {
            myoid = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception e) {
            myoid = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", myoid);
        }
        return myoid;
    }

    public byte[] getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", (byte[])this.encodedValue.clone());
        }
        return (byte[])this.encodedValue.clone();
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof SafeBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SafeBag)other));
            }
            return this.equals((SafeBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SafeBag retobj = new SafeBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        String out = "";
        HexDumpEncoder hd = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.bag != null) {
            out = out + this.bag.toString();
        } else {
            out = out + "SafeBag:";
            out = out + "\r\nobject identifier: " + this.oid;
            out = out + "\r\ncontents:";
            out = out + "\r\n";
            out = out + hd.encodeBuffer(this.encodedValue);
        }
        out = out + "\r\n";
        if (this.attrSet != null) {
            out = out + "attributes:";
            out = out + "\r\n";
            out = out + this.attrSet.toString();
        } else {
            out = out + "no attributes";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SafeBag parsing error, not a SEQUENCE");
            }
            throw new IOException("SafeBag parsing error, not a SEQUENCE");
        }
        this.oid = encoding.getData().getOID();
        DerValue der = encoding.getData().getDerValue();
        if (der.isContextSpecific((byte)0)) {
            DerValue der2 = der.getData().getDerValue();
            this.encodedValue = der2.toByteArray();
        } else {
            this.encodedValue = der.toByteArray();
        }
        if (encoding.getData().available() != 0) {
            this.attrSet = new PKCSAttributes(encoding.getData(), this.provider);
        }
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SafeBag parsing error - data overrun, bytes = " + encoding.getData().available());
            }
            throw new IOException("SafeBag parsing error - data overrun, bytes = " + encoding.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SafeBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

