/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.SafeContents;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class SafeContentsBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid = PKCSOID.SAFECONTENTSBAG_OID;
    private SafeContents value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SafeContentsBag";
    private volatile int cachedHashVal = 0;

    public SafeContentsBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContentsBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public SafeContentsBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContentsBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public SafeContentsBag(SafeContents contents) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContentsBag", contents);
            debug.exit(16384L, className, "SafeContentsBag");
        }
        this.value = contents;
    }

    public SafeContentsBag(SafeContents contents, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContentsBag", contents, provider);
            debug.exit(16384L, className, "SafeContentsBag");
        }
        this.value = contents;
    }

    public SafeContentsBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContentsBag", filename, new Boolean(base64));
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public SafeContentsBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SafeContentsBag", parms);
            debug.exit(16384L, className, "SafeContentsBag");
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.value.encode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier an_oid = null;
        try {
            an_oid = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception e) {
            an_oid = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", an_oid);
        }
        return an_oid;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    public byte[] getEncodedValue() {
        DerOutputStream derout = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        try {
            this.value.encode(derout);
            byte[] retval = derout.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_1", retval);
            }
            return retval;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", e);
                debug.exit(16384L, (Object)className, "getEncodedValue_2", null);
            }
            return null;
        }
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "SafeContentsBag");
        }
        return "SafeContentsBag";
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof SafeContentsBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SafeContentsBag)other));
            }
            return this.equals((SafeContentsBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SafeContentsBag retobj = new SafeContentsBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "SafeContentsBag:";
        out = out + "\r\nobject identifier: " + this.oid;
        out = out + "\r\nsafe contents:\r\n";
        out = out + this.value.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        this.value = new SafeContents(encoding.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SafeContentsBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

