/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;

public final class ContentInfo
extends PKCSDerObject
implements Cloneable {
    private ObjectIdentifier contentType;
    private Content content;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.ContentInfo";

    public ContentInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentInfo", (Object)der);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", der, provider);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(ObjectIdentifier contentType, byte[] bytes) throws IOException {
        this(contentType, bytes, null);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", contentType, bytes);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(ObjectIdentifier contentType, byte[] bytes, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", contentType, bytes);
        }
        this.contentType = contentType;
        if (bytes == null) {
            this.content = null;
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_1");
            }
            return;
        }
        if (PKCS7.isData(contentType)) {
            this.content = new Data(this.provider);
            Data data = (Data)this.content;
            try {
                data.setData(bytes);
            }
            catch (PKCSException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "ContentInfo", e);
                }
                throw new IOException("Error setting data bytes for Data content type.");
            }
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_2");
            }
            return;
        }
        if (PKCS7.isSignedData(contentType)) {
            this.content = new SignedData(bytes, this.provider);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_3");
            }
            return;
        }
        if (PKCS7.isEnvelopedData(contentType)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.EnvelopedData", bytes);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_4");
            }
            return;
        }
        if (PKCS7.isSignedAndEnvelopedData(contentType)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.SignedAndEnvelopedData", bytes);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_5");
            }
            return;
        }
        if (PKCS7.isDigestedData(contentType)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.DigestedData", bytes);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_6");
            }
            return;
        }
        if (PKCS7.isEncryptedData(contentType)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.EncryptedData", bytes);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_7");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "ContentInfo", "Unknown content type " + contentType);
        }
        throw new IllegalArgumentException("Unknown content type " + contentType);
    }

    private Content createDynamicObject(String className, byte[] bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "createDynamicObject", className, bytes);
        }
        Object obj = null;
        try {
            Class<?> edclass = Class.forName(className);
            if (edclass == null) {
                if (debug != null) {
                    debug.text(8192L, className, "createDynamicObject", "Could not find class " + className);
                }
                throw new IOException("Could not find class " + className);
            }
            Class[] params = new Class[]{byte[].class};
            Constructor<?> constructor = edclass.getConstructor(params);
            Object[] consargs = new Object[]{bytes};
            obj = constructor.newInstance(consargs);
        }
        catch (ClassNotFoundException e1) {
            if (debug != null) {
                debug.exception(8192L, className, "createDynamicObject", e1);
            }
            throw new IOException(e1.toString());
        }
        catch (NoSuchMethodException e2) {
            if (debug != null) {
                debug.exception(8192L, className, "createDynamicObject", e2);
            }
            throw new IOException(e2.toString());
        }
        catch (InstantiationException e3) {
            if (debug != null) {
                debug.exception(8192L, className, "createDynamicObject", e3);
            }
            throw new IOException(e3.toString());
        }
        catch (IllegalAccessException e4) {
            if (debug != null) {
                debug.exception(8192L, className, "createDynamicObject", e4);
            }
            throw new IOException(e4.toString());
        }
        catch (InvocationTargetException e5) {
            if (debug != null) {
                debug.exception(8192L, className, "createDynamicObject", e5);
            }
            throw new IOException(e5.toString());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createDynamicObject", obj);
        }
        return obj;
    }

    public ContentInfo(Content content) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentInfo", content);
        }
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(Content content, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", content, provider);
        }
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    private ContentInfo(Object objcontent) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "ContentInfo", objcontent);
        }
        if (!(objcontent instanceof Content)) {
            if (debug != null) {
                debug.text(8192L, className, "ContentInfo", "objcontent not of Content type");
            }
            throw new IllegalArgumentException("objcontent not of Content type");
        }
        Content content = (Content)objcontent;
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(8192L, className, "ContentInfo");
        }
    }

    private ContentInfo(Object objcontent, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(8192L, className, "ContentInfo", objcontent, provider);
        }
        if (!(objcontent instanceof Content)) {
            if (debug != null) {
                debug.text(8192L, className, "ContentInfo", "objcontent not of Content type");
            }
            throw new IllegalArgumentException("objcontent not of Content type");
        }
        Content content = (Content)objcontent;
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(8192L, className, "ContentInfo");
        }
    }

    public ContentInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "ContentInfo", parms);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ContentInfo result = new ContentInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof ContentInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((ContentInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        try {
            DerOutputStream thisOut = new DerOutputStream();
            this.encode(thisOut);
            int HashVal = Arrays.hashCode(thisOut.toByteArray());
            return HashVal;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOID(this.contentType);
        if (this.content != null) {
            DerOutputStream tmpout = new DerOutputStream();
            this.content.encode(tmpout);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        DerValue opt;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "ContentInfo parsing error.  Expecting the sequence tag.");
            }
            throw new IOException("ContentInfo parsing error.  Expecting the sequence tag.");
        }
        this.contentType = encoding.getData().getOID();
        if (encoding.getData().available() != 0 && (opt = encoding.getData().getDerValue()).isContextSpecific((byte)0) && opt.isConstructed()) {
            DerValue der = opt.getData().getDerValue();
            this.content = this.createContent(this.contentType, der);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private Content createContent(ObjectIdentifier oid, DerValue der) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "createContent", oid, der);
        }
        if (PKCS7.isData(oid)) {
            byte[] dataBytes = der.getOctetString();
            Data data = new Data(this.provider);
            try {
                data.setData(dataBytes);
            }
            catch (PKCSException e) {
                if (debug != null) {
                    debug.exception(8192L, className, "createContent", e);
                    debug.text(8192L, className, "createContent", "Error setting data bytes for Data content type.");
                }
                throw new IOException("Error setting data bytes for Data content type.");
            }
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", data);
            }
            return data;
        }
        if (PKCS7.isSignedData(oid)) {
            SignedData result = new SignedData(der.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", result);
            }
            return result;
        }
        if (PKCS7.isEnvelopedData(oid)) {
            Content result = this.createDynamicObject("com.ibm.security.pkcs7.EnvelopedData", der.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", result);
            }
            return result;
        }
        if (PKCS7.isSignedAndEnvelopedData(oid)) {
            Content result = this.createDynamicObject("com.ibm.security.pkcs7.SignedAndEnvelopedData", der.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", result);
            }
            return result;
        }
        if (PKCS7.isDigestedData(oid)) {
            Content result = this.createDynamicObject("com.ibm.security.pkcs7.DigestedData", der.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", result);
            }
            return result;
        }
        if (PKCS7.isEncryptedData(oid)) {
            Content result = this.createDynamicObject("com.ibm.security.pkcs7.EncryptedData", der.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", result);
            }
            return result;
        }
        if (debug != null) {
            debug.text(8192L, className, "createContent", "Unknown object identifier " + oid);
        }
        throw new IllegalArgumentException("Unknown object identifier " + oid);
    }

    public ObjectIdentifier getContentType() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
            debug.exit(16384L, (Object)className, "getContentType", this.contentType);
        }
        return this.contentType;
    }

    public Content getContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getContent");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", null);
            }
            return null;
        }
        if (this.isData()) {
            Data result = (Data)((Data)this.content).clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", result);
            }
            return result;
        }
        if (this.isSignedData()) {
            SignedData result = (SignedData)((SignedData)this.content).clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", result);
            }
            return result;
        }
        if (this.isEnvelopedData()) {
            Content result = this.getDynamicClone("com.ibm.security.pkcs7.EnvelopedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", result);
            }
            return result;
        }
        if (this.isSignedAndEnvelopedData()) {
            Content result = this.getDynamicClone("com.ibm.security.pkcs7.SignedAndEnvelopedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", result);
            }
            return result;
        }
        if (this.isDigestedData()) {
            Content result = this.getDynamicClone("com.ibm.security.pkcs7.DigestedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", result);
            }
            return result;
        }
        if (this.isEncryptedData()) {
            Content result = this.getDynamicClone("com.ibm.security.pkcs7.EncryptedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", result);
            }
            return result;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContent_1", null);
        }
        return null;
    }

    private Content getDynamicClone(String classname, Content contentToBeCloned) {
        if (debug != null) {
            debug.entry(8192L, className, "getDynamicClone", classname, contentToBeCloned);
        }
        try {
            Class<?> edclass = Class.forName(classname);
            if (edclass == null) {
                if (debug != null) {
                    debug.text(8192L, className, "getDynamicClone", "Could not find class " + classname);
                }
                throw new IllegalArgumentException("Could not find class " + classname);
            }
            Class[] params = new Class[]{};
            Method method = edclass.getMethod("clone", params);
            Object[] methodargs = new Object[]{};
            Content result = (Content)method.invoke((Object)contentToBeCloned, methodargs);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDynamicClone", result);
            }
            return result;
        }
        catch (ClassNotFoundException e1) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", e1);
            }
            throw new IllegalArgumentException(e1.toString());
        }
        catch (NoSuchMethodException e2) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", e2);
            }
            throw new IllegalArgumentException(e2.toString());
        }
        catch (IllegalAccessException e4) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", e4);
            }
            throw new IllegalArgumentException(e4.toString());
        }
        catch (InvocationTargetException e5) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", e5);
            }
            throw new IllegalArgumentException(e5.toString());
        }
    }

    public boolean isData() {
        if (debug != null) {
            debug.entry(16384L, className, "isData");
            debug.exit(16384L, (Object)className, "isData", new Boolean(PKCS7.isData(this.contentType)));
        }
        return PKCS7.isData(this.contentType);
    }

    public boolean isSignedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isSignedData");
            debug.exit(16384L, (Object)className, "isSignedData", new Boolean(PKCS7.isSignedData(this.contentType)));
        }
        return PKCS7.isSignedData(this.contentType);
    }

    public boolean isEnvelopedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isEnvelopedData");
            debug.exit(16384L, (Object)className, "isEnvelopedData", new Boolean(PKCS7.isEnvelopedData(this.contentType)));
        }
        return PKCS7.isEnvelopedData(this.contentType);
    }

    public boolean isSignedAndEnvelopedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isSignedAndEnvelopedData");
            debug.exit(16384L, (Object)className, "isSignedAnd EnvelopedData", new Boolean(PKCS7.isSignedAndEnvelopedData(this.contentType)));
        }
        return PKCS7.isSignedAndEnvelopedData(this.contentType);
    }

    public boolean isDigestedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isDigestedData");
            debug.exit(16384L, (Object)className, "isDigestedData", new Boolean(PKCS7.isDigestedData(this.contentType)));
        }
        return PKCS7.isDigestedData(this.contentType);
    }

    public boolean isEncryptedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isEncryptedData");
            debug.exit(16384L, (Object)className, "isEncryptedData", new Boolean(PKCS7.isEncryptedData(this.contentType)));
        }
        return PKCS7.isEncryptedData(this.contentType);
    }

    public String getContentTypeString() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentTypeString");
        }
        if (this.isData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Data");
            }
            return "Data";
        }
        if (this.isSignedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Signed Data");
            }
            return "Signed Data";
        }
        if (this.isEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Enveloped Data");
            }
            return "Enveloped Data";
        }
        if (this.isSignedAndEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Signed and Enveloped Data");
            }
            return "Signed and Enveloped Data";
        }
        if (this.isDigestedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Digested Data");
            }
            return "Digested Data";
        }
        if (this.isEncryptedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Encrypted Data");
            }
            return "Encrypted Data";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentTypeString", null);
        }
        return null;
    }

    public String toString() {
        String out = "";
        out = out + "PKCS7 ContentInfo:  " + this.getContentTypeString() + "\r\n";
        out = out + "\tOID = " + this.contentType.toString() + "\r\n";
        if (this.content != null) {
            out = out + "\tContent = \r\n";
            out = out + this.content.toString();
        } else {
            out = out + "\n\tContent = null";
        }
        return out;
    }

    public ContentInfo encrypt(Certificate[] recipientCerts, String encryptionAlgorithm, int keySize) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{recipientCerts, encryptionAlgorithm, new Integer(keySize)};
            debug.entry(16384L, (Object)className, "encrypt", parms);
        }
        ContentInfo ci = (ContentInfo)this.clone();
        try {
            String edstr = "com.ibm.security.pkcs7.EnvelopedData";
            Class<?> edclass = Class.forName(edstr);
            if (edclass == null) {
                if (debug != null) {
                    debug.text(16384L, className, "encrypt", "Could not find class " + edstr);
                }
                throw new PKCSException("Could not find class " + edstr);
            }
            Class[] params = new Class[]{Certificate[].class, Class.forName("com.ibm.security.pkcs7.ContentInfo"), Class.forName("java.lang.String"), Integer.TYPE, Class.forName("com.ibm.security.pkcsutil.PKCSAttributes")};
            Constructor<?> constructor = edclass.getConstructor(params);
            Object attribs = null;
            Integer keySizeInteger = new Integer(keySize);
            Object[] consargs = new Object[]{recipientCerts, ci, encryptionAlgorithm, keySizeInteger, attribs};
            Object obj = constructor.newInstance(consargs);
            ContentInfo result = new ContentInfo(obj, this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "encrypt", result);
            }
            return result;
        }
        catch (ClassNotFoundException e1) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e1);
            }
            throw new PKCSException(e1, e1.toString());
        }
        catch (NoSuchMethodException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e2);
            }
            throw new PKCSException(e2, e2.toString());
        }
        catch (InstantiationException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e3);
            }
            throw new PKCSException(e3, e3.toString());
        }
        catch (IllegalAccessException e4) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e4);
            }
            throw new PKCSException(e4, e4.toString());
        }
        catch (InvocationTargetException e5) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", e5);
            }
            throw new PKCSException(e5, e5.toString());
        }
    }

    public ContentInfo decrypt(PrivateKey recipientPrivateKey, Certificate recipientCert) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{recipientPrivateKey, recipientCert};
            debug.entry(16384L, (Object)className, "decrypt", parms);
        }
        if (!PKCS7.isEnvelopedData(this.contentType)) {
            String pszerror = "ContentType must be EnvelopedData.  ContentType has oid = " + this.contentType;
            if (debug != null) {
                debug.text(16384L, className, "decrypt", pszerror);
            }
            throw new IllegalArgumentException(pszerror);
        }
        try {
            String edstr = "com.ibm.security.pkcs7.EnvelopedData";
            Class<?> edclass = Class.forName(edstr);
            if (edclass == null) {
                if (debug != null) {
                    debug.text(16384L, className, "decrypt", "Could not find class " + edstr);
                }
                throw new PKCSException("Could not find class " + edstr);
            }
            Class[] params = new Class[]{Class.forName("java.security.PrivateKey"), Class.forName("java.security.cert.Certificate")};
            Method method = edclass.getMethod("decrypt", params);
            Object[] methodargs = new Object[]{recipientPrivateKey, recipientCert};
            ContentInfo result = (ContentInfo)method.invoke((Object)this.content, methodargs);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decrypt", result);
            }
            return result;
        }
        catch (ClassNotFoundException e1) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e1);
            }
            throw new PKCSException(e1, e1.toString());
        }
        catch (NoSuchMethodException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e2);
            }
            throw new PKCSException(e2, e2.toString());
        }
        catch (IllegalAccessException e4) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e4);
            }
            throw new PKCSException(e4, e4.toString());
        }
        catch (InvocationTargetException e5) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e5);
            }
            throw new PKCSException(e5, e5.toString());
        }
    }

    public ContentInfo sign(Certificate signerCert, String digestSignatureAlgorithm, PrivateKey privateKey, boolean signatureOnly) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{signerCert, digestSignatureAlgorithm, privateKey, new Boolean(signatureOnly)};
            debug.entry(16384L, (Object)className, "sign", parms);
        }
        ContentInfo ci = (ContentInfo)this.clone();
        SignedData sd = new SignedData(signerCert, ci, digestSignatureAlgorithm, privateKey, signatureOnly, this.provider);
        ContentInfo result = new ContentInfo(sd, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", result);
        }
        return result;
    }

    public boolean verify(Certificate signerCert) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", signerCert);
        }
        if (!PKCS7.isSignedData(this.contentType)) {
            String pszerror = "ContentType must be SignedData.  ContentType has oid = " + this.contentType;
            if (debug != null) {
                debug.text(16384L, className, "verify", pszerror);
            }
            throw new IllegalArgumentException(pszerror);
        }
        boolean result = ((SignedData)this.content).verify(signerCert);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(result));
        }
        return result;
    }

    public ContentInfo seal(Certificate[] recipientCerts, String encryptionAlgorithm, int keySize, Certificate signerCert, String digestSignatureAlgorithm, PrivateKey privateKey, boolean signatureOnly) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{recipientCerts, encryptionAlgorithm, new Integer(keySize), signerCert, digestSignatureAlgorithm, privateKey, new Boolean(signatureOnly)};
            debug.entry(16384L, (Object)className, "seal", parms);
        }
        ContentInfo oldci = (ContentInfo)this.clone();
        SignedData signedData = new SignedData(signerCert, oldci, digestSignatureAlgorithm, privateKey, signatureOnly, this.provider);
        ContentInfo ci = new ContentInfo(signedData, this.provider);
        ContentInfo result = ci.encrypt(recipientCerts, encryptionAlgorithm, keySize);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "seal", result);
        }
        return result;
    }

    public ContentInfo unseal(Certificate recipientCert, Certificate signerCert, PrivateKey recipientPrivateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{recipientCert, signerCert, recipientPrivateKey};
            debug.entry(16384L, (Object)className, "unseal", parms);
        }
        if (!PKCS7.isSignedData(this.contentType) && !PKCS7.isEnvelopedData(this.contentType)) {
            String pszerror = "ContentType must be SignedData or EnvelopedData.  ContentType has oid = " + this.contentType;
            if (debug != null) {
                debug.text(16384L, className, "unseal", pszerror);
            }
            throw new IllegalArgumentException(pszerror);
        }
        ContentInfo contentInfo = this;
        if (PKCS7.isEnvelopedData(this.contentType)) {
            contentInfo = this.decrypt(recipientPrivateKey, recipientCert);
        }
        if (contentInfo.verify(signerCert)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "unseal", contentInfo);
            }
            return contentInfo;
        }
        if (debug != null) {
            debug.text(16384L, className, "unseal", "ContentInfo verify failed.");
        }
        throw new PKCSException("ContentInfo verify failed.");
    }

    protected void readBASE64(String filename) throws IOException {
        FileInputStream fis;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", filename);
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", e);
                debug.text(16384L, className, "readBASE64", "File " + filename + " not found.");
            }
            throw new IOException("File " + filename + " not found.");
        }
        int numBytes = fis.available();
        byte[] contents = new byte[numBytes];
        fis.read(contents);
        fis.close();
        String crlf = "\r\n";
        byte[] crlfbytes = null;
        String pszcontents = null;
        try {
            crlfbytes = crlf.getBytes("8859_1");
            pszcontents = new String(contents, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", e);
            }
            crlfbytes = crlf.getBytes();
            pszcontents = new String(contents);
        }
        StringReader sreader = new StringReader(pszcontents);
        BufferedReader breader = new BufferedReader(sreader);
        String inline = null;
        boolean bbody = false;
        boolean bfooter = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        while ((inline = breader.readLine()) != null) {
            try {
                bos2.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "readBASE64", e);
                }
                bos2.write(inline.getBytes());
            }
            if (inline.equals("-----BEGIN CERTIFICATE-----")) {
                bbody = true;
                continue;
            }
            if (inline.equals("-----END CERTIFICATE-----")) {
                bfooter = true;
                break;
            }
            if (!bbody) continue;
            try {
                bos.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                bos.write(inline.getBytes());
            }
            bos.write(crlfbytes);
        }
        ByteArrayInputStream bais = null;
        if (!bbody && !bfooter) {
            bais = new ByteArrayInputStream(bos2.toByteArray());
        } else {
            if (!bbody) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File found the following header, but did not find the footer: -----BEGIN CERTIFICATE-----");
                }
                throw new IOException("File found the following header, but did not find the footer: -----BEGIN CERTIFICATE-----");
            }
            if (!bfooter) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File found the following footer, but did not find the header: -----END CERTIFICATE-----");
                }
                throw new IOException("File found the following footer, but did not find the header: -----END CERTIFICATE-----");
            }
            bais = new ByteArrayInputStream(bos.toByteArray());
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] encoding = decoder.decodeBuffer(bais);
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
        this.decode(encoding);
    }
}

