/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public final class DigestedData
extends Content
implements Cloneable {
    private BigInteger version;
    private AlgorithmId digestAlgorithm;
    private EncapsulatedContentInfo encapsulatedContent;
    private byte[] digest;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.DigestedData";
    private volatile int cachedHashVal = 0;

    public DigestedData(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DigestedData", (Object)der);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "DigestedData", der, provider);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String digestAlgorithm, EncapsulatedContentInfo eci) throws IOException, NoSuchAlgorithmException {
        this(digestAlgorithm, eci, null);
        if (debug != null) {
            debug.entry(16384L, className, "DigestedData", digestAlgorithm, eci);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String digestAlgorithm, EncapsulatedContentInfo eci, String provider) throws IOException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{digestAlgorithm, eci, provider};
            debug.entry(16384L, (Object)className, "DigestedData", parms);
        }
        if (digestAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "DigestedData", "Digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Digest algorithm was not specified.");
        }
        if (eci == null) {
            if (debug != null) {
                debug.text(16384L, className, "DigestedData", "EncapsulatedContentInfo was not specified.");
            }
            throw new IllegalArgumentException("EncapsulatedContentInfo was not specified.");
        }
        this.setEncapsulatedContentInfo(eci);
        this.setDigestAlgorithm(digestAlgorithm);
        this.calculateMessageDigest(digestAlgorithm, eci);
        if (debug != null) {
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "DigestedData", filename, new Boolean(base64));
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "DigestedData", parms);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            DigestedData result = new DigestedData(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.DIGESTED_DATA_OID);
        }
        return PKCSOID.DIGESTED_DATA_OID;
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        bytes.putInteger(this.version);
        this.digestAlgorithm.encode(bytes);
        this.encapsulatedContent.encode(bytes);
        bytes.putOctetString(this.digest);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            debug.text(16384L, className, "decode", "DigestedData parsing error");
            throw new IOException("DigestedData parsing error");
        }
        this.version = encoding.getData().getInteger();
        DerValue der = encoding.getData().getDerValue();
        this.digestAlgorithm = AlgorithmId.parse(encoding.getData().getDerValue());
        der = encoding.getData().getDerValue();
        this.encapsulatedContent = new EncapsulatedContentInfo(der.toByteArray(), this.provider);
        this.digest = encoding.getData().getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof DigestedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((DigestedData)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.digestAlgorithm.getOID(), this.digestAlgorithm.getParameters(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVersion", result);
        }
        return result;
    }

    public EncapsulatedContentInfo getEncapsulatedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncapsulatedContentInfo");
            debug.exit(16384L, (Object)className, "getEncapsulatedContentInfo", this.encapsulatedContent.clone());
        }
        return (EncapsulatedContentInfo)this.encapsulatedContent.clone();
    }

    private void setEncapsulatedContentInfo(EncapsulatedContentInfo eci) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncapsulatedContentInfo", eci);
        }
        this.encapsulatedContent = eci;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(8192L, className, "setEncapsulatedContentInfo");
        }
    }

    public byte[] getDigest() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigest");
        }
        if (this.digest == null || this.digest.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigest", null);
            }
            return null;
        }
        byte[] digest2 = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, digest2, 0, this.digest.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigest", digest2);
        }
        return digest2;
    }

    private void setDigestAlgorithm(String digestAlgorithm) throws IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", digestAlgorithm);
        }
        if (digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "setDigestAlgorithm", "Digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Digest algorithm was not specified.");
        }
        String digestAlg = PKCS7.getDigestAlgorithm(digestAlgorithm);
        this.digestAlgorithm = AlgorithmId.get(digestAlgorithm);
        this.digest = null;
        this.calculateMessageDigest(digestAlg, this.encapsulatedContent);
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    private void calculateMessageDigest(AlgorithmId digestAlgorithm, EncapsulatedContentInfo eci) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculateMessageDigest", digestAlgorithm, eci);
        }
        this.calculateMessageDigest(digestAlgorithm.getName(), eci);
        if (debug != null) {
            debug.exit(8192L, className, "calculateMessageDigest");
        }
    }

    private void calculateMessageDigest(String digestAlgorithm, EncapsulatedContentInfo eci) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculateMessageDigest", digestAlgorithm, eci);
        }
        if (digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Digest algorithm was not specified.");
        }
        if (eci == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "EncapsulatedContentInfo was not specified.");
            }
            throw new IllegalArgumentException("EncapsulatedContentInfo was not specified.");
        }
        this.digest = null;
        byte[] bytesToBeDigested = eci.getContent();
        MessageDigest md = null;
        try {
            md = this.provider != null ? MessageDigest.getInstance(digestAlgorithm, this.provider) : MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", e);
            }
            throw new IOException(e.toString());
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", nspe);
            }
            throw new IOException("provider" + this.provider + " not found:" + nspe.toString());
        }
        this.digest = md.digest(bytesToBeDigested);
        if (debug != null) {
            debug.exit(8192L, className, "calculateMessageDigest");
        }
    }

    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 DigestedData:\r\n";
        out = out + "\tversion: " + this.version.intValue();
        out = out + "\r\n\tdigestAlgorithm: " + this.digestAlgorithm;
        out = out + "\r\n\tencapsulatedContent:\r\n" + this.encapsulatedContent;
        out = this.digest != null ? out + "\r\n\tdigest: \r\n" + hexDump.encodeBuffer(this.digest) : out + "\r\n\tdigest: not calculated";
        out = out + "\r\n";
        return out;
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ZERO;
        if (!this.encapsulatedContent.getContentType().equals(PKCSOID.DATA_OID)) {
            this.version = BigInteger.valueOf(2L);
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }
}

