/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class EncapsulatedContentInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_ECONTENT = 0;
    private ObjectIdentifier contentType;
    private byte[] content;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EncapsulatedContentInfo";
    private volatile int cachedHashVal = 0;

    public EncapsulatedContentInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncapsulatedContentInfo", (Object)der);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "EncapsulatedContentInfo", der, provider);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(ContentInfo contentInfo) throws IOException {
        this(contentInfo, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncapsulatedContentInfo", contentInfo);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(ContentInfo contentInfo, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "EncapsulatedContentInfo", contentInfo, provider);
        }
        this.contentType = contentInfo.getContentType();
        if (contentInfo.getContent() != null) {
            DerOutputStream derout = new DerOutputStream();
            contentInfo.getContent().encode(derout);
            DerValue der = new DerValue(derout.toByteArray());
            this.content = der.getData().toByteArray();
            DerOutputStream dos = new DerOutputStream();
            if (PKCS7.isData(this.contentType)) {
                dos.putOctetString(this.content);
            } else {
                dos.write((byte)48, this.content);
            }
        } else {
            this.content = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "EncapsulatedContentInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "EncapsulatedContentInfo", parms);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            EncapsulatedContentInfo result = new EncapsulatedContentInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOID(this.contentType);
        if (this.content != null) {
            DerOutputStream tmpout = new DerOutputStream();
            tmpout.putOctetString(this.content);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncapsulatedData parsing error tag " + encoding.getTag() + " is not a sequence.");
            }
            throw new IOException("EncapsulatedData parsing error tag " + encoding.getTag() + " is not a sequence.");
        }
        this.contentType = encoding.getData().getOID();
        if (encoding.getData().available() != 0) {
            DerValue opt = encoding.getData().getDerValue();
            if (opt.isContextSpecific((byte)0)) {
                if (opt.isConstructed()) {
                    byte[] content = opt.getData().toByteArray();
                    DerValue opt2 = new DerValue(content);
                    opt2.resetTag((byte)4);
                    DerInputStream temp = opt2.getData();
                    content = temp != null ? temp.toByteArray() : new byte[]{};
                    this.content = PKCS7.stripOctetTags(content);
                } else {
                    opt.resetTag((byte)4);
                    this.content = opt.getOctetString();
                }
            }
        } else {
            this.content = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.exit(16384L, className, "equals");
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof EncapsulatedContentInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((EncapsulatedContentInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 EncapsulatedContentInfo:\r\n";
        out = out + "\tcontentType: " + this.contentType;
        out = this.content != null ? out + "\r\n\tcontent:\r\n" + hexDump.encodeBuffer(this.content) + "\r\n" : out + "\r\n\tcontent: null";
        return out;
    }

    public ObjectIdentifier getContentType() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
            debug.exit(16384L, (Object)className, "getContentType", this.contentType);
        }
        return this.contentType;
    }

    public ContentInfo getContentInfo() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo", null);
            }
            return null;
        }
        DerOutputStream dos = new DerOutputStream();
        ContentInfo result = null;
        if (!PKCS7.isData(this.contentType)) {
            dos.write((byte)48, this.content);
            result = new ContentInfo(this.contentType, dos.toByteArray(), this.provider);
        } else {
            result = new ContentInfo(this.contentType, this.content, this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo", result);
        }
        return result;
    }

    public byte[] getContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getContent");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", null);
            }
            return null;
        }
        byte[] content2 = new byte[this.content.length];
        System.arraycopy(this.content, 0, content2, 0, this.content.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContent", content2);
        }
        return content2;
    }
}

