/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.OriginatorInfo;
import com.ibm.security.pkcs7.RecipientInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class EnvelopedData
extends Content
implements Cloneable {
    private BigInteger version;
    private OriginatorInfo originator;
    private RecipientInfo[] recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private PKCSAttributes unprotectedAttrs;
    private ContentInfo content;
    private byte[] encryptedContent;
    private SmudgedBytes contentEncryptionKey;
    private String contentEncryptionAlgorithm;
    private AlgorithmId contentEncryptionAlgId;
    private static final byte TAG_OINFO = 0;
    private static final byte TAG_UNPROTECTED_ATTRS = 1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EnvelopedData";

    public EnvelopedData(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EnvelopedData", (Object)der);
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "EnvelopedData", der, provider);
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(OriginatorInfo originatorInfo, RecipientInfo[] recipientInfos, EncryptedContentInfo encryptedContentInfo, PKCSAttributes unprotectedAttrs) {
        if (debug != null) {
            Object[] parms = new Object[]{originatorInfo, recipientInfos, encryptedContentInfo, unprotectedAttrs};
            debug.entry(16384L, (Object)className, "EnvelopedData", parms);
        }
        this.originator = originatorInfo;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = unprotectedAttrs;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(OriginatorInfo originatorInfo, RecipientInfo[] recipientInfos, EncryptedContentInfo encryptedContentInfo, PKCSAttributes unprotectedAttrs, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{originatorInfo, recipientInfos, encryptedContentInfo, unprotectedAttrs, provider};
            debug.entry(16384L, (Object)className, "EnvelopedData", parms);
        }
        this.originator = originatorInfo;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = unprotectedAttrs;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(Certificate[] certs, ContentInfo contentInfo, String encryptionAlgorithm, int keySize, PKCSAttributes unprotectedAttrs) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{certs, contentInfo, encryptionAlgorithm, unprotectedAttrs};
            debug.entry(16384L, (Object)className, "EnvelopedData", parms);
        }
        this.encryptContent(contentInfo, encryptionAlgorithm, keySize);
        this.addRecipient(certs);
        this.addUnprotectedAttribute(unprotectedAttrs);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(Certificate[] certs, ContentInfo contentInfo, String encryptionAlgorithm, int keySize, PKCSAttributes unprotectedAttrs, String provider) throws PKCSException, IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{certs, contentInfo, encryptionAlgorithm, new Integer(keySize), unprotectedAttrs, provider};
            debug.entry(16384L, (Object)className, "EnvelopedData", parms);
        }
        this.encryptContent(contentInfo, encryptionAlgorithm, keySize);
        this.addRecipient(certs);
        this.addUnprotectedAttribute(unprotectedAttrs);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "EnvelopedData", filename, new Boolean(base64));
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "EnvelopedData", parms);
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            EnvelopedData result = new EnvelopedData(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
            }
            return null;
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        if (this.originator != null) {
            DerOutputStream tmpout = new DerOutputStream();
            this.originator.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        DerValue[] ders = this.recipientInfos != null ? new DerValue[this.recipientInfos.length] : new DerValue[]{};
        for (int i = 0; i < ders.length; ++i) {
            DerOutputStream out = new DerOutputStream();
            this.recipientInfos[i].encode(out);
            ders[i] = new DerValue(out.toByteArray());
        }
        bytes.putOrderedSetOf((byte)49, ders);
        DerOutputStream out = new DerOutputStream();
        this.encryptedContentInfo.encode(out);
        bytes.putDerValue(new DerValue(out.toByteArray()));
        if (this.unprotectedAttrs != null && this.unprotectedAttrs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            this.unprotectedAttrs.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        DerValue der;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EnvelopedData parsing error.");
            }
            throw new IOException("EnvelopedData parsing error.");
        }
        this.version = encoding.getData().getInteger();
        if (this.version.intValue() != 0 && this.version.intValue() != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid EnvelopedData version (must be 0 or 2).");
            }
            throw new IOException("Invalid EnvelopedData version (must be 0 or 2).");
        }
        if ((byte)encoding.getData().peekByte() == -96) {
            der = encoding.getData().getDerValue();
            der.resetTag((byte)48);
            this.originator = new OriginatorInfo(der.toByteArray(), this.provider);
        } else {
            this.originator = null;
        }
        DerValue[] rInfos = encoding.getData().getSet(1);
        int len = rInfos.length;
        this.recipientInfos = new RecipientInfo[len];
        for (int i = 0; i < len; ++i) {
            this.recipientInfos[i] = new RecipientInfo(rInfos[i].toByteArray(), this.provider);
        }
        der = encoding.getData().getDerValue();
        this.encryptedContentInfo = new EncryptedContentInfo(der.toByteArray(), this.provider);
        if (encoding.getData().available() != 0) {
            der = encoding.getData().getDerValue();
            if (der.isContextSpecific((byte)1) && der.isConstructed()) {
                DerInputStream derin = new DerInputStream(der.toByteArray());
                this.unprotectedAttrs = new PKCSAttributes(derin, this.provider);
            } else {
                this.unprotectedAttrs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof EnvelopedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((EnvelopedData)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        try {
            DerOutputStream thisOut = new DerOutputStream();
            this.encode(thisOut);
            int HashVal = Arrays.hashCode(thisOut.toByteArray());
            return HashVal;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void addRecipient(Certificate cert) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipient_1");
            }
            return;
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Certificate must be of type X509Certificate.  Instead it is of type " + cert.getClass().getName() + ".");
            }
            throw new IllegalArgumentException("Certificate must be of type X509Certificate.  Instead it is of type " + cert.getClass().getName() + ".");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Content encryption key is null.");
            }
            throw new PKCSException("Content encryption key is null.");
        }
        RecipientInfo ri = new RecipientInfo(this.getContentEncryptionKey(), cert, this.provider);
        if (this.recipientInfos == null || this.recipientInfos.length == 0) {
            this.recipientInfos = new RecipientInfo[1];
            this.recipientInfos[0] = ri;
        } else {
            RecipientInfo[] tmpRecipients = new RecipientInfo[this.recipientInfos.length + 1];
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                tmpRecipients[i] = this.recipientInfos[i];
            }
            tmpRecipients[i] = ri;
            this.recipientInfos = tmpRecipients;
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public void addRecipient(Certificate[] certs) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", certs);
        }
        if (certs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipient_1");
            }
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            this.addRecipient(certs[i]);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public OriginatorInfo getOriginator() {
        if (debug != null) {
            debug.entry(16384L, className, "getOriginator");
        }
        if (this.originator == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getOriginator", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOriginator", this.originator.clone());
        }
        return (OriginatorInfo)this.originator.clone();
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public RecipientInfo[] getRecipientInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfos");
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfos", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfos", this.recipientInfos.clone());
        }
        return (RecipientInfo[])this.recipientInfos.clone();
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContentInfo");
        }
        if (this.encryptedContentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptedContentInfo", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedContentInfo", this.encryptedContentInfo.clone());
        }
        return (EncryptedContentInfo)this.encryptedContentInfo.clone();
    }

    public RecipientInfo getRecipientInfo(Certificate cert) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfo");
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfo_1", null);
            }
            return null;
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfo_2", null);
            }
            return null;
        }
        for (int i = 0; i < this.recipientInfos.length; ++i) {
            if (!this.recipientInfos[i].identifies(cert)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfo", this.recipientInfos[i].clone());
            }
            return (RecipientInfo)this.recipientInfos[i].clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfo_3", null);
        }
        return null;
    }

    public boolean hasRecipientInfo(Certificate cert) {
        RecipientInfo rinfo;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasRecipientInfo", cert);
        }
        try {
            rinfo = this.getRecipientInfo(cert);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "hasRecipientInfo", e);
                debug.exit(16384L, (Object)className, "hasRecipientInfo_1", new Boolean(false));
            }
            return false;
        }
        if (rinfo != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasRecipientInfo_2", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasRecipientInfo_3", new Boolean(false));
        }
        return false;
    }

    private void addUnprotectedAttribute(PKCSAttributes unprotectedAttrs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addUnprotectedAttribute", unprotectedAttrs);
        }
        if (unprotectedAttrs == null || unprotectedAttrs.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addUnprotectedAttribute_1");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs == null ? (PKCSAttributes)unprotectedAttrs.clone() : this.unprotectedAttrs.addAttributes(unprotectedAttrs);
        if (debug != null) {
            debug.exit(16384L, className, "addUnprotectedAttribute");
        }
    }

    private void addUnprotectedAttribute(PKCSAttribute unprotectedAttr) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addUnprotectedAttribute", unprotectedAttr);
        }
        if (unprotectedAttr == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addUnprotectedAttribute_1");
            }
            return;
        }
        if (this.unprotectedAttrs == null) {
            PKCSAttribute[] attribs = new PKCSAttribute[]{unprotectedAttr};
            this.unprotectedAttrs = new PKCSAttributes(attribs, this.provider);
        } else {
            this.unprotectedAttrs = this.unprotectedAttrs.addAttribute(unprotectedAttr);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addUnprotectedAttribute");
        }
    }

    private void removeUnprotectedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeUnprotectedAttribute", oid);
        }
        if (oid == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "removeUnprotectedAttribute_1");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs.deleteAttribute(oid);
        if (debug != null) {
            debug.exit(16384L, className, "removeUnprotectedAttribute");
        }
    }

    public PKCSAttribute getUnprotectedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnprotectedAttribute", oid);
        }
        if (oid == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attr = (PKCSAttribute)this.unprotectedAttrs.getAttribute(oid);
        if (attr == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttribute", attr);
        }
        return attr;
    }

    public PKCSAttributes getUnprotectedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnprotectedAttributes");
        }
        if (this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttributes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttributes", this.unprotectedAttrs);
        }
        return this.unprotectedAttrs;
    }

    private void encryptContent(ContentInfo cinfo, String contentEncryptionAlg, int keySize) throws PKCSException, IOException {
        AlgorithmId algId;
        String alg;
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, contentEncryptionAlg, new Integer(keySize)};
            debug.entry(8192L, (Object)className, "encryptContent", parms);
        }
        String algIdName = alg = EncryptedContentInfo.getAlgorithm(contentEncryptionAlg);
        if (alg.equalsIgnoreCase("AES")) {
            if (keySize != 128 && keySize != 192 && keySize != 256) {
                throw new IllegalArgumentException("Invalid key size " + keySize + ". Must be 128, " + "192 or 256 for AES key");
            }
            switch (keySize) {
                case 128: {
                    algIdName = "AES128";
                    break;
                }
                case 192: {
                    algIdName = "AES192";
                    break;
                }
                case 256: {
                    algIdName = "AES256";
                    break;
                }
            }
        }
        try {
            algId = AlgorithmId.get(algIdName);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encryptContent", e);
                debug.text(8192L, className, "encryptContent", "Unsupported algorithm " + alg + ".  Must be one of AES, DES, DESede, or RC2.");
            }
            throw new IllegalArgumentException("Unsupported algorithm " + alg + ".  Must be one of AES, DES, DESede, or RC2.");
        }
        if (this.contentEncryptionAlgId != null && !this.contentEncryptionAlgId.equals(algId)) {
            if (debug != null) {
                debug.text(8192L, className, "encryptContent", "Input content encryption algorithm differs from existing algorithm");
            }
            throw new IllegalArgumentException("Input content encryption algorithm differs from existing algorithm");
        }
        this.content = cinfo;
        this.contentEncryptionAlgorithm = alg;
        this.contentEncryptionAlgId = algId;
        this.encryptedContentInfo = new EncryptedContentInfo(cinfo, alg, keySize, this.provider);
        this.setContentEncryptionKey(this.encryptedContentInfo.getEncryptionKey());
        if (debug != null) {
            debug.exit(8192L, className, "encryptContent");
        }
    }

    public ContentInfo decrypt(PrivateKey key, Certificate cert) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", cert);
        }
        if (key == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "key not specified.");
            }
            throw new IllegalArgumentException("key not specified.");
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "cert not specified.");
            }
            throw new IllegalArgumentException("cert not specified.");
        }
        int i = 0;
        boolean found = false;
        for (i = 0; i < this.recipientInfos.length; ++i) {
            if (!this.recipientInfos[i].identifies(cert)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "No RecipientInfo matches certificate.");
            }
            throw new IllegalArgumentException("No RecipientInfo matches certificate.");
        }
        byte[] contentEncryptionKeyData = this.recipientInfos[i].decryptKey(key);
        String contentEncryptionAlg = this.encryptedContentInfo.getContentEncryptionAlgorithm().getName();
        ObjectIdentifier algOID = this.encryptedContentInfo.getContentEncryptionAlgorithm().getOID();
        if (!(algOID.equals(AlgorithmId.DESCBC_oid) || algOID.equals(AlgorithmId.tripleDESCBC_oid) || algOID.equals(AlgorithmId.RC2CBC_oid) || algOID.equals(AlgorithmId.AES128CBC_oid) || algOID.equals(AlgorithmId.AES192CBC_oid) || algOID.equals(AlgorithmId.AES256CBC_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Unsupported decryption algorithm: " + contentEncryptionAlg);
            }
            throw new IllegalArgumentException("Unsupported decryption algorithm: " + contentEncryptionAlg);
        }
        ContentInfo decryptedContent = this.encryptedContentInfo.decrypt(contentEncryptionKeyData);
        Arrays.fill(contentEncryptionKeyData, (byte)0);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", decryptedContent);
        }
        return decryptedContent;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.ENVELOPED_DATA_OID);
        }
        return PKCSOID.ENVELOPED_DATA_OID;
    }

    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 EnvelopedData:\r\n";
        out = out + "\tversion: " + this.version.intValue();
        out = out + "\r\n\toriginator: " + this.originator;
        int ccount = 0;
        if (this.recipientInfos != null) {
            ccount = this.recipientInfos.length;
        }
        out = out + "\r\n\trecipientInfos (" + ccount + "):";
        if (this.recipientInfos == null) {
            out = out + "\r\n\tnull";
        } else {
            out = out + "\r\n";
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                out = out + "\trecipientInfos[" + i + "]:\r\n" + this.recipientInfos[i];
            }
        }
        out = out + "\r\n\tencryptedContent:\r\n" + this.encryptedContentInfo;
        if (this.unprotectedAttrs != null) {
            out = out + "\r\n\tunprotectedAttrs (" + this.unprotectedAttrs.size() + "):\r\n";
            out = out + this.unprotectedAttrs + "\r\n";
        } else {
            out = out + "\r\n\tunprotectedAttrs: null\r\n";
        }
        return out;
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.encryptedContentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "EnvelopedData missing encryptedContentInfo value.");
            }
            throw new IOException("EnvelopedData missing encryptedContentInfo value.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ZERO;
        if (this.originator != null) {
            this.version = BigInteger.valueOf(2L);
        } else if (this.recipientInfos != null) {
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                if (this.recipientInfos[i].getVersion().intValue() == 0) continue;
                this.version = BigInteger.valueOf(2L);
                break;
            }
        }
        if (this.unprotectedAttrs != null) {
            this.version = BigInteger.valueOf(2L);
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }

    private void setContentEncryptionKey(byte[] bytes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentEncryptionKey", (Object)bytes);
            debug.exit(8192L, className, "setContentEncryptionKey");
        }
        this.contentEncryptionKey = new SmudgedBytes(bytes);
    }

    private byte[] getContentEncryptionKey() {
        if (debug != null) {
            debug.entry(8192L, className, "getContentEncryptionKey");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "setContentEncryptionKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "setContentEncryptionKey", this.contentEncryptionKey.getClearText());
        }
        return this.contentEncryptionKey.getClearText();
    }

    protected void finalize() {
        this.contentEncryptionKey = null;
    }
}

