/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.SubjectKeyIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class SignerIdentifier
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_KEYID = 0;
    private IssuerAndSerialNumber issuer;
    private byte[] keyid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignerIdentifier";
    private volatile int cachedHashVal = 0;

    public SignerIdentifier(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", (Object)der);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", der, provider);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(IssuerAndSerialNumber issuer) {
        this(issuer, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", issuer);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(IssuerAndSerialNumber issuer, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", issuer, provider);
        }
        if (issuer == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "IssuerAndSerialNumber not specified.");
            }
            throw new IllegalArgumentException("IssuerAndSerialNumber not specified.");
        }
        this.issuer = issuer;
        this.keyid = null;
        if (debug != null) {
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(SubjectKeyIdentifier ski) {
        this(ski, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", ski);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(SubjectKeyIdentifier ski, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", ski, provider);
        }
        if (ski == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "SubjectKeyIdentifier not specified.");
            }
            throw new IllegalArgumentException("SubjectKeyIdentifier not specified.");
        }
        this.issuer = null;
        this.keyid = ski.getIdentifier();
        if (debug != null) {
            debug.exit(16384L, className, "SignerIdentifier");
        }
    }

    public SignerIdentifier(Certificate cert) throws IOException {
        this(cert, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", cert);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(Certificate cert, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", cert, provider);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "Certificate type " + cert.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
            }
            throw new IllegalArgumentException("Certificate type " + cert.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
        }
        this.issuer = new IssuerAndSerialNumber((X509Certificate)cert, provider);
        this.keyid = null;
        if (debug != null) {
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", filename, new Boolean(base64));
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SignerIdentifier", parms);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SignerIdentifier result = new SignerIdentifier(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof SignerIdentifier)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((SignerIdentifier)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.issuer == null && this.keyid == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "IssuerAndSerialNumber or SubjectKeyIdentifier not specified.");
            }
            throw new IOException("IssuerAndSerialNumber or SubjectKeyIdentifier not specified.");
        }
        if (this.keyid != null) {
            DerOutputStream tmpout = new DerOutputStream();
            tmpout.putOctetString(this.keyid);
            os.write(tmpout.toByteArray());
        } else {
            this.issuer.encode(os);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if ((byte)encoding.getData().peekByte() == 48) {
            this.issuer = new IssuerAndSerialNumber(encoding.toByteArray(), this.provider);
            this.keyid = null;
        } else {
            this.keyid = encoding.getOctetString();
            this.issuer = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public IssuerAndSerialNumber getIssuer() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuer");
        }
        IssuerAndSerialNumber result = null;
        if (this.issuer != null) {
            result = (IssuerAndSerialNumber)this.issuer.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIssuer", result);
        }
        return result;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectKeyIdentifier");
        }
        if (this.keyid == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectKeyIdentifier_1", null);
            }
            return null;
        }
        SubjectKeyIdentifier ski = null;
        try {
            ski = new SubjectKeyIdentifier(this.provider);
            ski.setIdentifier(this.keyid);
        }
        catch (PKCSException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSubjectKeyIdentifier", e);
            }
            ski = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubjectKeyIdentifier", ski);
        }
        return ski;
    }

    public boolean isIssuer() {
        if (debug != null) {
            debug.entry(16384L, className, "isIssuer");
        }
        boolean result = false;
        if (this.issuer != null) {
            result = true;
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isIssuer", new Boolean(result));
        }
        return result;
    }

    public String toString() {
        String out = "PKCS7 SignerIdentifier:\r\n";
        if (this.issuer != null) {
            out = out + this.issuer.toString();
        } else {
            HexDumpEncoder hexDump = new HexDumpEncoder();
            out = this.keyid != null ? out + "\r\n\tSubjectKeyIdentifier: \r\n" + hexDump.encodeBuffer(this.keyid) : out + "\r\n\tSubjectKeyIdentifier: null\r\n";
        }
        return out;
    }
}

