/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class ContentType
extends PKCS9DerObject
implements Cloneable {
    private ObjectIdentifier oid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ContentType";
    private volatile int cachedHashVal = 0;

    public ContentType(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentType", (Object)der);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", der, provider);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String oid) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentType", oid);
        }
        this.oid = new ObjectIdentifier(oid);
        if (debug != null) {
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String oid, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", oid, provider);
        }
        this.oid = new ObjectIdentifier(oid);
        if (debug != null) {
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(ObjectIdentifier oid) {
        this.oid = oid;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentType", oid);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(ObjectIdentifier oid, String provider) {
        super(provider);
        this.oid = oid;
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", oid, provider);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", filename, new Boolean(base64));
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "ContentType", parms);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ContentType result = new ContentType(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
            }
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof ContentType) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((ContentType)obj)));
            }
            return this.equals((ContentType)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.CONTENT_TYPE_OID);
        }
        return PKCSOID.CONTENT_TYPE_OID;
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.oid == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "ObjectIdentifier not specified.");
            }
            throw new IOException("ObjectIdentifier not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        tmpout2.putOID(this.oid);
        tmpout.write((byte)49, tmpout2.toByteArray());
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
        }
        ObjectIdentifier oid = null;
        try {
            oid = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception e) {
            oid = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOID", oid);
        }
        return oid;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getOID());
        }
        return this.getOID();
    }

    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 6) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "ContentType");
        }
        return "ContentType";
    }

    public String toString() {
        String out = "PKCS9 ContentType: " + this.oid + "\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.oid = new DerInputStream(elems[0].toByteArray()).getOID();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(ContentType other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

