/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;

public abstract class PKCS9DerObject
extends PKCSDerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.PKCS9DerObject";

    protected PKCS9DerObject() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS9DerObject");
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    protected PKCS9DerObject(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS9DerObject", provider);
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(byte[] der) throws IOException {
        this();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS9DerObject", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(byte[] der, String provider) throws IOException {
        this(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCS9DerObject", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "PKCS9DerObject", filename, new Boolean(base64));
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCS9DerObject", parms);
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.getObjectIdentifier());
        }
        return this.getObjectIdentifier();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", this.getAttributeName());
        }
        return this.getAttributeName();
    }

    public PKCSAttribute getPKCSAttribute() throws IOException {
        PKCSAttribute result = new PKCSAttribute(this.getObjectIdentifier(), this.getValue(), this.provider);
        if (debug != null) {
            debug.entry(16384L, className, "getPKCSAttribute");
            debug.exit(16384L, (Object)className, "getPKCSAttribute", result);
        }
        return result;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        String pszattr = this.getAttributeName();
        if (encoding.getTag() != 48 && encoding.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Unknown tag " + encoding.getTag() + " for decode.");
            }
            throw new IOException("Unknown tag " + encoding.getTag() + " for decode.");
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            if (derIn.available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "Excess data parsing " + pszattr + ".");
                }
                throw new IOException("Excess data parsing " + pszattr + ".");
            }
            if (val.length != 2) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", pszattr + " does not have two components.");
                }
                throw new IOException(pszattr + " does not have two components.");
            }
            ObjectIdentifier oid = val[0].getOID();
            if (!oid.equals(this.getObjectIdentifier())) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "Invalid OID for " + pszattr + ": " + oid);
                }
                throw new IOException("Invalid OID for " + pszattr + ": " + oid);
            }
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        if (this.isSingleValued() && elems.length > 1) {
            if (debug != null) {
                debug.text(16384L, className, "decode", pszattr + " must have a single value.  Instead it has " + elems.length + ".");
            }
            throw new IOException(pszattr + " must have a single value.  Instead it has " + elems.length + ".");
        }
        for (int i = 0; i < elems.length; ++i) {
            byte tag = elems[i].getTag();
            if (this.isTagValid(tag)) continue;
            if (debug != null) {
                debug.text(16384L, className, "decode", pszattr + " has an invalid tag " + tag + " at element " + i + ".");
            }
            throw new IOException(pszattr + " has an invalid tag " + tag + " at element " + i + ".");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public abstract boolean isTagValid(byte var1);

    public abstract boolean isSingleValued();

    public abstract String getAttributeName();

    public abstract Object getValue();
}

