/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PublicKeyAndChallenge;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;

public final class SignedPublicKeyAndChallenge
extends PKCSDerObject {
    private PublicKeyAndChallenge pkac;
    private AlgorithmId signatureAlgorithm;
    private byte[] signature;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.SignedPublicKeyAndChallenge";
    private volatile int cachedHashVal = 0;

    public SignedPublicKeyAndChallenge(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignedPublicKeyAndChallenge", (Object)der);
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    public SignedPublicKeyAndChallenge(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignedPublicKeyAndChallenge", der, provider);
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    public SignedPublicKeyAndChallenge(PublicKeyAndChallenge publicKeyAndChallenge, String signatureAlgorithm, PrivateKey privateKey) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{publicKeyAndChallenge, signatureAlgorithm, privateKey};
            debug.entry(16384L, (Object)className, "SignedPublicKeyAndChallenge", parms);
        }
        if (signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "signatureAlgorithm not specified.");
            }
            throw new IllegalArgumentException("signatureAlgorithm not specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "privateKey not specified.");
            }
            throw new IllegalArgumentException("privateKey not specified.");
        }
        this.pkac = publicKeyAndChallenge;
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.sign(privateKey);
        if (debug != null) {
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    public SignedPublicKeyAndChallenge(PublicKeyAndChallenge publicKeyAndChallenge, String signatureAlgorithm, PrivateKey privateKey, String provider) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{publicKeyAndChallenge, signatureAlgorithm, privateKey, provider};
            debug.entry(16384L, (Object)className, "SignedPublicKeyAndChallenge", parms);
        }
        if (signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "signatureAlgorithm not specified.");
            }
            throw new IllegalArgumentException("signatureAlgorithm not specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "privateKey not specified.");
            }
            throw new IllegalArgumentException("privateKey not specified.");
        }
        this.pkac = publicKeyAndChallenge;
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.sign(privateKey);
        if (debug != null) {
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    private void setSignatureAlgorithm(String signatureAlgorithm) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureAlgorithm", signatureAlgorithm);
        }
        this.signatureAlgorithm = AlgorithmId.get(signatureAlgorithm);
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureAlgorithm");
        }
    }

    public AlgorithmId getSignatureAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithm");
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignatureAlgorithm_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm_2", new AlgorithmId(this.signatureAlgorithm.getOID(), this.signatureAlgorithm.getParameters(), this.provider));
        }
        return new AlgorithmId(this.signatureAlgorithm.getOID(), this.signatureAlgorithm.getParameters(), this.provider);
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature_2", (byte[])this.signature.clone());
        }
        return (byte[])this.signature.clone();
    }

    public PublicKeyAndChallenge getPublicKeyAndChallenge() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKeyAndChallenge");
            debug.exit(16384L, (Object)className, "getPublicKeyAndChallenge", this.pkac);
        }
        return this.pkac;
    }

    private void sign(PrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "sign", key);
        }
        Signature signing = Signature.getInstance(this.signatureAlgorithm.getOID().toString());
        signing.initSign(key);
        DerOutputStream derout = new DerOutputStream();
        try {
            this.pkac.encode(derout);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(8192L, className, "sign", e);
            }
            throw new SignatureException("Could not encode the PublicKeyAndChallenge for signing.");
        }
        signing.update(derout.toByteArray());
        this.signature = signing.sign();
        if (debug != null) {
            debug.exit(8192L, className, "sign");
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "verify");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_1", false);
            }
            return false;
        }
        Signature signing = Signature.getInstance(this.signatureAlgorithm.getOID().toString());
        signing.initVerify(this.pkac.getSubjectPublicKeyInfo());
        DerOutputStream derout = new DerOutputStream();
        try {
            this.pkac.encode(derout);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e);
            }
            throw new SignatureException("Could not encode the PublicKeyAndChallenge.");
        }
        signing.update(derout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify_2", signing.verify(this.signature));
        }
        return signing.verify(this.signature);
    }

    public void encode(OutputStream os) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.pkac.encode(bytes);
        this.signatureAlgorithm.encode(bytes);
        if (this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "signature not generated");
            }
            throw new IOException("signature not generated");
        }
        bytes.putBitString(this.signature);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, not a SEQUENCE");
            }
            throw new IOException("parsing error, not a SEQUENCE");
        }
        if (encoding.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing PublicKeyAndChallenge data");
            }
            throw new IOException("parsing error, missing PublicKeyAndChallenge data");
        }
        this.pkac = new PublicKeyAndChallenge(encoding.getData().getDerValue().toByteArray(), this.provider);
        if (encoding.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "missing signature algorithm data");
            }
            throw new IOException("missing signature algorithm data");
        }
        this.signatureAlgorithm = new AlgorithmId(encoding.getData().getDerValue(), this.provider);
        if (encoding.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing signature data");
            }
            throw new IOException("parsing error, missing signature data");
        }
        this.signature = encoding.getData().getBitString();
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, data overrun");
            }
            throw new IOException("parsing error, data overrun");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        if (!(other instanceof SignedPublicKeyAndChallenge)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((SignedPublicKeyAndChallenge)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String out = "SignedPublicKeyAndChallenge:";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.pkac != null) {
            out = out + "\r\n\t" + this.pkac.toString();
        }
        if (this.signatureAlgorithm != null) {
            out = out + "\r\n\tsignatureAlgorithm: " + this.signatureAlgorithm.toString();
        }
        HexDumpEncoder encoder = new HexDumpEncoder();
        if (this.signature != null) {
            out = out + "\r\n\tsignature: " + encoder.encodeBuffer(this.signature);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public Object clone() {
        try {
            DerOutputStream derout = new DerOutputStream();
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            this.encode(derout);
            SignedPublicKeyAndChallenge retobj = new SignedPublicKeyAndChallenge(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone_2", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }
}

