/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.ByteArrayLexOrder;
import com.ibm.security.util.ByteArrayTagOrder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int size) {
        super(size);
    }

    public DerOutputStream() {
    }

    public void write(byte tag, byte[] buf) throws IOException {
        this.write(tag);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void write(byte tag, DerOutputStream out) throws IOException {
        this.write(tag);
        this.putLength(out.count);
        this.write(out.buf, 0, out.count);
    }

    public void writeImplicit(byte tag, DerOutputStream value) throws IOException {
        this.write(tag);
        this.write(value.buf, 1, value.count - 1);
    }

    public void putDerValue(DerValue val) throws IOException {
        val.encode(this);
    }

    public void putBoolean(boolean val) throws IOException {
        this.write(1);
        this.putLength(1);
        if (val) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putSignedInt(int i) throws IOException {
        int j;
        byte[] places = new byte[4];
        int count = 0;
        places[3] = (byte)(i & 0xFF);
        places[2] = (byte)((i & 0xFF00) >>> 8);
        places[1] = (byte)((i & 0xFF0000) >>> 16);
        places[0] = (byte)((i & 0xFF000000) >>> 24);
        if (places[0] != 0) {
            for (j = 0; j < 3 && places[j] == -1 && (places[j + 1] & 0xFFFFFF80) == -128; ++j) {
                ++count;
            }
        } else if (places[0] == 0) {
            for (j = 0; j < 3 && places[j] == 0 && (places[j + 1] & 0xFFFFFF80) == 0; ++j) {
                ++count;
            }
        }
        byte[] buf = new byte[4 - count];
        for (j = 0; j < 4 - count; ++j) {
            buf[j] = places[j + count];
        }
        this.write(2);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putInteger(BigInteger i) throws IOException {
        this.write(2);
        this.putBigInteger(i);
    }

    public void putEnumerated(BigInteger i) throws IOException {
        this.write(10);
        this.putBigInteger(i);
    }

    private void putBigInteger(BigInteger i) throws IOException {
        byte[] buf = i.toByteArray();
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putInteger(Integer i) throws IOException {
        this.putInteger((int)i);
    }

    public void putInteger(int i) throws IOException {
        int j;
        byte[] bytes = new byte[4];
        int start = 0;
        bytes[3] = (byte)(i & 0xFF);
        bytes[2] = (byte)((i & 0xFF00) >>> 8);
        bytes[1] = (byte)((i & 0xFF0000) >>> 16);
        bytes[0] = (byte)((i & 0xFF000000) >>> 24);
        if (bytes[0] == 255) {
            for (j = 0; j < 3 && bytes[j] == 255 && (bytes[j + 1] & 0x80) == 128; ++j) {
                ++start;
            }
        } else if (bytes[0] == 0) {
            for (j = 0; j < 3 && bytes[j] == 0 && (bytes[j + 1] & 0x80) == 0; ++j) {
                ++start;
            }
        }
        this.write(2);
        this.putLength(4 - start);
        for (int k = start; k < 4; ++k) {
            this.write(bytes[k]);
        }
    }

    public void putBitString(byte[] bits) throws IOException {
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(0);
        this.write(bits);
    }

    public void putUnalignedBitString(BitArray ba) throws IOException {
        byte[] bits = ba.toByteArray();
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(bits.length * 8 - ba.length());
        this.write(bits);
    }

    public void putOctetString(byte[] octets) throws IOException {
        this.write((byte)4, octets);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier oid) throws IOException {
        oid.encode(this);
    }

    public void putSequence(DerValue[] seq) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < seq.length; ++i) {
            seq[i].encode(bytes);
        }
        this.write((byte)48, bytes);
    }

    public void putSet(DerValue[] set) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < set.length; ++i) {
            set[i].encode(bytes);
        }
        this.write((byte)49, bytes);
    }

    public void putOrderedSetOf(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, (Comparator)lexOrder);
    }

    public void putOrderedSet(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, (Comparator)tagOrder);
    }

    private void putOrderedSet(byte tag, DerEncoder[] set, Comparator order) throws IOException {
        DerOutputStream[] streams = new DerOutputStream[set.length];
        for (int i = 0; i < set.length; ++i) {
            streams[i] = new DerOutputStream();
            set[i].derEncode(streams[i]);
        }
        byte[][] bufs = new byte[streams.length][];
        for (int i = 0; i < streams.length; ++i) {
            bufs[i] = streams[i].toByteArray();
        }
        Arrays.sort(bufs, order);
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < streams.length; ++i) {
            bytes.write(bufs[i]);
        }
        this.write(tag, bytes);
    }

    public void putOrderedSetOf(byte tag, DerValue[] set) throws IOException {
        this.putOrderedSet(tag, set, (Comparator)lexOrder);
    }

    private void putOrderedSet(byte tag, DerValue[] set, Comparator order) throws IOException {
        byte[][] bufs = new byte[set.length][];
        for (int i = 0; i < set.length; ++i) {
            bufs[i] = set[i].toByteArray();
        }
        Arrays.sort(bufs, order);
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < set.length; ++i) {
            bytes.write(bufs[i]);
        }
        this.write(tag, bytes);
    }

    public void putPrintableString(String s) throws IOException {
        this.write(19);
        this.putLength(s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void putPrintableString(char[] s) throws IOException {
        this.write(19);
        this.putLength(s.length);
        for (int i = 0; i < s.length; ++i) {
            this.write((byte)s[i]);
        }
    }

    public void putVisibleString(String s) throws IOException {
        this.write(26);
        this.putLength(s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void putIA5String(String s) throws IOException {
        this.write(22);
        this.putLength(s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void putGeneralString(String s) throws IOException {
        this.write(27);
        this.putLength(s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void putBMPString(byte[] bmp) throws IOException {
        this.write(30);
        this.putLength(bmp.length);
        this.write(bmp);
    }

    public void putUTF8String(String s) throws IOException {
        this.write(12);
        byte[] bytes = UTFUtils.toUTF(s);
        this.putLength(bytes.length);
        this.write(bytes);
    }

    public void putUniverString(String s) throws IOException {
        this.write(28);
        byte[] bytes = UTFUtils.toUniv(s);
        this.putLength(bytes.length);
        this.write(bytes);
    }

    public void putBMPString(String str) throws IOException {
        this.write(30);
        if (str == null) {
            this.putLength(0);
        } else {
            this.putLength(str.length() * 2);
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            this.write((byte)(ch >>> 8));
            this.write((byte)(ch & 0xFF));
        }
    }

    public void putUTCTime(Date d) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyMMddHHmmss'Z'";
        Locale locale = new Locale("en", "US");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        sdf.setTimeZone(tz);
        byte[] utc = null;
        try {
            utc = sdf.format(d).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            utc = sdf.format(d).getBytes();
        }
        this.write(23);
        this.putLength(utc.length);
        this.write(utc);
    }

    public void putGeneralizedTime(Date d) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyyyMMddHHmmss'Z'";
        Locale locale = new Locale("en", "US");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        sdf.setTimeZone(tz);
        byte[] gt = null;
        try {
            gt = sdf.format(d).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            gt = sdf.format(d).getBytes();
        }
        this.write(24);
        this.putLength(gt.length);
        this.write(gt);
    }

    public void putLength(int len) throws IOException {
        if (len < 128) {
            this.write((byte)len);
        } else if (len < 256) {
            this.write(-127);
            this.write((byte)len);
        } else if (len < 65536) {
            this.write(-126);
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else if (len < 0x1000000) {
            this.write(-125);
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else {
            this.write(-124);
            this.write((byte)(len >> 24));
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        }
    }

    public void putTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        this.write(tag);
    }

    public void derEncode(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    public void putNamedBitString(BitArray ba) throws IOException {
        byte[] bits = ba.toByteArray();
        int count = ba.length();
        while (--count >= 0 && !ba.get(count)) {
        }
        this.write(3);
        if (count++ < 0) {
            this.putLength(1);
            this.write(0);
        } else {
            int len = (count + 7) / 8;
            this.putLength(len + 1);
            this.write(len * 8 - count);
            this.write(bits, 0, len);
        }
    }
}

