/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.misc.IOUtils;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerIndefLenConverter;
import com.ibm.security.util.DerInputBuffer;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Date;

public final class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    private byte tag;
    private String oid;
    protected DerInputBuffer buffer;
    private DerInputStream data;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_IndefBitString = 35;
    public static final byte tag_OctetString = 4;
    public static final byte tag_IndefOctetString = 36;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_IndefUTF8String = 44;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_IndefPrintableString = 51;
    public static final byte tag_T61String = 20;
    public static final byte tag_IndefT61String = 52;
    public static final byte tag_IA5String = 22;
    public static final byte tag_IndefIA5String = 54;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_VisibleString = 26;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_IndefGeneralString = 59;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_IndefUniversalString = 60;
    public static final byte tag_BMPString = 30;
    public static final byte tag_IndefBMPString = 62;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    public boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    public boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte cntxtTag) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == cntxtTag;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public boolean isConstructed(byte constructedTag) {
        if (!this.isConstructed()) {
            return false;
        }
        return (this.tag & 0x1F) == constructedTag;
    }

    public DerValue(String value) throws IOException {
        boolean isPrintableString = true;
        for (int i = 0; i < value.length(); ++i) {
            if (DerValue.isPrintableStringChar(value.charAt(i))) continue;
            isPrintableString = false;
            break;
        }
        this.init(isPrintableString ? (byte)19 : 12, value);
    }

    public DerValue(byte stringTag, String value) throws IOException {
        this.init(stringTag, value);
    }

    public DerValue(byte tag, byte[] data) {
        this.tag = tag;
        this.buffer = new DerInputBuffer((byte[])data.clone());
        this.length = data.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer in) throws IOException {
        this.tag = (byte)in.read();
        this.length = DerInputStream.getLength(in);
        if (this.length == -1) {
            in.rewind(2);
            byte[] bytes = DerIndefLenConverter.convertIndefToDef(in);
            in = new DerInputBuffer(bytes);
            this.tag = (byte)in.read();
            this.length = DerInputStream.getLength(in);
        }
        this.buffer = in.dup();
        this.buffer.truncate(this.length);
        this.data = new DerInputStream(this.buffer);
        in.skip(this.length);
    }

    public DerValue(byte[] buf) throws IOException {
        this.init(true, new ByteArrayInputStream(buf));
    }

    public DerValue(byte[] buf, int offset, int len) throws IOException {
        this.init(true, new ByteArrayInputStream(buf, offset, len));
    }

    public DerValue(InputStream in) throws IOException {
        this.init(false, in);
    }

    private void init(byte stringTag, String value) throws IOException {
        String enc = null;
        this.tag = stringTag;
        switch (stringTag) {
            case 19: 
            case 22: 
            case 27: {
                enc = "ASCII";
                break;
            }
            case 20: {
                enc = "ISO-8859-1";
                break;
            }
            case 30: {
                enc = "UnicodeBigUnmarked";
                break;
            }
            case 12: {
                enc = "UTF8";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DER string type");
            }
        }
        byte[] buf = value.getBytes(enc);
        this.length = buf.length;
        this.buffer = new DerInputBuffer(buf);
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    private void init(boolean fullyBuffered, InputStream in) throws IOException {
        this.tag = (byte)in.read();
        byte lenByte = (byte)in.read();
        this.length = DerInputStream.getLength(lenByte & 0xFF, in);
        if (this.length == -1) {
            int readLen = in.available();
            int offset = 2;
            byte[] indefData = new byte[readLen + offset];
            indefData[0] = this.tag;
            indefData[1] = lenByte;
            in.read(indefData, offset, readLen);
            ByteArrayInputStream bais = new ByteArrayInputStream(indefData);
            byte[] bytes = DerIndefLenConverter.convertIndefToDef(bais);
            in = new DerInputBuffer(bytes);
            if (this.tag != in.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getLength(in);
        }
        if (this.length == 0) {
            return;
        }
        if (fullyBuffered && in.available() != this.length) {
            throw new IOException("extra data given to DerValue constructor");
        }
        byte[] bytes = IOUtils.readFully(in, this.length, true);
        this.buffer = new DerInputBuffer(bytes);
        this.data = new DerInputStream(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(DerOutputStream out) throws IOException {
        out.write(this.tag);
        out.putLength(this.length);
        if (this.length > 0) {
            byte[] value = new byte[this.length];
            DerInputStream derInputStream = this.data;
            synchronized (derInputStream) {
                this.buffer.reset();
                if (this.buffer.read(value) != this.length) {
                    throw new IOException("short DER value read (encode)");
                }
                out.write(value);
            }
        }
    }

    public byte getTag() {
        return this.tag;
    }

    public DerInputStream getData() {
        return this.data;
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.length != 1) {
            throw new IOException("DerValue.getBoolean, invalid length " + this.length);
        }
        return this.buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DerValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    private byte[] append(byte[] a, byte[] b) {
        if (a == null) {
            return b;
        }
        byte[] ret = new byte[a.length + b.length];
        System.arraycopy(a, 0, ret, 0, a.length);
        System.arraycopy(b, 0, ret, a.length, b.length);
        return ret;
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4 && !this.isConstructed((byte)4)) {
            throw new IOException("DerValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] bytes = new byte[this.length];
        if (this.buffer.read(bytes) != this.length) {
            throw new IOException("short read on DerValue buffer");
        }
        if (this.isConstructed()) {
            DerInputStream in = new DerInputStream(bytes);
            bytes = null;
            while (in.available() != 0) {
                bytes = this.append(bytes, in.getOctetString());
            }
        }
        return bytes;
    }

    public BigInteger getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available());
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available());
    }

    public BigInteger getInteger(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available());
    }

    public BigInteger getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DerValue.getEnumerated, incorrect tag: " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available());
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        if (this.tag == 12) {
            return this.getUTF8String();
        }
        if (this.tag == 19) {
            return this.getPrintableString();
        }
        if (this.tag == 22) {
            return this.getIA5String();
        }
        if (this.tag == 20) {
            return this.getT61String();
        }
        if (this.tag == 30) {
            return this.getBMPStringAsString();
        }
        if (this.tag == 27) {
            return this.getGeneralString();
        }
        if (this.tag == 3) {
            return this.getBitStringAsString();
        }
        return null;
    }

    public byte[] getBitString(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataBytes() throws IOException {
        byte[] retVal = new byte[this.length];
        DerInputStream derInputStream = this.data;
        synchronized (derInputStream) {
            this.data.reset();
            this.data.getBytes(retVal);
        }
        return retVal;
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DerValue.getPrintableString, not a string " + this.tag);
        }
        return this.simpleGetString();
    }

    private String simpleGetString() throws IOException {
        StringBuilder s = new StringBuilder(this.length);
        try {
            int temp = this.length;
            this.data.reset();
            while (temp-- > 0) {
                s.append((char)this.data.getByte());
            }
        }
        catch (IOException e) {
            return null;
        }
        return new String(s);
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DerValue.getT61String, not T61 " + this.tag);
        }
        return this.simpleGetString();
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DerValue.getIA5String, not IA5 " + this.tag);
        }
        return this.simpleGetString();
    }

    public String getUTF8String() throws IOException {
        if (this.tag != 12) {
            throw new IOException("DerValue.getUTF8String, not UTF8 " + this.tag);
        }
        this.data.reset();
        StringBuilder s = UTFUtils.fromUTF(this.data.toByteArray());
        return new String(s);
    }

    public static String getUTF8String(byte[] data) throws IOException {
        StringBuilder s = UTFUtils.fromUTF(data);
        return new String(s);
    }

    public String getUniversalString() throws IOException {
        if (this.tag != 28) {
            throw new IOException("DerValue.getUniversalString, not Universal " + this.tag);
        }
        this.data.reset();
        StringBuilder s = UTFUtils.fromUniv(this.data.toByteArray());
        return new String(s);
    }

    public static String getUniversalString(byte[] data) throws IOException {
        StringBuilder s = UTFUtils.fromUniv(data);
        return new String(s);
    }

    public String getGeneralString() throws IOException {
        if (this.tag != 27) {
            throw new IOException("DerValue.getGeneralString, not General " + this.tag);
        }
        return this.simpleGetString();
    }

    public String getVisibleString() throws IOException {
        if (this.tag != 26) {
            throw new IOException("DerValue.getVisibleString, not Visible " + this.tag);
        }
        return this.simpleGetString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBMPStringAsString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getBMPString, not BMP " + this.tag);
        }
        StringBuilder s = new StringBuilder(this.length);
        try {
            int temp = this.length;
            DerInputStream derInputStream = this.data;
            synchronized (derInputStream) {
                this.data.reset();
                while (temp-- > 0) {
                    int ch1 = this.data.getByte();
                    int ch2 = this.data.getByte();
                    s.append((char)((ch1 << 8) + (ch2 << 0)));
                    --temp;
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return new String(s);
    }

    private String getBitStringAsString() throws IOException {
        byte[] data = this.getBitString();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(Integer.toHexString(data[i] & 0xFF) + " ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getBMPString, not BMP " + this.tag);
        }
        StringBuilder s = new StringBuilder(this.length);
        try {
            int temp = this.length;
            DerInputStream derInputStream = this.data;
            synchronized (derInputStream) {
                this.data.reset();
                while (temp-- > 0) {
                    int ch1 = this.data.getByte();
                    int ch2 = this.data.getByte();
                    s.append((char)((ch1 << 8) + (ch2 << 0)));
                    --temp;
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        String str = new String(s);
        try {
            return str.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    public Date getUTCTime() throws IOException {
        if (this.tag != 23) {
            throw new IOException("DerValue.getUTCTime, not a UtcTime: " + this.tag);
        }
        DerOutputStream derout = new DerOutputStream();
        derout.write(this.tag);
        derout.write(this.length);
        derout.write(this.data.toByteArray());
        DerInputStream derin = new DerInputStream(derout.toByteArray());
        return derin.getUTCTime();
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.tag != 24) {
            throw new IOException("DerValue.getGeneralizedTime, not a GeneralizedTime: " + this.tag);
        }
        DerOutputStream derout = new DerOutputStream();
        derout.write(this.tag);
        derout.write(this.length);
        derout.write(this.data.toByteArray());
        DerInputStream derin = new DerInputStream(derout.toByteArray());
        return derin.getGeneralizedTime();
    }

    public boolean equals(Object other) {
        if (other instanceof DerValue) {
            return this.equals((DerValue)other);
        }
        return false;
    }

    public boolean equals(DerValue other) {
        if (this == other) {
            return true;
        }
        if (this.tag != other.tag || this.length != other.length) {
            return false;
        }
        if (this.data == null && other.data == null) {
            return true;
        }
        if (this.data != null && other.data != null) {
            this.data.reset();
            other.data.reset();
            return this.buffer.equals(other.buffer);
        }
        return false;
    }

    public String toString() {
        try {
            if (this.tag == 19) {
                return "\"" + this.getPrintableString() + "\"";
            }
            if (this.tag == 5) {
                return "[DerValue, null]";
            }
            if (this.tag == 6) {
                if (this.oid == null) {
                    this.oid = new ObjectIdentifier(this.buffer.dup()).toString();
                }
                return "OID." + this.oid;
            }
            return "[DerValue, tag = " + this.tag + ", length = " + this.length + "]";
        }
        catch (IOException e) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.write(this.tag);
        out.putLength(this.length);
        DerInputStream derInputStream = this.data;
        synchronized (derInputStream) {
            if (this.length > 0) {
                byte[] value = new byte[this.length];
                this.buffer.reset();
                if (this.buffer.read(value) != this.length) {
                    throw new IOException("short DER value read (encode)");
                }
                out.write(value);
            }
            if (this.data != null) {
                this.data.reset();
            }
        }
        return out.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DerInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public int length() {
        return this.length;
    }

    public static boolean isPrintableStringChar(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return true;
        }
        switch (ch) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static byte createTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        return tag;
    }

    public void resetTag(byte tag) {
        this.tag = tag;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void reset() {
        this.data.reset();
        this.buffer.reset();
    }
}

