/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.validator.SimpleValidator;
import com.ibm.security.validator.ValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class EndEntityChecker {
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_EKU_TLS_SERVER = "1.3.6.1.5.5.7.3.1";
    private static final String OID_EKU_TLS_CLIENT = "1.3.6.1.5.5.7.3.2";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String NSCT_SSL_CLIENT = "ssl_client";
    private static final String NSCT_SSL_SERVER = "ssl_server";
    private static final String NSCT_CODE_SIGNING = "object_signing";
    private static final int KU_SIGNATURE = 0;
    private static final int KU_KEY_ENCIPHERMENT = 2;
    private static final Collection KU_SERVER_SIGNATURE = Arrays.asList("DHE_DSS", "DHE_RSA", "RSA_EXPORT", "UNKNOWN");
    private static final Collection KU_SERVER_ENCRYPTION = Arrays.asList("RSA");
    private final String variant;
    private final String type;

    private EndEntityChecker(String type, String variant) {
        this.type = type;
        this.variant = variant;
    }

    static EndEntityChecker getInstance(String type, String variant) {
        return new EndEntityChecker(type, variant);
    }

    void check(X509Certificate cert, Object parameter) throws CertificateException {
        if (this.variant.equals("generic")) {
            return;
        }
        if (this.variant.equals("tls server")) {
            this.checkTLSServer(cert, (String)parameter);
        } else if (this.variant.equals("tls client")) {
            this.checkTLSClient(cert);
        } else if (this.variant.equals("code signing")) {
            this.checkCodeSigning(cert);
        } else if (this.variant.equals("jce signing")) {
            this.checkCodeSigning(cert);
        } else {
            throw new CertificateException("Unknown variant: " + this.variant);
        }
    }

    private Set getCriticalExtensions(X509Certificate cert) {
        Set exts = cert.getCriticalExtensionOIDs();
        if (exts == null) {
            exts = Collections.EMPTY_SET;
        }
        return exts;
    }

    private void checkRemainingExtensions(Set exts) throws CertificateException {
        exts.remove("2.5.29.19");
        if (!exts.isEmpty()) {
            throw new CertificateException("Certificate contains unsupported critical extensions: " + exts);
        }
    }

    private boolean checkEKU(X509Certificate cert, Set exts, String expectedEKU) throws CertificateException {
        if (this.type.equals("Simple") && !exts.contains(OID_EXTENDED_KEY_USAGE)) {
            return true;
        }
        List<String> eku = cert.getExtendedKeyUsage();
        if (eku == null) {
            return true;
        }
        return eku.contains(expectedEKU) || eku.contains(OID_EKU_ANY_USAGE);
    }

    private boolean checkKeyUsage(X509Certificate cert, int bit) throws CertificateException {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage == null) {
            return true;
        }
        return keyUsage.length > bit && keyUsage[bit];
    }

    private void checkTLSClient(X509Certificate cert) throws CertificateException {
        Set exts = this.getCriticalExtensions(cert);
        if (!this.checkKeyUsage(cert, 0)) {
            throw new ValidatorException("KeyUsage does not allow digital signatures", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        if (!this.checkEKU(cert, exts, OID_EKU_TLS_CLIENT)) {
            throw new ValidatorException("Extended key usage does not permit use for TLS client authentication", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        if (!SimpleValidator.getNetscapeCertTypeBit(cert, NSCT_SSL_CLIENT)) {
            throw new ValidatorException("Netscape cert type does not permit use for SSL client", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        exts.remove("2.5.29.15");
        exts.remove(OID_EXTENDED_KEY_USAGE);
        exts.remove("2.16.840.1.113730.1.1");
        this.checkRemainingExtensions(exts);
    }

    private void checkTLSServer(X509Certificate cert, String parameter) throws CertificateException {
        Set exts = this.getCriticalExtensions(cert);
        if (KU_SERVER_ENCRYPTION.contains(parameter)) {
            if (!this.checkKeyUsage(cert, 2)) {
                throw new ValidatorException("KeyUsage does not allow key encipherment", ValidatorException.T_EE_EXTENSIONS, cert);
            }
        } else if (KU_SERVER_SIGNATURE.contains(parameter)) {
            if (!this.checkKeyUsage(cert, 0)) {
                throw new ValidatorException("KeyUsage does not allow digital signatures", ValidatorException.T_EE_EXTENSIONS, cert);
            }
        } else {
            throw new CertificateException("Unknown authType: " + parameter);
        }
        if (!this.checkEKU(cert, exts, OID_EKU_TLS_SERVER)) {
            throw new ValidatorException("Extended key usage does not permit use for TLS server authentication", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        if (!SimpleValidator.getNetscapeCertTypeBit(cert, NSCT_SSL_SERVER)) {
            throw new ValidatorException("Netscape cert type does not permit use for SSL server", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        exts.remove("2.5.29.15");
        exts.remove(OID_EXTENDED_KEY_USAGE);
        exts.remove("2.16.840.1.113730.1.1");
        this.checkRemainingExtensions(exts);
    }

    private void checkCodeSigning(X509Certificate cert) throws CertificateException {
        Set exts = this.getCriticalExtensions(cert);
        if (!this.checkKeyUsage(cert, 0)) {
            throw new ValidatorException("KeyUsage does not allow digital signatures", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        if (!this.checkEKU(cert, exts, OID_EKU_CODE_SIGNING)) {
            throw new ValidatorException("Extended key usage does not permit use for code signing", ValidatorException.T_EE_EXTENSIONS, cert);
        }
        if (!this.variant.equals("jce signing")) {
            if (!SimpleValidator.getNetscapeCertTypeBit(cert, NSCT_CODE_SIGNING)) {
                throw new ValidatorException("Netscape cert type does not permit use for code signing", ValidatorException.T_EE_EXTENSIONS, cert);
            }
            exts.remove("2.16.840.1.113730.1.1");
        }
        exts.remove("2.5.29.15");
        exts.remove(OID_EXTENDED_KEY_USAGE);
        this.checkRemainingExtensions(exts);
    }
}

