/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.validator.Validator;
import com.ibm.security.validator.ValidatorException;
import com.ibm.security.x509.NetscapeCertTypeExtension;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class SimpleValidator
extends Validator {
    static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    static final String OID_KEY_USAGE = "2.5.29.15";
    static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    static final ObjectIdentifier OBJID_NETSCAPE_CERT_TYPE = NetscapeCertTypeExtension.NetscapeCertType_Id;
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_CODE_SIGNING_CA = "object_signing_ca";
    private Map trustedX500Principals;
    private Collection trustedCerts;

    SimpleValidator(String variant, Collection trustedCerts) {
        super("Simple", variant);
        this.trustedCerts = trustedCerts;
        this.trustedX500Principals = new HashMap();
        for (X509Certificate cert : trustedCerts) {
            X500Principal principal = cert.getSubjectX500Principal();
            ArrayList<X509Certificate> coll = (ArrayList<X509Certificate>)this.trustedX500Principals.get(principal);
            if (coll == null) {
                coll = new ArrayList<X509Certificate>(2);
                this.trustedX500Principals.put(principal, coll);
            }
            coll.add(cert);
        }
    }

    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    X509Certificate[] engineValidate(X509Certificate[] chain, Collection otherCerts, Object parameter) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        chain = this.buildTrustedChain(chain);
        Date date = this.validationDate;
        if (date == null) {
            date = new Date();
        }
        for (int i = chain.length - 2; i >= 0; --i) {
            X509Certificate issuerCert = chain[i + 1];
            X509Certificate cert = chain[i];
            if (!this.variant.equals("code signing") && !this.variant.equals("jce signing")) {
                cert.checkValidity(date);
            }
            if (!cert.getIssuerX500Principal().equals(issuerCert.getSubjectX500Principal())) {
                throw new ValidatorException(ValidatorException.T_NAME_CHAINING, cert);
            }
            try {
                cert.verify(issuerCert.getPublicKey());
            }
            catch (GeneralSecurityException e) {
                throw new ValidatorException(ValidatorException.T_SIGNATURE_ERROR, cert, e);
            }
            if (i == 0) continue;
            this.checkExtensions(cert, i);
        }
        return chain;
    }

    private void checkExtensions(X509Certificate cert, int index) throws CertificateException {
        Set critSet = cert.getCriticalExtensionOIDs();
        if (critSet == null) {
            critSet = Collections.EMPTY_SET;
        }
        this.checkBasicConstraints(cert, critSet, index);
        this.checkKeyUsage(cert, critSet);
        this.checkNetscapeCertType(cert, critSet);
        if (!critSet.isEmpty()) {
            throw new ValidatorException("Certificate contains unknown critical extensions: " + critSet, ValidatorException.T_CA_EXTENSIONS, cert);
        }
    }

    private void checkNetscapeCertType(X509Certificate cert, Set critSet) throws CertificateException {
        if (!this.variant.equals("generic")) {
            if (this.variant.equals("tls client") || this.variant.equals("tls server")) {
                if (!SimpleValidator.getNetscapeCertTypeBit(cert, NSCT_SSL_CA)) {
                    throw new ValidatorException("Invalid Netscape CertType extension for SSL CA certificate", ValidatorException.T_CA_EXTENSIONS, cert);
                }
                critSet.remove(OID_NETSCAPE_CERT_TYPE);
            } else if (this.variant.equals("code signing") || this.variant.equals("jce signing")) {
                if (!SimpleValidator.getNetscapeCertTypeBit(cert, NSCT_CODE_SIGNING_CA)) {
                    throw new ValidatorException("Invalid Netscape CertType extension for code signing CA certificate", ValidatorException.T_CA_EXTENSIONS, cert);
                }
                critSet.remove(OID_NETSCAPE_CERT_TYPE);
            } else {
                throw new CertificateException("Unknown variant " + this.variant);
            }
        }
    }

    static boolean getNetscapeCertTypeBit(X509Certificate cert, String type) {
        try {
            NetscapeCertTypeExtension ext;
            if (cert instanceof X509CertImpl) {
                X509CertImpl certImpl = (X509CertImpl)cert;
                ObjectIdentifier oid = OBJID_NETSCAPE_CERT_TYPE;
                ext = (NetscapeCertTypeExtension)certImpl.getExtension(oid);
                if (ext == null) {
                    return true;
                }
            } else {
                byte[] extVal = cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
                if (extVal == null) {
                    return true;
                }
                DerInputStream in = new DerInputStream(extVal);
                byte[] encoded = in.getOctetString();
                encoded = new DerValue(encoded).getUnalignedBitString().toByteArray();
                ext = new NetscapeCertTypeExtension(encoded);
            }
            Boolean val = (Boolean)ext.get(type);
            return val;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void checkBasicConstraints(X509Certificate cert, Set critSet, int index) throws CertificateException {
        critSet.remove(OID_BASIC_CONSTRAINTS);
        int constraints = cert.getBasicConstraints();
        if (constraints < 0) {
            throw new ValidatorException("End user tried to act as a CA", ValidatorException.T_CA_EXTENSIONS, cert);
        }
        if (index - 1 > constraints) {
            throw new ValidatorException("Violated path length constraints", ValidatorException.T_CA_EXTENSIONS, cert);
        }
    }

    private void checkKeyUsage(X509Certificate cert, Set critSet) throws CertificateException {
        critSet.remove(OID_KEY_USAGE);
        critSet.remove(OID_EXTENDED_KEY_USAGE);
        boolean[] keyUsageInfo = cert.getKeyUsage();
        if (!(keyUsageInfo == null || keyUsageInfo.length >= 6 && keyUsageInfo[5])) {
            throw new ValidatorException("Wrong key usage: expected keyCertSign", ValidatorException.T_CA_EXTENSIONS, cert);
        }
    }

    private X509Certificate[] buildTrustedChain(X509Certificate[] chain) throws CertificateException {
        List list;
        X500Principal issuer;
        ArrayList<X509Certificate> c = new ArrayList<X509Certificate>(chain.length);
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = chain[i];
            X509Certificate trustedCert = this.getTrustedCertificate(cert);
            if (trustedCert != null) {
                c.add(trustedCert);
                return c.toArray(CHAIN0);
            }
            c.add(cert);
        }
        X509Certificate cert = chain[chain.length - 1];
        X500Principal subject = cert.getSubjectX500Principal();
        if (!subject.equals(issuer = cert.getIssuerX500Principal()) && (list = (List)this.trustedX500Principals.get(issuer)) != null) {
            X509Certificate trustedCert = (X509Certificate)list.iterator().next();
            c.add(trustedCert);
            return c.toArray(CHAIN0);
        }
        throw new ValidatorException(ValidatorException.T_NO_TRUST_ANCHOR);
    }

    private X509Certificate getTrustedCertificate(X509Certificate cert) {
        X500Principal certSubjectName = cert.getSubjectX500Principal();
        List list = (List)this.trustedX500Principals.get(certSubjectName);
        if (list == null) {
            return null;
        }
        X500Principal certIssuerName = cert.getIssuerX500Principal();
        PublicKey certPublicKey = cert.getPublicKey();
        for (X509Certificate mycert : list) {
            if (mycert.equals(cert)) {
                return cert;
            }
            if (!mycert.getIssuerX500Principal().equals(certIssuerName) || !mycert.getPublicKey().equals(certPublicKey)) continue;
            return mycert;
        }
        return null;
    }
}

