/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.CRLDistributionPoints";
    public static final String NAME = "CRLDistributionPoints";
    public static final String DISTRIBUTION_PTS = "distribution_pts";
    private DistributionPoint[] dPoints = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CRLDistributionPointsExtension";

    public CRLDistributionPointsExtension(boolean critical, DistributionPoint[] distributionPoints) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLDistributionPointsExtension", new Boolean(critical), distributionPoints);
        }
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = critical;
        this.dPoints = (DistributionPoint[])distributionPoints.clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    public CRLDistributionPointsExtension(boolean critical, byte[] value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLDistributionPointsExtension", new Boolean(critical), value);
        }
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = critical;
        this.extensionValue = new byte[value.length];
        System.arraycopy(value, 0, this.extensionValue, 0, value.length);
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    public CRLDistributionPointsExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLDistributionPointsExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "CRLDistributionPointsExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    public CRLDistributionPointsExtension(DerValue derval) throws IOException {
        super(derval);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CRLDistributionPointsExtension", derval);
        }
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DISTRIBUTION_PTS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(DISTRIBUTION_PTS)) {
            if (!(obj instanceof DistributionPoint[])) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type DistributionPoint[].");
                }
                throw new IOException("Attribute value should be of type DistributionPoint[].");
            }
            DistributionPoint[] tmp = (DistributionPoint[])obj;
            this.dPoints = new DistributionPoint[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                DerOutputStream derout = new DerOutputStream();
                tmp[i].encode(derout);
                this.dPoints[i] = new DistributionPoint(derout.toByteArray());
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(DISTRIBUTION_PTS)) {
            if (this.dPoints != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.dPoints.clone());
                }
                return this.dPoints.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(DISTRIBUTION_PTS)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
        }
        this.dPoints = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        String out;
        block8: {
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            out = super.toString();
            out = out + this.getName() + " [\r\n";
            if (this.dPoints == null) {
                try {
                    this.decodeThis();
                }
                catch (Exception e) {
                    if (debug == null) break block8;
                    debug.exception(16384L, className, "toString", e);
                }
            }
        }
        if (this.dPoints == null) {
            out = out + "No distribution points\r\n";
        } else {
            out = out + this.dPoints.length + " CRL Distribution Points:\r\n";
            for (int i = 0; i < this.dPoints.length; ++i) {
                out = out + this.dPoints[i].toString();
            }
        }
        out = out + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] retval = null;
        if (debug != null) {
            debug.entry(16384L, className, "getDistributionPoints");
        }
        try {
            if (this.dPoints == null || this.dPoints.length == 0) {
                if (this.extensionValue == null || this.extensionValue.length == 0) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getDistributionPoints_1", null);
                    }
                    return null;
                }
                this.decodeThis();
            }
            retval = new DistributionPoint[this.dPoints.length];
            for (int i = 0; i < this.dPoints.length; ++i) {
                DerOutputStream out = new DerOutputStream();
                this.dPoints[i].encode(out);
                DerValue derVal = new DerValue(out.toByteArray());
                retval[i] = new DistributionPoint(derVal.toByteArray());
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getDistributionPoints", e);
                debug.exit(16384L, (Object)className, "getDistributionPoints_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDistributionPoints_3", retval);
        }
        return retval;
    }

    @Override
    public byte[] getExtensionValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtensionValue");
        }
        byte[] extValue = null;
        if (this.extensionValue == null || this.extensionValue.length == 0) {
            if (this.dPoints == null || this.dPoints.length == 0) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
                }
                return null;
            }
            try {
                this.encodeThis();
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getExtensionValue", e);
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
        }
        int len = this.extensionValue.length;
        extValue = new byte[len];
        System.arraycopy(this.extensionValue, 0, extValue, 0, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getExtensionValue_3", extValue);
        }
        return extValue;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.dPoints == null || this.dPoints.length == 0) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.dPoints.length; ++i) {
            this.dPoints[i].encode(tmp);
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    private void decodeThis() throws IOException {
        DerValue derVal;
        if (debug != null) {
            debug.entry(16384L, className, "decodeThis");
        }
        if ((derVal = new DerValue(this.extensionValue)).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decodeThis", "CRLDistributionPointsExtension parsing error: not a SEQUENCE.");
            }
            throw new IOException("CRLDistributionPointsExtension parsing error: not a SEQUENCE.");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decodeThis", "No data available in DER encoded value.");
            }
            throw new IOException("No data available in DER encoded value.");
        }
        ArrayList<DistributionPoint> dPointsList = new ArrayList<DistributionPoint>();
        while (derVal.getData() != null && derVal.getData().available() != 0) {
            DerValue derVal2 = derVal.getData().getDerValue();
            DistributionPoint dp = new DistributionPoint(derVal2.toByteArray());
            dPointsList.add(dp);
        }
        if (dPointsList.size() > 0) {
            this.dPoints = new DistributionPoint[dPointsList.size()];
            for (int i = 0; i < dPointsList.size(); ++i) {
                this.dPoints[i] = (DistributionPoint)dPointsList.get(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decodeThis");
        }
    }
}

