/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateIssuerExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.CertificateIssuer";
    public static final String NAME = "CertificateIssuer";
    public static final String NUMBER = "value";
    GeneralNames names = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateIssuerExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        try {
            this.names.encode(os);
        }
        catch (GeneralNamesException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encodeThis", e);
            }
            throw new IOException("CertificateIssuer: " + e);
        }
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public CertificateIssuerExtension(GeneralNames names) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateIssuerExtension", names);
        }
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = true;
        if (names != null) {
            this.names = (GeneralNames)names.clone();
            this.encodeThis();
        } else {
            this.names = names;
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificateIssuerExtension");
        }
    }

    public CertificateIssuerExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateIssuerExtension");
        }
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = true;
        this.names = new GeneralNames();
        if (debug != null) {
            debug.exit(16384L, className, "CertificateIssuerExtension");
        }
    }

    public CertificateIssuerExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateIssuerExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "CertificateIssuerExtension", "CertificateIssuer: Illegal argument type");
            }
            throw new IOException("CertificateIssuer: Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        try {
            this.names = new GeneralNames(val);
        }
        catch (GeneralNamesException e) {
            if (debug != null) {
                debug.exception(16384L, className, "CertificateIssuerExtension", e);
            }
            throw new IOException("CertificateIssuer: " + e);
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificateIssuerExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.names == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        String s = super.toString() + "CertificateIssuer [\n" + this.names.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificateIssuer_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof GeneralNames)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralNames.");
                }
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = obj != null ? (GeneralNames)((GeneralNames)obj).clone() : (GeneralNames)obj;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CertificateIssuer.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuer.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.names != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.names.clone());
                }
                return this.names.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.names);
            }
            return this.names;
        }
        if (debug != null) {
            debug.text(16384L, className, "get_3", "Attribute name not recognized by CertAttrSet:CertificateIssuer.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuer.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CertificateIssuer.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuer.");
        }
        this.names = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

