/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;

public final class EDIPartyName
implements GeneralNameInterface {
    private static final byte TAG_ASSIGNER = 0;
    private static final byte TAG_PARTYNAME = 1;
    private String assigner = null;
    private String party = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.EDIPartyName";

    public EDIPartyName(String assignerName, String partyName) {
        if (debug != null) {
            debug.entry(16384L, className, "EDIPartyName", assignerName, partyName);
        }
        this.assigner = assignerName;
        this.party = partyName;
        if (debug != null) {
            debug.exit(16384L, className, "EDIPartyName");
        }
    }

    public EDIPartyName(String partyName) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EDIPartyName", partyName);
            debug.exit(16384L, className, "EDIPartyName");
        }
        this.party = partyName;
    }

    public EDIPartyName(DerValue derValue) throws IOException {
        DerInputStream in;
        DerValue[] seq;
        int len;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EDIPartyName", derValue);
        }
        if ((len = (seq = (in = new DerInputStream(derValue.toByteArray())).getSequence(2)).length) < 1 || len > 2) {
            if (debug != null) {
                debug.text(16384L, className, "EDIPartyName", "Invalid encoding of EDIPartyName");
            }
            throw new IOException("Invalid encoding of EDIPartyName");
        }
        for (int i = 0; i < len; ++i) {
            DerValue opt = seq[i];
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                if (this.assigner != null) {
                    throw new IOException("Duplicate nameAssigner found in EDIPartyName");
                }
                opt = opt.getData().getDerValue();
                this.assigner = opt.getAsString();
            }
            if (!opt.isContextSpecific((byte)1) || opt.isConstructed()) continue;
            if (this.party != null) {
                throw new IOException("Duplicate partyName found in EDIPartyName");
            }
            opt = opt.getData().getDerValue();
            this.party = opt.getAsString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "EDIPartyName");
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 5);
        }
        return 5;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tagged = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (this.assigner != null) {
            DerOutputStream tmp2 = new DerOutputStream();
            tmp2.putPrintableString(this.assigner);
            tagged.write(DerValue.createTag((byte)-128, false, (byte)0), tmp2);
        }
        if (this.party == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot have null partyName");
            }
            throw new IOException("Cannot have null partyName");
        }
        tmp.putPrintableString(this.party);
        tagged.write(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        out.write((byte)48, tagged);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "EDIPartyName: " + (this.assigner == null ? "" : "  nameAssigner = " + this.assigner + ",") + "  partyName = " + this.party);
        }
        return "EDIPartyName: " + (this.assigner == null ? "" : "  nameAssigner = " + this.assigner + ",") + "  partyName = " + this.party;
    }

    public String getAssignerName() {
        return this.assigner;
    }

    public String getPartyName() {
        return this.party;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EDIPartyName)) {
            return false;
        }
        String otherAssigner = ((EDIPartyName)other).assigner;
        if (this.assigner == null ? otherAssigner != null : !this.assigner.equals(otherAssigner)) {
            return false;
        }
        String otherParty = ((EDIPartyName)other).party;
        return !(this.party == null ? otherParty != null : !this.party.equals(otherParty));
    }

    public int hashCode() {
        if (this.assigner != null) {
            return this.assigner.hashCode() + this.party.hashCode();
        }
        return this.party.hashCode();
    }

    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 5) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching of names not supported for EDIPartyName");
        }
        return constraintType;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for EDIPartyName");
    }
}

