/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetscapeCertTypeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.NetscapeCertType";
    public static final String NAME = "NetscapeCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String S_MIME = "s_mime";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String S_MIME_CA = "s_mime_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.NetscapeCertTypeExtension";
    public static ObjectIdentifier NetscapeCertType_Id;
    private boolean[] bitString;
    private static MapEntry[] mMapData;
    private static final ArrayList<String> mAttributeNames;

    private static int getPosition(String name) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getPosition", name);
        }
        for (int i = 0; i < mMapData.length; ++i) {
            if (!name.equalsIgnoreCase(NetscapeCertTypeExtension.mMapData[i].mName)) continue;
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPosition", NetscapeCertTypeExtension.mMapData[i].mPosition);
            }
            return NetscapeCertTypeExtension.mMapData[i].mPosition;
        }
        if (debug != null) {
            debug.text(8192L, className, "getPosition", "Attribute name [" + name + "] not recognized by CertAttrSet:NetscapeCertType.");
        }
        throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:NetscapeCertType.");
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        DerOutputStream os = new DerOutputStream();
        os.putNamedBitString(new BitArray(this.bitString));
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis");
        }
    }

    private boolean isSet(int position) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isSet", new Integer(position));
            debug.exit(8192L, (Object)className, "isSet", this.bitString.length > position ? this.bitString[position] : false);
        }
        return this.bitString.length > position ? this.bitString[position] : false;
    }

    private void set(int position, boolean val) {
        if (debug != null) {
            debug.entry(8192L, className, "set", new Integer(position), new Boolean(val));
        }
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
        if (debug != null) {
            debug.exit(8192L, className, "set");
        }
    }

    public NetscapeCertTypeExtension(byte[] bitString) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "NetscapeCertTypeExtension", (Object)bitString);
        }
        this.bitString = new BitArray(bitString.length * 8, bitString).toBooleanArray();
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public NetscapeCertTypeExtension(boolean[] bitString) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "NetscapeCertTypeExtension", (Object)bitString);
        }
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = bitString != null ? (boolean[])bitString.clone() : bitString;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public NetscapeCertTypeExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NetscapeCertTypeExtension", critical, value);
        }
        this.extensionId = NetscapeCertType_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.bitString = val.getUnalignedBitString().toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    public NetscapeCertTypeExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "NetscapeCertTypeExtension");
        }
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = new boolean[0];
        if (debug != null) {
            debug.exit(16384L, className, "NetscapeCertTypeExtension");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Boolean)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Boolean.");
            }
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        this.set(NetscapeCertTypeExtension.getPosition(name), val);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
            debug.exit(16384L, (Object)className, "get", new Boolean(this.isSet(NetscapeCertTypeExtension.getPosition(name))));
        }
        return new Boolean(this.isSet(NetscapeCertTypeExtension.getPosition(name)));
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        this.set(NetscapeCertTypeExtension.getPosition(name), false);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        String s;
        block11: {
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            s = super.toString() + "NetscapeCertType [\n";
            try {
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT))) {
                    s = s + "   SSL client\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                    s = s + "   SSL server\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME))) {
                    s = s + "   S/MIME\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                    s = s + "   Object Signing\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA))) {
                    s = s + "   SSL CA\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA))) {
                    s = s + "   S/MIME CA\n";
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                    s = s + "   Object Signing CA";
                }
            }
            catch (Exception e) {
                if (debug == null) break block11;
                debug.exception(16384L, className, "toString", e);
            }
        }
        s = s + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = NetscapeCertType_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        Enumeration<String> enums = Collections.enumeration(mAttributeNames);
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
            debug.exit(16384L, (Object)className, "getElements", enums);
        }
        return enums;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public boolean[] getKeyUsageMappedBits() {
        KeyUsageExtension keyUsage;
        block7: {
            if (debug != null) {
                debug.entry(16384L, className, "getKeyUsageMappedBits");
            }
            keyUsage = new KeyUsageExtension();
            Boolean val = new Boolean(true);
            try {
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                    keyUsage.set("digital_signature", val);
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                    keyUsage.set("key_encipherment", val);
                }
                if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                    keyUsage.set("key_certsign", val);
                }
            }
            catch (IOException e) {
                if (debug == null) break block7;
                debug.exception(16384L, className, "getKeyUsageMappedBits", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyUsageMappedBits", keyUsage.getBits());
        }
        return keyUsage.getBits();
    }

    static {
        try {
            NetscapeCertType_Id = new ObjectIdentifier(CertType_data);
        }
        catch (Exception e) {
            // empty catch block
        }
        mMapData = new MapEntry[]{new MapEntry(SSL_CLIENT, 0), new MapEntry(SSL_SERVER, 1), new MapEntry(S_MIME, 2), new MapEntry(OBJECT_SIGNING, 3), new MapEntry(SSL_CA, 5), new MapEntry(S_MIME_CA, 6), new MapEntry(OBJECT_SIGNING_CA, 7)};
        mAttributeNames = new ArrayList();
        for (int i = 0; i < mMapData.length; ++i) {
            mAttributeNames.add(NetscapeCertTypeExtension.mMapData[i].mName);
        }
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String name, int position) {
            this.mName = name;
            this.mPosition = position;
        }
    }
}

