/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Util;
import java.util.Vector;

public final class TraceArgs {
    public static String traceFile;
    public static String outputFile;
    public static boolean indent;
    public static boolean summary;
    public static boolean debug;
    public static boolean symbolic;
    public static boolean gui;
    public static boolean j9;

    protected static final void initStatics() {
        traceFile = null;
        outputFile = null;
        indent = false;
        summary = false;
        debug = false;
        symbolic = false;
        gui = false;
        j9 = false;
    }

    public TraceArgs(String[] stringArray) throws UsageException {
        if (stringArray.length > 0) {
            traceFile = stringArray[0];
            if (stringArray.length > 1) {
                int n;
                if (stringArray[1].startsWith("-")) {
                    outputFile = stringArray[0] + ".fmt";
                    n = 1;
                } else {
                    outputFile = stringArray[1];
                    n = 2;
                }
                while (n < stringArray.length) {
                    if (stringArray[n].equals("-summary")) {
                        summary = true;
                    } else if (stringArray[n].startsWith("-entries:")) {
                        this.parseComponentParameter(stringArray[n]);
                    } else if (stringArray[n].startsWith("-thread:")) {
                        this.parseThread(stringArray[n]);
                    } else if (stringArray[n].equals("-indent")) {
                        indent = true;
                    } else if (stringArray[n].equals("-symbolic")) {
                        symbolic = true;
                    } else if (stringArray[n].equals("-debug")) {
                        debug = true;
                    } else if (stringArray[n].equals("-j9")) {
                        j9 = true;
                    } else {
                        throw new UsageException();
                    }
                    ++n;
                }
            } else {
                outputFile = stringArray[0] + ".fmt";
            }
        } else {
            throw new UsageException();
        }
    }

    private void parseComponentParameter(String string) throws UsageException {
        String string2 = string.substring("-entries:".length());
        this.parseComponents(string2);
    }

    private void parseComponents(String string) throws UsageException {
        int n = string.indexOf("(");
        int n2 = string.indexOf(",");
        if (n2 != -1) {
            if (n2 < n) {
                this.parseComponent(string.substring(0, n2));
                this.parseComponents(string.substring(n2 + 1, string.length()));
            } else {
                int n3 = string.indexOf(")");
                this.parseComponent(string.substring(0, n3 + 1));
                int n4 = string.indexOf(",", n3);
                if (n4 != -1) {
                    this.parseComponents(string.substring(n4 + 1, string.length()));
                }
            }
        } else {
            this.parseComponent(string);
        }
    }

    private void parseComponent(String string) throws UsageException {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n2 < n) {
            throw new UsageException();
        }
        if (n2 == n) {
            Util.putComponent(string);
        } else {
            int n3;
            Vector vector = new Vector(10);
            String string2 = string.substring(n + 1, string.length() - 1);
            while ((n3 = string2.indexOf(",")) != -1) {
                vector.addElement(string2.substring(0, n3));
                string2 = string2.substring(n3 + 1, string2.length());
            }
            vector.addElement(string2.substring(0, string2.length()));
            Util.putComponent(string.substring(0, n), vector);
        }
    }

    private void parseThread(String string) throws UsageException {
        try {
            int n;
            String string2 = string.substring("-thread:".length());
            while ((n = string2.indexOf(",")) != -1) {
                Util.putThreadID(Long.decode(string2.substring(0, n)));
                string2 = string2.substring(n + 1, string2.length());
            }
            Util.putThreadID(Long.decode(string2.substring(0, string2.length())));
        }
        catch (NumberFormatException numberFormatException) {
            throw new UsageException("Bad thread ID");
        }
    }

    class UsageException
    extends Exception {
        UsageException(String string) {
            super(string);
        }

        UsageException() {
        }
    }
}

