/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.DataChainPolicy;

class DataLink {
    private byte[] buffer;
    private DataLink next;
    private int size;
    private int writePosition = 0;
    private static int defaultBufferSize = 32;
    private boolean isWriteable = true;

    protected DataLink(int n, DataLink dataLink) {
        this.buffer = new byte[n];
        this.size = n;
        this.next = dataLink == null ? this : dataLink;
    }

    protected DataLink() {
        this(defaultBufferSize, null);
    }

    private boolean isWriteable(DataChainPolicy dataChainPolicy) {
        return this.isWriteable;
    }

    protected int write(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.size - this.writePosition);
        System.arraycopy(byArray, n, this.buffer, this.writePosition, n3);
        this.writePosition += n3;
        return n3;
    }

    protected DataLink getNextWriteableLink(DataChainPolicy dataChainPolicy) {
        while (this.next.isEmpty() && this.next != this) {
            if (dataChainPolicy.isUsable(this.next.size)) {
                return this.next;
            }
            this.next = this.next.next;
        }
        this.next = new DataLink(dataChainPolicy.getBufferSize(), this.next);
        return this.next;
    }

    protected byte[] read() {
        byte[] byArray = new byte[this.writePosition];
        System.arraycopy(this.buffer, 0, byArray, 0, this.writePosition);
        return byArray;
    }

    protected int availableToWrite() {
        return this.size - this.writePosition;
    }

    protected int availableToRead() {
        return this.writePosition;
    }

    protected DataLink getNextLink() {
        return this.next;
    }

    protected void reset() {
        this.isWriteable = true;
        this.writePosition = 0;
    }

    protected boolean isEmpty() {
        return this.isWriteable && this.writePosition == 0;
    }

    protected void prune() {
        DataLink dataLink = this;
        while (dataLink.getNextLink().isEmpty() && (dataLink = dataLink.getNextLink()) != this) {
        }
        this.next = dataLink;
    }
}

