/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.IntEnumeration;
import java.util.BitSet;

public abstract class SuperMap {
    static final int INITIAL_SIZE = 17;
    int[] keys = new int[17];
    int tableSize = 17;
    int slotsInUse;
    BitSet occupied = new BitSet();
    int size;
    static final int[] smallPrimes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};

    public int memoryUsage() {
        return this.tableSize * 9;
    }

    abstract Object getValues();

    abstract void allocNewValues(int var1);

    abstract void put(int var1, Object var2, int var3);

    void rehash() {
        int[] nArray = this.keys;
        Object object = this.getValues();
        BitSet bitSet = this.occupied;
        this.tableSize <<= 1;
        while (!this.isprime(++this.tableSize)) {
        }
        this.keys = new int[this.tableSize];
        this.allocNewValues(this.tableSize);
        this.occupied = new BitSet();
        this.slotsInUse = 0;
        int n = this.size;
        for (int i = 0; i < nArray.length; ++i) {
            if (!bitSet.get(i)) continue;
            this.put(nArray[i], object, i);
        }
        this.size = n;
    }

    int getIndex(int n) {
        for (int i = 0; i < this.tableSize; ++i) {
            int n2 = this.h(n & Integer.MAX_VALUE, i);
            if (!this.occupied.get(n2)) {
                return -1;
            }
            if (this.keys[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    void checkRehash() {
        if (this.slotsInUse > this.tableSize * 3 / 4) {
            this.rehash();
        }
    }

    int putIndex(int n) {
        ++this.size;
        for (int i = 0; i < this.tableSize; ++i) {
            int n2 = this.h(n & Integer.MAX_VALUE, i);
            if (!this.occupied.get(n2)) {
                this.keys[n2] = n;
                this.occupied.set(n2);
                ++this.slotsInUse;
                return n2;
            }
            if (this.keys[n2] != n) continue;
            return n2;
        }
        throw new Error("table full! key = " + n + " tableSize = " + this.tableSize + " slotsInUse = " + this.slotsInUse);
    }

    public int size() {
        return this.size;
    }

    public IntEnumeration getKeys() {
        return new KeyEnum();
    }

    private int h1(int n) {
        return n % this.tableSize;
    }

    private int h2(int n) {
        return 1 + n % (this.tableSize - 2);
    }

    private int h(int n, int n2) {
        long l = (long)this.h1(n) + (long)n2 * (long)this.h2(n);
        return (int)(l % (long)this.tableSize);
    }

    private boolean isprime(int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < smallPrimes.length; ++i) {
            n3 = smallPrimes[i];
            if (n % n3 != 0) continue;
            return false;
        }
        for (n2 = n; n / n2 < n2; n2 >>= 1) {
        }
        n2 <<= 1;
        n3 += 2;
        while (n3 < n2) {
            if (n % n3 == 0) {
                return false;
            }
            n3 += 2;
        }
        return true;
    }

    class KeyEnum
    implements IntEnumeration {
        int index = 0;
        boolean hasMore = true;

        KeyEnum() {
            this.reset();
        }

        void next() {
            while (this.index < SuperMap.this.tableSize && !SuperMap.this.occupied.get(this.index)) {
                ++this.index;
            }
            if (this.index == SuperMap.this.tableSize) {
                this.hasMore = false;
            }
        }

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            return new Integer(this.nextInt());
        }

        public int nextInt() {
            int n = SuperMap.this.keys[this.index++];
            this.next();
            return n;
        }

        public int peekInt() {
            return SuperMap.this.keys[this.index];
        }

        public void reset() {
            this.index = 0;
            this.hasMore = true;
            this.next();
        }
    }
}

