/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.CharsetContains;
import com.ibm.nio.cs.Converter;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import sun.security.action.GetPropertyAction;

public class IBMCharsets
extends CharsetProvider
implements CharsetContains {
    private Map classMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map aliasMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map aliasNameMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map cache = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map containsMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    static IBMCharsets instance = null;
    boolean gotMore;
    private static final boolean sjisIsMS932;

    public IBMCharsets() {
        this.defineCharsets();
        this.gotMore = false;
        instance = this;
    }

    public static IBMCharsets getInstance() {
        if (instance == null) {
            IBMCharsets iBMCharsets = new IBMCharsets();
        }
        return instance;
    }

    private static void put(Map map, String string, Object object) {
        if (!map.containsKey(string)) {
            map.put(string, object);
        }
    }

    protected void charset(String string, String string2, long l, String[] stringArray) {
        IBMCharsets.put(this.classMap, string, string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                IBMCharsets.put(this.aliasMap, stringArray[i], string);
            }
            IBMCharsets.put(this.aliasNameMap, string, stringArray);
        }
        IBMCharsets.put(this.aliasMap, string, string);
        if (l != 0L) {
            this.containsMap.put(string, new Long(l));
        }
    }

    protected void charset(String string, String string2, String[] stringArray) {
        this.charset(string, string2, 0L, stringArray);
    }

    public String getCanonicalName(String string) {
        return this.canonicalize(string);
    }

    public void setContains(String string, long l) {
        IBMCharsets.put(this.containsMap, string, new Long(l));
    }

    public long getContains(String string) {
        Long l = (Long)this.containsMap.get(string);
        if (l != null) {
            return l;
        }
        String string2 = this.getCanonicalName(string);
        if (string2 != null && (l = (Long)this.containsMap.get(string2)) != null) {
            return l;
        }
        return 0x2000000000000000L;
    }

    private String replaceDash(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '_') continue;
            cArray[i] = 45;
        }
        return new String(cArray);
    }

    private String canonicalize(String string) {
        String string2 = (String)this.aliasMap.get(string);
        if (string2 == null) {
            String string3 = string.toLowerCase(Locale.US);
            if (string3.startsWith("ibm")) {
                int n;
                for (n = 3; n <= string.length() && string.charAt(n) == '0'; ++n) {
                }
                string2 = (String)this.aliasMap.get("ibm-" + string.substring(n));
            } else {
                string2 = string3.startsWith("cp") ? (String)this.aliasMap.get("ibm-" + string.substring(2)) : (string3.indexOf(95) >= 0 ? (String)this.aliasMap.get(this.replaceDash(string3)) : (String)this.aliasMap.get("ibm-" + string));
            }
        }
        return string2 != null ? string2 : string;
    }

    private Charset lookup(String string) {
        Charset charset = null;
        SoftReference softReference = (SoftReference)this.cache.get(string);
        if (softReference != null && (charset = (Charset)softReference.get()) != null) {
            return charset;
        }
        String string2 = (String)this.classMap.get(string);
        if (string2 == null) {
            return null;
        }
        if (string2.charAt(0) == '>') {
            try {
                Class clazz = Class.forName("com.ibm.nio.cs." + string2.substring(1));
                charset = (Charset)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace(System.err);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(System.err);
                return null;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace(System.err);
                return null;
            }
            catch (Error error) {
                error.printStackTrace(System.err);
            }
        } else {
            try {
                charset = new Converter(string, string2);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                return null;
            }
        }
        this.cache.put(string, new SoftReference(charset));
        return charset;
    }

    public final String[] aliases(String string) {
        String[] stringArray = (String[])this.aliasNameMap.get(string);
        if (stringArray == null && string.startsWith("IBM-")) {
            stringArray = new String[]{"Cp" + string.substring(4), "ibm" + string.substring(4)};
        }
        return stringArray;
    }

    public Charset charsetForName(String string) {
        Charset charset = this.lookup(this.canonicalize(string));
        return charset;
    }

    public final Iterator charsets() {
        return new Iterator(){
            Iterator i;
            {
                this.i = IBMCharsets.this.classMap.keySet().iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                String string;
                Charset charset;
                while ((charset = IBMCharsets.this.lookup(string = (String)this.i.next())) == null) {
                }
                return charset;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void defineCharsets() {
        this.charset("UTF-8", "!UTF8", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF8", "UTF_8"});
        this.charset("CESU-8", "!CESU8", 0x3FFFFFFFFFFFFFFFL, new String[]{"CESU8"});
        this.charset("UTF-8J", "!UTF8J", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF8J"});
        this.charset("UTF-16", "!Unicode", 0x3FFFFFFFFFFFFFFFL, new String[]{"Unicode", "UTF16", "UTF_16", "UCS-2"});
        this.charset("UTF-16BE", "!UTF-16BE", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF16BE", "UTF_16BE", "UnicodeBigUnmarked", "ISO-10646-UCS-2", "X-UTF-16BE"});
        this.charset("UTF-16LE", "!UTF-16LE", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF16LE", "UTF_16LE", "UnicodeLittleUnmarked", "X-UTF-16LE"});
        this.charset("X-UnicodeBig", "!UnicodeBig", 0x3FFFFFFFFFFFFFFFL, new String[]{"UnicodeBig"});
        this.charset("X-UnicodeLittle", "!UnicodeLittle", 0x3FFFFFFFFFFFFFFFL, new String[]{"UnicodeLittle"});
        this.charset("UTF-32", "!UTF32", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF32", "ISO-10646-UCS-4", "UCS-4"});
        this.charset("UTF-32BE", "!UTF32BE", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF32BE", "UTF_32BE", "X-UTF-32BE"});
        this.charset("UTF-32LE", "!UTF32LE", 0x3FFFFFFFFFFFFFFFL, new String[]{"UTF32LE", "UTF_32LE", "X-UTF-32LE"});
        this.charset("windows-1250", "Cp1250", 4390914L, new String[]{"Cp1250", "ibm-1250"});
        this.charset("windows-1251", "Cp1251", 541261840L, new String[]{"Cp1251", "ibm-1251"});
        this.charset("windows-1252", "Cp1252", 4407297L, new String[]{"Cp1252", "ibm-1252"});
        this.charset("windows-1253", "Cp1253", 0x430040L, new String[]{"Cp1253", "ibm-1253"});
        this.charset("windows-1254", "Cp1254", 4391168L, new String[]{"Cp1254", "ibm-1254"});
        this.charset("windows-1255", "Cp1255", 4391040L, new String[]{"Cp1255", "ibm-1255"});
        this.charset("windows-1256", "Cp1256", 407044128L, new String[]{"Cp1256", "ibm-1256"});
        this.charset("windows-1256S", "Cp1256S", 407044128L, new String[]{"Cp1256s", "ibm-1256s"});
        this.charset("windows-1257", "Cp1257", 4390920L, new String[]{"Cp1257", "ibm-1257"});
        if (sjisIsMS932) {
            this.charset("windows-932", "MS932", 140784733061120L, new String[]{"MS932", "ms_kanji", "csshiftjis", "shift_jis", "x-sjis", "s-jis", "windows-31j", "cswindows31j"});
            this.charset("sjis", ">SJIS", 0xB00010000L, null);
        } else {
            this.charset("windows-932", "MS932", 140784733061120L, new String[]{"MS932", "ms_kanji", "windows-31j", "cswindows31j"});
            this.charset("sjis", ">SJIS", 0xB00010000L, new String[]{"shift_jis", "csshiftjis", "sjis", "s-jis", "x-sjis"});
        }
        this.charset("windows-936", "GB18030,3", 140943646851072L, new String[]{"MS936", "936", "x-mswin-936"});
        this.charset("GB18030", "GB18030", 0x3FFFFFFFFFFFFFFFL, new String[]{"gb18030-2000", "ibm-1392", "windows-54936"});
        this.charset("GBK", "GB18030,3", 0x3000010000L, new String[]{"GBK"});
        this.charset("windows-949", "MS949", 144036023304192L, new String[]{"MS949", "Cp1361", "ibm-1361", "ibm1361", "ms1361", "ksc5601-1992", "x-windows-949"});
        this.charset("windows-950", "MS950", 0x1B00000010000L, new String[]{"MS950", "x-windows-950"});
        this.charset("windows-874", "MS874", 37945344L, new String[]{"MS874"});
        this.charset("US-ASCII", "!ASCII", 65536L, new String[]{"iso-ir-6", "ANSI_X3.4-1986", "ISO-646.irv:1991", "ASCII", "ISO646-US", "us", "ibm-367", "Cp367", "csASCII", "646", "iso-646.irv:1983", "ANSI_X3.4-1968", "direct", "ascii7", "default"});
        this.charset("ISO-8859-1", "!ISO8859_1", 327681L, new String[]{"8859-1", "iso-8859-1:1987", "iso-ir-100", "iso8859-1", "iso8859_1", "latin1", "l1", "ibm-819", "ibm819", "Cp819", "csisolatin1"});
        this.charset("ISO-8859-2", "ISO8859_2", 327682L, new String[]{"8859-2", "iso-8859-2:1987", "iso-ir-101", "iso8859-2", "iso8859_2", "latin2", "l2", "ibm-912", "ibm912", "Cp912", "csisolatin2"});
        this.charset("ISO-8859-5", "ISO8859_5", 327696L, new String[]{"8859-5", "iso-8859-5:1988", "iso-ir-144", "iso8859-5", "iso8859_5", "cyrillic", "ibm-915", "ibm915", "Cp915", "csisolatincyrillic"});
        this.charset("ISO-8859-6", "ISO8859_6", 327712L, new String[]{"8859-6", "iso-8859-6:1987", "iso-ir-127", "iso8859-6", "iso8859_6", "ecma-114", "asmo-708", "arabic", "ibm-1089", "ibm1089", "Cp1089", "csisolatinarabic"});
        this.charset("ISO-8859-6S", "ISO8859_6S", 327712L, new String[]{"iso8859-6S", "iso8859_6S"});
        this.charset("ISO-8859-7", "ISO8859_7", 327744L, new String[]{"8859-7", "iso-8859-7:1987", "iso-ir-126", "iso8859-7", "iso8859_7", "elot-928", "ecma-118", "greek", "greek8", "ibm-813", "ibm813", "Cp813", "csisolatingreek"});
        this.charset("ISO-8859-8", "ISO8859_8", 327808L, new String[]{"8859-8", "iso-8859-8:1988", "iso-ir-138", "iso8859-8", "iso8859_8", "hebrew", "ibm-916", "ibm916", "Cp916", "csisolatinhebrew"});
        this.charset("ISO-8859-9", "ISO8859_9", 327936L, new String[]{"8859-9", "iso-ir-148", "iso8859-9", "iso8859_9", "latin5", "l5", "ibm-920", "ibm920", "Cp920", "csisolatin5"});
        this.charset("ISO-8859-15", "ISO8859_15", 475136L, new String[]{"latin0", "iso8859_15_fdis", "iso8859-15", "iso8859_15", "latin9", "l9", "ibm-923", "ibm923", "Cp923", "csisolatin9"});
        this.charset("TIS-620", "TIS620", 0x2050000L, new String[]{"tis620", "tis620.2533"});
        this.charset("ISCII91", ">ISCII91", 0x1010000L, new String[]{"iscii"});
        this.charset("IBM-437", "Cp437", 0x310000L, new String[]{"Cp437", "ibm437", "cspc8codepage437"});
        this.charset("IBM-850", "Cp850", 0x110001L, new String[]{"Cp850", "ibm850", "cspc850multilingual"});
        this.charset("IBM-852", "Cp852", 0x110002L, new String[]{"Cp852", "ibm852", "cspcp852"});
        this.charset("IBM-857", "Cp857", 0x130100L, new String[]{"Cp857", "ibm857", "csibm857"});
        this.charset("IBM-858", "Cp858", 0x130001L, new String[]{"Cp858", "ibm858"});
        this.charset("IBM-943", "Cp943", 0x800B00000000L, null);
        this.charset("IBM-943C", "Cp943C", 140784733061120L, null);
        this.charset("IBM-949", "Cp949", 144036023304192L, null);
        this.charset("IBM-949C", "Cp949C", 144036023304192L, null);
        this.charset("IBM-950", "Cp950", 0xB00000010000L, null);
        this.charset("IBM-1047", "Cp1047", 65552L, null);
        this.charset("IBM-1140", "Cp1140", 196609L, null);
        this.charset("IBM-500", "Cp500", 65537L, null);
        this.charset("IBM-1388", "Cp1388", 0x3000010000L, null);
        this.charset("IBM-1390", "Cp1390", 0x300010001L, null);
        this.charset("IBM-954", "Cp954", 0x800B00000000L, null);
        this.charset("IBM-33722", "Cp33722", 0x800900000000L, new String[]{"Cp5050", "5050"});
        this.charset("IBM-954C", "Cp954C", 140784733061120L, new String[]{"Cp954c"});
        this.charset("IBM-33722C", "Cp33722C", 140776143126528L, new String[]{"Cp33722c", "ibm-eucjp", "954"});
        this.charset("EUC-JP", "EUC_JP", 140784733061120L, new String[]{"euc_jp", "eucjp", "x-eucjp", "x-euc-jp", "euc_jp_linux", "euc-jp-linux"});
        this.charset("EUC-CN", "Cp1383", 0x801000010000L, new String[]{"euc_cn", "euccn", "ibm-euccn", "x-euc-cn"});
        this.charset("IBM-964", "Cp964", 0x900000010000L, new String[]{"ibm-euctw", "Cp964"});
        this.charset("EUC-TW", "EUC_TW", 0x1100000010000L, new String[]{"cns11643", "euc_tw", "euctw", "x-euc-tw"});
        this.charset("EUC-KR", "Cp970", 0x810000010000L, new String[]{"euc_kr", "ibm-euckr", "euckr", "ks_c_5601-1987", "ksc5601-1987", "ksc5601_1987", "ksc_5601", "5601", "Cp970", "ibm-970"});
        this.charset("hp-roman8", "Roman8", 65537L, new String[]{"roman8", "r8", "Cp1051", "ibm-1051"});
        this.charset("windows-1258", "Cp1258", 0x4430000L, new String[]{"Cp1258", "ibm-1258", "ibm-1129", "ibm-1163"});
        this.charset("ISO-8859-3", "ISO8859_3", 327684L, new String[]{"8859-3", "iso-8859-3:1988", "iso-ir-109", "iso8859-3", "iso8859_3", "latin3", "l3", "ibm-913", "Cp913", "csisolatin3"});
        this.charset("ISO-8859-4", "ISO8859_4", 327688L, new String[]{"8859-4", "iso-8859-4:1988", "iso-ir-110", "iso8859-4", "iso8859_4", "latin4", "l4", "ibm-914", "Cp914", "csisolatin4"});
        this.charset("ISO-8859-10", "ISO8859_10", 328192L, new String[]{"8859-10", "iso-ir-157", "ibm-919", "iso8859-10", "iso8859_10", "latin6", "l6", "csisolatin6", "ISO_8859-10:1992"});
        this.charset("ISO-8859-13", "ISO8859_13", 331776L, new String[]{"8859-13", "iso8859-13", "iso8859_13"});
        this.charset("ISO-8859-14", "ISO8859_14", 335872L, new String[]{"8859-14", "iso-ir-199", "iso8859-14", "iso8859_14", "latin8", "l8", "isoceltic", "ISO_8859-14:1998"});
        this.charset("ISO-8859-16", "ISO8859_16", 491520L, new String[]{"8859-16", "iso8859-16", "iso8859_16"});
        this.charset("IBM-897", "Cp897", 0x800010000L, null);
        this.charset("IBM-1006", "Cp1006", 0x8010000L, null);
        this.charset("IBM-1027", "Cp1027", 65536L, new String[]{"5123"});
        this.charset("IBM-1041", "Cp1041", 0x800010000L, null);
        this.charset("IBM-1043", "Cp1043", 65536L, null);
        this.charset("IBM-1088", "Cp1088", 65536L, null);
        this.charset("IBM-1098", "Cp1098", 0x10010000L, null);
        this.charset("IBM-1114", "Cp1114", 65536L, null);
        this.charset("IBM-1115", "Cp1115", 65536L, null);
        this.charset("KOI8-R", "KOI8_R", 0x110010L, new String[]{"koi8", "cskoi8r", "koi8_r", "ibm-878"});
        this.charset("KOI8-U", "KOI8_U", 0x1000000110010L, new String[]{"koi8_u", "ibm-1167"});
        this.charset("KOI8-RU", "KOI8_RU", 0x2000000110010L, new String[]{"koi8_ru", "ibm-1168"});
        this.charset("PTCP154", "PTCP154", 0x4000000010010L, new String[]{"IBM-1169", "PT154", "csPTCP154", "Cyrillic-Asian"});
        this.charset("IBM-720", "Cp720", 3211296L, null);
        this.charset("IBM-737", "Cp737", 3211328L, null);
        this.charset("IBM-775", "Cp775", 3211272L, null);
        this.charset("IBM-808", "Cp808", 0x330010L, null);
        this.charset("IBM-855", "Cp855", 0x110010L, null);
        this.charset("IBM-856", "Cp856", 0x110010L, null);
        this.charset("IBM-859", "Cp859", 1261568L, new String[]{"4955", "25435"});
        this.charset("IBM-860", "Cp860", 0x1000000310000L, null);
        this.charset("IBM-861", "Cp861", 562949956632576L, null);
        this.charset("IBM-862", "Cp862", 3211392L, null);
        this.charset("IBM-863", "Cp863", 0x110001L, null);
        this.charset("IBM-864", "Cp864", 0x110020L, null);
        this.charset("IBM-864S", "Cp864S", 0x110020L, null);
        this.charset("IBM-865", "Cp865", 0x4000000110000L, null);
        this.charset("IBM-866", "Cp866", 0x310010L, null);
        this.charset("IBM-867", "Cp867", 0x330080L, null);
        this.charset("IBM-868", "Cp868", 0x8100000L, null);
        this.charset("IBM-869", "Cp869", 0x110040L, null);
        this.charset("IBM-874", "Cp874", 0x2010000L, null);
        this.charset("IBM-921", "Cp921", 331776L, null);
        this.charset("IBM-922", "Cp922", 0x111000L, null);
        this.charset("IBM-1124", "Cp1124", 0x20110010L, null);
        this.charset("IBM-942", "Cp942", 0x900000000L, null);
        this.charset("IBM-932", "Cp942C", 0x900010000L, null);
        this.charset("IBM-942C", "Cp942C", 0x900010000L, null);
        this.charset("IBM-1370", "Cp1370", 0x300000020000L, null);
        this.charset("IBM-1380", "Cp1380", 0x1000020000L, null);
        this.charset("IBM-037", "Cp037", 65537L, new String[]{"ibm-37"});
        this.charset("IBM-273", "Cp273", 65537L, null);
        this.charset("IBM-277", "Cp277", 65537L, null);
        this.charset("IBM-278", "Cp278", 65537L, null);
        this.charset("IBM-280", "Cp280", 65537L, null);
        this.charset("IBM-284", "Cp284", 65537L, null);
        this.charset("IBM-285", "Cp285", 65537L, null);
        this.charset("IBM-297", "Cp297", 65537L, null);
        this.charset("IBM-420", "Cp420", 65568L, null);
        this.charset("IBM-420S", "Cp420S", 65568L, null);
        this.charset("IBM-424", "Cp424", 65568L, null);
        this.charset("IBM-838", "Cp838", 0x2000000L, null);
        this.charset("IBM-870", "Cp870", 0x2000000L, null);
        this.charset("IBM-871", "Cp871", 65537L, null);
        this.charset("IBM-875", "Cp875", 65600L, null);
        this.charset("IBM-918", "Cp918", 0x8000000L, null);
        this.charset("IBM-924", "Cp924", 212992L, null);
        this.charset("IBM-1025", "Cp1025", 65552L, null);
        this.charset("IBM-1026", "Cp1026", 65792L, null);
        this.charset("IBM-1046", "Cp1046", 65568L, null);
        this.charset("IBM-1046S", "Cp1046S", 65568L, null);
        this.charset("IBM-1097", "Cp1097", 0x10000000L, null);
        this.charset("IBM-1112", "Cp1112", 66048L, null);
        this.charset("IBM-1122", "Cp1122", 65544L, null);
        this.charset("IBM-1123", "Cp1123", 0x20010010L, null);
        this.charset("IBM-1141", "Cp1141", 196609L, null);
        this.charset("IBM-1142", "Cp1142", 196609L, null);
        this.charset("IBM-1143", "Cp1143", 196609L, null);
        this.charset("IBM-1144", "Cp1144", 196609L, null);
        this.charset("IBM-1145", "Cp1145", 196609L, null);
        this.charset("IBM-1146", "Cp1146", 196609L, null);
        this.charset("IBM-1147", "Cp1147", 196609L, null);
        this.charset("IBM-1148", "Cp1148", 196609L, null);
        this.charset("IBM-1149", "Cp1149", 196609L, null);
        this.charset("MacRoman", "MacRoman", 0x810001L, new String[]{"ibm-1275"});
        this.charset("MacCyrillic", "MacCyrillic", 0x810010L, new String[]{"ibm-1283"});
        this.charset("MacGreek", "MacGreek", 8454208L, new String[]{"ibm-1280"});
        this.charset("MacTurkish", "MacTurkish", 0x810100L, new String[]{"ibm-1281"});
        this.charset("MacArabic", "MacArabic", 8454176L, null);
        this.charset("MacCentralEurope", "MacCentralEurope", 8454146L, new String[]{"ibm-1282"});
        this.charset("MacHebrew", "MacHebrew", 0x810080L, null);
        this.charset("MacSymbol", "MacSymbol", 0x40800000L, new String[]{"ibm-1038", "Adobe-Symbol-Encoding"});
        this.charset("MacDingbat", "MacDingbat", 0x80800000L, null);
        this.charset("MacIceland", "MacIceland", 0x810001L, new String[]{"ibm-1286"});
        this.charset("MacRomania", "MacRomania", 8454146L, new String[]{"ibm-1285"});
        this.charset("MacCroatian", "MacCroatian", 8454146L, new String[]{"ibm-1284"});
        this.charset("MacUkraine", "MacUkraine", 0x20800000L, null);
        this.charset("MacThai", "MacThai", 0x2800000L, null);
        this.charset("JIS0201", "JIS0201", 0x800000000L, null);
        this.charset("JIS0208", "JIS0208", 0x100000000L, null);
        this.charset("JIS0212", "JIS0212", 0x200000000L, null);
        this.charset("IBM-290", "Cp290", 0x800010000L, new String[]{"4386", "8482", "12578"});
        this.charset("IBM-300", "Cp300", 0x100000000L, new String[]{"4396", "8492", "12588", "16684"});
        this.charset("IBM-301", "Cp301", 0x100000000L, new String[]{"4397", "8493", "24877"});
        this.charset("IBM-833", "Cp833", 65536L, new String[]{"4929", "9025", "13121"});
        this.charset("IBM-834", "Cp834", 0x10000000000L, new String[]{"4930", "9026", "13122"});
        this.charset("IBM-835", "Cp835", 0x100000000000L, new String[]{"4931", "9027"});
        this.charset("IBM-836", "Cp836", 65536L, new String[]{"4932", "9028", "13124"});
        this.charset("IBM-837", "Cp837", 0x1000000000L, new String[]{"4933", "9029"});
        this.charset("IBM-838", "Cp838", 0x2000000L, null);
        this.charset("IBM-927", "Cp927", 212992L, null);
        this.charset("IBM-930", "Cp930", 0x100010000L, new String[]{"Cp5026", "5026"});
        this.charset("IBM-933", "Cp933", 0x10000010000L, null);
        this.charset("IBM-935", "Cp935", 0x1000010000L, null);
        this.charset("IBM-937", "Cp937", 0x100000010000L, null);
        this.charset("IBM-939", "Cp939", 0x300010000L, new String[]{"Cp5035", "5035"});
        this.charset("IBM-947", "Cp947", 0x100000000000L, null);
        this.charset("IBM-948", "Cp948", 0x100000000000L, null);
        this.charset("IBM-951", "Cp951", 0x300010000L, null);
        this.charset("IBM-971", "Cp971", 0x300010000L, null);
        this.charset("IBM-1046", "Cp1046", 65568L, null);
        this.charset("IBM-1351", "Cp1351", 0x300000000L, null);
        this.charset("IBM-1362", "Cp1362", 0x300000000L, new String[]{"5458"});
        this.charset("IBM-1363", "Cp1363", 0x300000000L, null);
        this.charset("IBM-1363C", "Cp1363C", 0x300000000L, new String[]{"5459", "9555"});
        this.charset("IBM-1364", "Cp1364", 0x30000000000L, null);
        this.charset("IBM-1371", "Cp1371", 0x300000020000L, null);
        this.charset("IBM-1381", "Cp1381", 0x1000000000L, null);
        this.charset("IBM-1382", "Cp1382", 0x1000000000L, null);
        this.charset("IBM-1383", "Cp1383", 0x1000000000L, null);
        this.charset("IBM-1385", "GB18030,2", 0x1000000000L, null);
        this.charset("IBM-1386", "GB18030,3", 0x1000000000L, null);
        this.charset("IBM-1399", "Cp1399", 0xB00000000L, null);
        this.charset("GB2312", "GB2312", 0x1000010000L, new String[]{"gb2312-80", "gb2312-1980"});
        this.charset("KSC5601", "KSC5601", 0x10000010000L, null);
        this.charset("Johab", "Johab", 0x30000010000L, new String[]{"x-johab"});
        this.charset("Big5", "Big5", 0x300000010000L, new String[]{"big5", "Big5-HKSCS", "big5-0"});
        this.charset("ISO-2022-JP", "!ISO2022,JP", 0xB00010000L, new String[]{"iso2022-jp", "iso2022jp", "jis", "jis-encoding", "csjisencoding", "iso-2022-jp2", "csiso2022jp2"});
        this.charset("ISO-2022-KR", "!ISO2022,KR", 0x30000010000L, new String[]{"iso2022-kr", "iso2022kr", "csiso2022kr"});
        this.charset("ISO-2022-CN", "!ISO2022,CN", 0x100000010000L, new String[]{"iso2022-cn", "iso2022cn", "iso2022cn-cns", "iso-2022-cn-cns", "iso2022-cn-cns", "iso2022cn-cns"});
        this.charset("ISO-2022-CN-GB", "!ISO2022,CN_GB", 0x1000010000L, new String[]{"iso2022-cn-gb", "iso2022cn-gb"});
        this.charset("COMPOUND_TEXT", ">CompoundText", 17708150292991L, new String[]{"x-compound-text", "x11-compound-text"});
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.nio.cs.map");
        String string = (String)AccessController.doPrivileged(getPropertyAction);
        sjisIsMS932 = string != null ? (string = string.toLowerCase(Locale.US)).indexOf("windows") >= 0 : false;
    }
}

