/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class UTF32Decoder
extends IBMCharsetDecoder {
    protected static final int BYTE_ORDER_MARK = 65279;
    protected static final int REVERSED_MARK = -131072;
    protected static final int NONE = 0;
    protected static final int BIG = 2;
    protected static final int LITTLE = 1;
    private final int expectedByteOrder;
    private int currentByteOrder;

    public UTF32Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.expectedByteOrder = this.currentByteOrder = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.remaining() >= 4) {
                int n2;
                int n3 = byteBuffer.get() & 0xFF;
                int n4 = byteBuffer.get() & 0xFF;
                int n5 = byteBuffer.get() & 0xFF;
                int n6 = byteBuffer.get() & 0xFF;
                if (this.currentByteOrder == 0) {
                    n2 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
                    if (n2 == 65279) {
                        this.currentByteOrder = 2;
                        n += 2;
                        continue;
                    }
                    if (n2 == -131072) {
                        this.currentByteOrder = 1;
                        n += 2;
                        continue;
                    }
                    this.currentByteOrder = 2;
                }
                if ((n2 = this.currentByteOrder == 2 ? n3 << 24 | n4 << 16 | n5 << 8 | n6 : n6 << 24 | n5 << 16 | n4 << 8 | n3) == -131072) {
                    CoderResult coderResult = CoderResult.malformedForLength(4);
                    return coderResult;
                }
                if (n2 < 65536) {
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)n2);
                } else {
                    if (charBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)((n2 -= 65536) >> 10 | 0xD800));
                    charBuffer.put((char)(n2 & 0x3FF | 0xDC00));
                }
                n += 4;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }
}

