/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue = new ReferenceQueue();
    private static Finalizer unfinalized = null;
    private static Object lock = new Object();
    private static Finalizer processing = null;
    private static Finalizer unfinalizedApp = null;
    private Finalizer nextf = null;
    private Finalizer prevf = null;

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    private static native void initForReset();

    private boolean hasBeenFinalized() {
        return this.nextf == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.nextf = unfinalized;
                Finalizer.unfinalized.prevf = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.nextf != null ? this.nextf : this.prevf;
            }
            if (this.nextf != null) {
                this.nextf.prevf = this.prevf;
            }
            if (this.prevf != null) {
                this.prevf.nextf = this.nextf;
            }
            this.nextf = this;
            this.prevf = this;
        }
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static void register(Object object) {
        new Finalizer(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer() {
        Object object = this;
        synchronized (object) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            object = this.get();
            if (object != null) {
                Finalizer.invokeFinalizeMethod(object);
                object = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    static void runAppFinalizer(Finalizer finalizer) {
        finalizer.runFinalizerNoRemove();
    }

    static void runAppFinalizers() {
        Finalizer finalizer = unfinalizedApp;
        while (finalizer != null) {
            Finalizer.runAppFinalizer(finalizer);
            finalizer = finalizer.nextf;
        }
        unfinalizedApp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizerNoRemove() {
        Object object = this;
        synchronized (object) {
            if (this.hasBeenFinalized()) {
                return;
            }
        }
        try {
            object = this.get();
            if (object != null) {
                Finalizer.invokeFinalizeMethod(object);
                object = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Object object = threadGroup;
                while (object != null) {
                    threadGroup = object;
                    object = threadGroup.getParent();
                }
                object = new Thread(threadGroup, runnable, "Secondary finalizer");
                ((Thread)object).start();
                try {
                    ((Thread)object).join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                Finalizer finalizer;
                while ((finalizer = (Finalizer)queue.poll()) != null) {
                    finalizer.runFinalizer();
                }
            }
        });
    }

    static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Finalizer finalizer;
                    Object object = lock;
                    synchronized (object) {
                        finalizer = unfinalized;
                        if (finalizer == null) {
                            break;
                        }
                        unfinalized = finalizer.nextf;
                    }
                    finalizer.runFinalizer();
                }
            }
        });
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new FinalizerThread(threadGroup);
        ((Thread)object).setPriority(8);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class FinalizerThread
    extends Thread {
        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        processing = (Finalizer)queue.poll();
                        if (processing == null) {
                            processing = (Finalizer)queue.remove();
                        }
                        processing.runFinalizer();
                    }
                }
                catch (InterruptedException interruptedException) {}
                finally {
                    continue;
                }
                break;
            }
        }
    }
}

