/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastRef2;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetPropertyAction;

public final class RemoteProxy
extends RemoteStub {
    static int logLevel = LogStream.parseLevel(RemoteProxy.getLogLevel());
    private static Class[] stubConsParamTypes = new Class[]{RemoteRef.class};
    static /* synthetic */ Class class$java$rmi$Remote;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.server.logLevel"));
    }

    private RemoteProxy() {
    }

    public static RemoteStub getStub(Remote remote, RemoteRef remoteRef) throws StubNotFoundException {
        Class clazz = null;
        try {
            clazz = RemoteProxy.getRemoteClass(remote.getClass());
            return RemoteProxy.getStub(clazz.getName(), clazz, remoteRef);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("Object does not implement an interface that extends java.rmi.Remote: " + remote.getClass().getName());
        }
    }

    public static RemoteStub getStub(String string, RemoteRef remoteRef) throws StubNotFoundException {
        return RemoteProxy.getStub(string, null, remoteRef);
    }

    public static RemoteStub getStub(String string, Class clazz, RemoteRef remoteRef) throws StubNotFoundException {
        String string2 = string + "_Stub";
        RemoteStub remoteStub = null;
        try {
            Class clazz2 = RemoteProxy.loadClassFromClass(string2, clazz);
            Constructor constructor = clazz2.getConstructor(stubConsParamTypes);
            remoteStub = (RemoteStub)constructor.newInstance(new Object[]{remoteRef});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("Stub class not found: " + string2, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new StubNotFoundException("Stub class missing constructor: " + string2, noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new StubNotFoundException("Can't create instance of stub class: " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new StubNotFoundException("Stub class constructor not public: " + string2, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new StubNotFoundException("Exception creating instance of stub class: " + string2, invocationTargetException);
        }
        catch (ClassCastException classCastException) {
            throw new StubNotFoundException("Stub class not instance of RemoteStub: " + string2, classCastException);
        }
        return remoteStub;
    }

    public static RemoteStub getStub(String string, int n, String string2, int n2) throws RemoteException {
        ObjID objID = new ObjID(n);
        TCPEndpoint tCPEndpoint = new TCPEndpoint(string2, n2);
        LiveRef liveRef = new LiveRef(objID, tCPEndpoint, false);
        return RemoteProxy.getStub(string, (RemoteRef)new UnicastRef(liveRef));
    }

    public static RemoteStub getStub(String string, int n, String string2, int n2, RMIClientSocketFactory rMIClientSocketFactory) throws RemoteException {
        ObjID objID = new ObjID(n);
        TCPEndpoint tCPEndpoint = new TCPEndpoint(string2, n2, rMIClientSocketFactory, null);
        LiveRef liveRef = new LiveRef(objID, tCPEndpoint, false);
        return RemoteProxy.getStub(string, (RemoteRef)new UnicastRef2(liveRef));
    }

    public static Skeleton getSkeleton(Remote remote) throws SkeletonNotFoundException {
        Class clazz;
        try {
            clazz = RemoteProxy.getRemoteClass(remote.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SkeletonNotFoundException("Object does not implement an interface that extends java.rmi.Remote: " + remote.getClass().getName());
        }
        String string = clazz.getName() + "_Skel";
        try {
            Class clazz2 = RemoteProxy.loadClassFromClass(string, clazz);
            return (Skeleton)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SkeletonNotFoundException("Skeleton class not found: " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SkeletonNotFoundException("Can't create skeleton: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SkeletonNotFoundException("No public constructor: " + string, illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new SkeletonNotFoundException("Skeleton not of correct class: " + string, classCastException);
        }
    }

    private static Class loadClassFromClass(String string, Class clazz) throws ClassNotFoundException {
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader != null) {
            return classLoader.loadClass(string);
        }
        return Class.forName(string);
    }

    static Class getRemoteClass(Class clazz) throws ClassNotFoundException {
        while (clazz != null) {
            Class[] classArray = clazz.getInterfaces();
            for (int i = classArray.length - 1; i >= 0; --i) {
                if (!(class$java$rmi$Remote == null ? RemoteProxy.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[i])) continue;
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        throw new ClassNotFoundException("class does not implement java.rmi.Remote");
    }
}

