/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Gregorian;
import sun.util.calendar.ZoneInfoFile;

public class ZoneInfo
extends TimeZone {
    private static final long OFFSET_MASK = 15L;
    private static final long DST_MASK = 240L;
    private static final int DST_NSHIFT = 4;
    private static final long ABBR_MASK = 3840L;
    private static final int TRANSITION_NSHIFT = 12;
    private int rawOffset;
    private int rawOffsetDiff = 0;
    private int checksum;
    private int dstSavings;
    private long[] transitions;
    private int[] offsets;
    private int[] simpleTimeZoneParams;
    private boolean willGMTOffsetChange = false;
    private static final long serialVersionUID = 2653134537216586139L;
    private transient SimpleTimeZone lastRule;
    private static transient SoftReference aliasTable;

    public ZoneInfo() {
    }

    public ZoneInfo(String string, int n) {
        this(string, n, 0, 0, null, null, null, false);
    }

    ZoneInfo(String string, int n, int n2, int n3, long[] lArray, int[] nArray, int[] nArray2, boolean bl) {
        this.setID(string);
        this.rawOffset = n;
        this.dstSavings = n2;
        this.checksum = n3;
        this.transitions = lArray;
        this.offsets = nArray;
        this.simpleTimeZoneParams = nArray2;
        this.willGMTOffsetChange = bl;
    }

    public int getOffset(long l) {
        return this.getOffsets(l, null, false);
    }

    public int getOffsets(long l, int[] nArray) {
        return this.getOffsets(l, nArray, false);
    }

    public int getOffsetsByWall(long l, int[] nArray) {
        return this.getOffsets(l, nArray, true);
    }

    private int getOffsets(long l, int[] nArray, boolean bl) {
        if (this.transitions == null) {
            int n = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n;
                nArray[1] = 0;
            }
            return n;
        }
        int n = this.getTransitionIndex(l -= (long)this.rawOffsetDiff, bl);
        if (n < 0) {
            int n2 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n2;
                nArray[1] = 0;
            }
            return n2;
        }
        if (n < this.transitions.length) {
            long l2 = this.transitions[n];
            int n3 = this.offsets[(int)(l2 & 0xFL)] + this.rawOffsetDiff;
            if (nArray != null) {
                int n4 = (int)(l2 >>> 4 & 0xFL);
                int n5 = n4 == 0 ? 0 : this.offsets[n4];
                nArray[0] = n3 - n5;
                nArray[1] = n5;
            }
            return n3;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            int n6;
            int n7 = simpleTimeZone.getRawOffset();
            long l3 = l;
            if (bl) {
                l3 -= (long)this.rawOffset;
            }
            int n8 = n6 = simpleTimeZone.inDaylightTime(new Date(l3)) ? simpleTimeZone.getDSTSavings() : 0;
            if (nArray != null) {
                nArray[0] = n7;
                nArray[1] = n6;
            }
            return n7 + n6;
        }
        int n9 = this.getLastRawOffset();
        if (nArray != null) {
            nArray[0] = n9;
            nArray[1] = 0;
        }
        return n9;
    }

    private final int getTransitionIndex(long l, boolean bl) {
        int n = 0;
        int n2 = this.transitions.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            long l2 = this.transitions[n3];
            long l3 = l2 >> 12;
            if (bl) {
                l3 += (long)this.offsets[(int)(l2 & 0xFL)];
            }
            if (l3 < l) {
                n = n3 + 1;
                continue;
            }
            if (l3 > l) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        if (n >= this.transitions.length) {
            return n;
        }
        return n - 1;
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 < 0 || n6 >= 86400000) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n2 = 1 - n2;
        } else if (n != 1) {
            throw new IllegalArgumentException();
        }
        CalendarDate calendarDate = new CalendarDate(n2, n3, n4);
        if (!Gregorian.validate(calendarDate)) {
            throw new IllegalArgumentException();
        }
        if (n5 < 1 || n5 > 7) {
            throw new IllegalArgumentException();
        }
        if (this.transitions == null) {
            return this.getLastRawOffset();
        }
        long l = Gregorian.dateToMillis(calendarDate) + (long)n6;
        return this.getOffsets(l -= (long)this.rawOffset, null, false);
    }

    public synchronized void setRawOffset(int n) {
        this.rawOffsetDiff = n - this.rawOffset;
        if (this.lastRule != null) {
            this.lastRule.setRawOffset(n);
        }
    }

    public int getRawOffset() {
        if (!this.willGMTOffsetChange) {
            return this.rawOffset + this.rawOffsetDiff;
        }
        int[] nArray = new int[2];
        this.getOffsets(System.currentTimeMillis(), nArray, false);
        return nArray[0];
    }

    private int getLastRawOffset() {
        return this.rawOffset + this.rawOffsetDiff;
    }

    public boolean useDaylightTime() {
        return this.simpleTimeZoneParams != null;
    }

    public boolean inDaylightTime(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        if (this.transitions == null) {
            return false;
        }
        long l = date.getTime() - (long)this.rawOffsetDiff;
        int n = this.getTransitionIndex(l, false);
        if (n < 0) {
            return false;
        }
        if (n < this.transitions.length) {
            return (this.transitions[n] & 0xF0L) != 0L;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            return simpleTimeZone.inDaylightTime(date);
        }
        return false;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public String toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\"" + ",offset=" + this.getLastRawOffset() + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylightTime() + ",transitions=" + (this.transitions != null ? this.transitions.length : 0) + ",lastRule=" + this.getLastRuleInstance() + "]";
    }

    public static String[] getAvailableIDs() {
        String[] stringArray = ZoneInfoFile.getZoneIDs();
        String[] stringArray2 = ZoneInfoFile.getExcludedZones();
        int n = stringArray.length;
        if (stringArray2 != null) {
            int n2;
            int n3 = stringArray2.length;
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray3[n2] = stringArray[n2];
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                stringArray3[n + n2] = stringArray2[n2];
            }
            return stringArray3;
        }
        return stringArray;
    }

    public static String[] getAvailableIDs(int n) {
        String[] stringArray;
        int n2;
        ArrayList arrayList = new ArrayList();
        String[] stringArray2 = ZoneInfoFile.getZoneIDs();
        int[] nArray = ZoneInfoFile.getRawOffsets();
        block0: for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            byte[] byArray = ZoneInfoFile.getRawOffsetIndices();
            for (n2 = 0; n2 < byArray.length; ++n2) {
                if (byArray[n2] != i) continue;
                arrayList.add(stringArray2[n2++]);
                while (n2 < byArray.length && byArray[n2] == i) {
                    arrayList.add(stringArray2[n2++]);
                }
                break block0;
            }
        }
        if ((stringArray = ZoneInfoFile.getExcludedZones()) != null) {
            int n3 = stringArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                TimeZone timeZone = ZoneInfo.getTimeZone(stringArray[n2]);
                if (timeZone == null || timeZone.getRawOffset() != n) continue;
                arrayList.add(stringArray[n2]);
            }
        }
        Object[] objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public static TimeZone getTimeZone(String string) {
        ZoneInfo zoneInfo = null;
        zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo == null) {
            try {
                HashMap hashMap = ZoneInfo.getAliasTable();
                String string2 = string;
                while ((string2 = (String)hashMap.get(string2)) != null) {
                    zoneInfo = ZoneInfoFile.getZoneInfo(string2);
                    if (zoneInfo == null) continue;
                    zoneInfo.setID(string);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zoneInfo;
    }

    private synchronized SimpleTimeZone getLastRule() {
        if (this.lastRule == null) {
            this.lastRule = this.getLastRuleInstance();
        }
        return this.lastRule;
    }

    public SimpleTimeZone getLastRuleInstance() {
        if (this.simpleTimeZoneParams == null) {
            return null;
        }
        if (this.simpleTimeZoneParams.length == 10) {
            return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.simpleTimeZoneParams[8], this.simpleTimeZoneParams[9], this.dstSavings);
        }
        return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.dstSavings);
    }

    public int hashCode() {
        return this.getLastRawOffset() ^ this.checksum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)object;
        return this.getID().equals(zoneInfo.getID()) && this.getLastRawOffset() == zoneInfo.getLastRawOffset() && this.checksum == zoneInfo.checksum;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone == null) {
            return false;
        }
        if (!(timeZone instanceof ZoneInfo)) {
            if (this.getRawOffset() != timeZone.getRawOffset()) {
                return false;
            }
            return this.transitions == null && !this.useDaylightTime() && !timeZone.useDaylightTime();
        }
        if (this.getLastRawOffset() != ((ZoneInfo)timeZone).getLastRawOffset()) {
            return false;
        }
        return this.checksum == ((ZoneInfo)timeZone).checksum;
    }

    private static synchronized HashMap getAliasTable() {
        HashMap hashMap = null;
        if (aliasTable != null && (hashMap = (HashMap)aliasTable.get()) != null) {
            return hashMap;
        }
        hashMap = ZoneInfoFile.getZoneAliases();
        if (hashMap != null) {
            aliasTable = new SoftReference(hashMap);
        }
        return hashMap;
    }
}

