/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

public final class LdapName
implements Name {
    private transient String unparsed;
    private transient Vector rdns;
    private transient boolean valuesCaseSensitive = false;
    static final long serialVersionUID = -1595520034788997356L;

    public LdapName(String string) throws InvalidNameException {
        this.unparsed = string;
        this.parse();
    }

    private LdapName(String string, Vector vector) {
        this.unparsed = string;
        this.rdns = (Vector)vector.clone();
    }

    private LdapName(String string, Vector vector, int n, int n2) {
        this.unparsed = string;
        this.rdns = new Vector();
        for (int i = n; i < n2; ++i) {
            this.rdns.addElement(vector.elementAt(i));
        }
    }

    public Object clone() {
        return new LdapName(this.unparsed, this.rdns);
    }

    public String toString() {
        if (this.unparsed != null) {
            return this.unparsed;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.rdns.size() - 1; i >= 0; --i) {
            if (i < this.rdns.size() - 1) {
                stringBuffer.append(',');
            }
            Rdn rdn = (Rdn)this.rdns.elementAt(i);
            stringBuffer.append(rdn);
        }
        this.unparsed = new String(stringBuffer);
        return this.unparsed;
    }

    public boolean equals(Object object) {
        return object instanceof LdapName && this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        LdapName ldapName = (LdapName)object;
        if (object == this || this.unparsed != null && this.unparsed.equals(ldapName.unparsed)) {
            return 0;
        }
        int n = Math.min(this.rdns.size(), ldapName.rdns.size());
        for (int i = 0; i < n; ++i) {
            Rdn rdn;
            Rdn rdn2 = (Rdn)this.rdns.elementAt(i);
            int n2 = rdn2.compareTo(rdn = (Rdn)ldapName.rdns.elementAt(i));
            if (n2 == 0) continue;
            return n2;
        }
        return this.rdns.size() - ldapName.rdns.size();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.rdns.size(); ++i) {
            Rdn rdn = (Rdn)this.rdns.elementAt(i);
            n += rdn.hashCode();
        }
        return n;
    }

    public int size() {
        return this.rdns.size();
    }

    public boolean isEmpty() {
        return this.rdns.isEmpty();
    }

    public Enumeration getAll() {
        final Enumeration enumeration = this.rdns.elements();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                return enumeration.nextElement().toString();
            }
        };
    }

    public String get(int n) {
        return this.rdns.elementAt(n).toString();
    }

    public Name getPrefix(int n) {
        return new LdapName(null, this.rdns, 0, n);
    }

    public Name getSuffix(int n) {
        return new LdapName(null, this.rdns, n, this.rdns.size());
    }

    public boolean startsWith(Name name) {
        int n;
        int n2 = this.rdns.size();
        return n2 >= (n = name.size()) && this.matches(0, n, name);
    }

    public boolean endsWith(Name name) {
        int n;
        int n2 = this.rdns.size();
        return n2 >= (n = name.size()) && this.matches(n2 - n, n2, name);
    }

    public void setValuesCaseSensitive(boolean bl) {
        this.toString();
        this.rdns = null;
        try {
            this.parse();
        }
        catch (InvalidNameException invalidNameException) {
            throw new IllegalStateException("Cannot parse name: " + this.unparsed);
        }
        this.valuesCaseSensitive = bl;
    }

    private boolean matches(int n, int n2, Name name) {
        for (int i = n; i < n2; ++i) {
            Rdn rdn;
            Object object;
            if (name instanceof LdapName) {
                object = (LdapName)name;
                rdn = (Rdn)((LdapName)object).rdns.elementAt(i - n);
            } else {
                object = name.get(i - n);
                try {
                    rdn = new DnParser((String)object, this.valuesCaseSensitive).getRdn();
                }
                catch (InvalidNameException invalidNameException) {
                    return false;
                }
            }
            if (rdn.equals(this.rdns.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.size(), name);
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof LdapName) {
            LdapName ldapName = (LdapName)name;
            for (int i = 0; i < ldapName.rdns.size(); ++i) {
                this.rdns.insertElementAt(ldapName.rdns.elementAt(i), n++);
            }
        } else {
            Enumeration<String> enumeration = name.getAll();
            while (enumeration.hasMoreElements()) {
                DnParser dnParser = new DnParser(enumeration.nextElement(), this.valuesCaseSensitive);
                this.rdns.insertElementAt(dnParser.getRdn(), n++);
            }
        }
        this.unparsed = null;
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        return this.add(this.size(), string);
    }

    public Name add(int n, String string) throws InvalidNameException {
        Rdn rdn = new DnParser(string, this.valuesCaseSensitive).getRdn();
        this.rdns.insertElementAt(rdn, n);
        this.unparsed = null;
        return this;
    }

    public Object remove(int n) throws InvalidNameException {
        String string = this.get(n);
        this.rdns.removeElementAt(n);
        this.unparsed = null;
        return string;
    }

    private void parse() throws InvalidNameException {
        this.rdns = new DnParser(this.unparsed, this.valuesCaseSensitive).getDn();
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\r';
    }

    public static String escapeAttributeValue(Object object) {
        return TypeAndValue.escapeValue(object);
    }

    public static Object unescapeAttributeValue(String string) {
        return TypeAndValue.unescapeValue(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.toString());
        objectOutputStream.writeBoolean(this.valuesCaseSensitive);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.unparsed = (String)objectInputStream.readObject();
        this.valuesCaseSensitive = objectInputStream.readBoolean();
        try {
            this.parse();
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + this.unparsed);
        }
    }

    static class TypeAndValue {
        private final String type;
        private final String value;
        private final boolean binary;
        private final boolean valueCaseSensitive;
        private String comparable = null;

        TypeAndValue(String string, String string2, boolean bl) {
            this.type = string;
            this.value = string2;
            this.binary = string2.startsWith("#");
            this.valueCaseSensitive = bl;
        }

        public String toString() {
            return this.type + "=" + this.value;
        }

        public int compareTo(Object object) {
            TypeAndValue typeAndValue = (TypeAndValue)object;
            int n = this.type.toUpperCase().compareTo(typeAndValue.type.toUpperCase());
            if (n != 0) {
                return n;
            }
            if (this.value.equals(typeAndValue.value)) {
                return 0;
            }
            return this.getValueComparable().compareTo(typeAndValue.getValueComparable());
        }

        public boolean equals(Object object) {
            if (!(object instanceof TypeAndValue)) {
                return false;
            }
            TypeAndValue typeAndValue = (TypeAndValue)object;
            return this.type.equalsIgnoreCase(typeAndValue.type) && (this.value.equals(typeAndValue.value) || this.getValueComparable().equals(typeAndValue.getValueComparable()));
        }

        public int hashCode() {
            return this.type.toUpperCase().hashCode() + this.getValueComparable().hashCode();
        }

        String getType() {
            return this.type;
        }

        Object getUnescapedValue() {
            return TypeAndValue.unescapeValue(this.value);
        }

        private String getValueComparable() {
            if (this.comparable != null) {
                return this.comparable;
            }
            if (this.binary) {
                this.comparable = this.value.toUpperCase();
            } else {
                this.comparable = (String)TypeAndValue.unescapeValue(this.value);
                if (!this.valueCaseSensitive) {
                    this.comparable = this.comparable.toUpperCase();
                }
            }
            return this.comparable;
        }

        static String escapeValue(Object object) {
            return object instanceof byte[] ? TypeAndValue.escapeBinaryValue((byte[])object) : TypeAndValue.escapeStringValue((String)object);
        }

        private static String escapeStringValue(String string) {
            int n;
            int n2;
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(2 * string.length());
            for (n2 = 0; n2 < cArray.length && LdapName.isWhitespace(cArray[n2]); ++n2) {
            }
            for (n = cArray.length - 1; n >= 0 && LdapName.isWhitespace(cArray[n]); --n) {
            }
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (i < n2 || i > n || ",=+<>#;\"\\".indexOf(c) >= 0) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            return new String(stringBuffer);
        }

        private static String escapeBinaryValue(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(1 + 2 * byArray.length);
            stringBuffer.append("#");
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
            }
            return new String(stringBuffer).toUpperCase();
        }

        static Object unescapeValue(String string) {
            int n;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            for (n = 0; n < n2 && LdapName.isWhitespace(cArray[n]); ++n) {
            }
            while (n < n2 && LdapName.isWhitespace(cArray[n2 - 1])) {
                --n2;
            }
            if (n >= n2) {
                return "";
            }
            if (cArray[n] == '#') {
                return TypeAndValue.decodeHexPairs(cArray, ++n, n2);
            }
            if (cArray[n] == '\"' && cArray[n2 - 1] == '\"') {
                ++n;
                --n2;
            }
            StringBuffer stringBuffer = new StringBuffer(n2 - n);
            for (int i = n; i < n2; ++i) {
                if (cArray[i] == '\\' && i + 1 < n2) {
                    if (!Character.isLetterOrDigit(cArray[i + 1])) {
                        stringBuffer.append(cArray[++i]);
                        continue;
                    }
                    byte[] byArray = null;
                    byArray = TypeAndValue.getUtf8Octets(cArray, i, n2);
                    if (byArray == null) continue;
                    try {
                        stringBuffer.append(new String(byArray, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    i += byArray.length * 3 - 1;
                    continue;
                }
                stringBuffer.append(cArray[i]);
            }
            return new String(stringBuffer);
        }

        private static byte[] decodeHexPairs(char[] cArray, int n, int n2) {
            byte[] byArray = new byte[(n2 - n) / 2];
            int n3 = 0;
            while (n + 1 < n2) {
                int n4 = Character.digit(cArray[n], 16);
                int n5 = Character.digit(cArray[n + 1], 16);
                if (n4 < 0 || n5 < 0) break;
                byArray[n3] = (byte)((n4 << 4) + n5);
                n += 2;
                ++n3;
            }
            if (n != n2) {
                throw new IllegalArgumentException("Illegal attribute value: #" + new String(cArray));
            }
            return byArray;
        }

        private static byte[] getUtf8Octets(char[] cArray, int n, int n2) {
            byte[] byArray = new byte[(n2 - n) / 3];
            int n3 = 0;
            while (n + 2 < n2 && cArray[n++] == '\\') {
                int n4 = Character.digit(cArray[n++], 16);
                int n5 = Character.digit(cArray[n++], 16);
                if (n4 < 0 || n5 < 0) break;
                byArray[n3++] = (byte)((n4 << 4) + n5);
            }
            if (n3 != 0) {
                if (n3 == byArray.length) {
                    return byArray;
                }
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return byArray2;
            }
            return null;
        }
    }

    static class Rdn {
        private final Vector tvs = new Vector();

        Rdn() {
        }

        void add(TypeAndValue typeAndValue) {
            int n;
            for (n = 0; n < this.tvs.size(); ++n) {
                int n2 = typeAndValue.compareTo(this.tvs.elementAt(n));
                if (n2 == 0) {
                    return;
                }
                if (n2 < 0) break;
            }
            this.tvs.insertElementAt(typeAndValue, n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.tvs.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(this.tvs.elementAt(i));
            }
            return new String(stringBuffer);
        }

        public boolean equals(Object object) {
            return object instanceof Rdn && this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            Rdn rdn = (Rdn)object;
            int n = Math.min(this.tvs.size(), rdn.tvs.size());
            for (int i = 0; i < n; ++i) {
                TypeAndValue typeAndValue = (TypeAndValue)this.tvs.elementAt(i);
                int n2 = typeAndValue.compareTo(rdn.tvs.elementAt(i));
                if (n2 == 0) continue;
                return n2;
            }
            return this.tvs.size() - rdn.tvs.size();
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.tvs.size(); ++i) {
                n += this.tvs.elementAt(i).hashCode();
            }
            return n;
        }

        Attributes toAttributes() {
            BasicAttributes basicAttributes = new BasicAttributes(true);
            for (int i = 0; i < this.tvs.size(); ++i) {
                TypeAndValue typeAndValue = (TypeAndValue)this.tvs.elementAt(i);
                Attribute attribute = basicAttributes.get(typeAndValue.getType());
                if (attribute == null) {
                    basicAttributes.put(typeAndValue.getType(), typeAndValue.getUnescapedValue());
                    continue;
                }
                attribute.add(typeAndValue.getUnescapedValue());
            }
            return basicAttributes;
        }
    }

    static class DnParser {
        private final String name;
        private final char[] chars;
        private final int len;
        private int cur = 0;
        private boolean valuesCaseSensitive;

        DnParser(String string, boolean bl) throws InvalidNameException {
            this.name = string;
            this.len = string.length();
            this.chars = string.toCharArray();
            this.valuesCaseSensitive = bl;
        }

        Vector getDn() throws InvalidNameException {
            this.cur = 0;
            Vector<Rdn> vector = new Vector<Rdn>(this.len / 3 + 10);
            if (this.len == 0) {
                return vector;
            }
            vector.addElement(this.parseRdn());
            while (this.cur < this.len) {
                if (this.chars[this.cur] == ',' || this.chars[this.cur] == ';') {
                    ++this.cur;
                    vector.insertElementAt(this.parseRdn(), 0);
                    continue;
                }
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return vector;
        }

        Rdn getRdn() throws InvalidNameException {
            Rdn rdn = this.parseRdn();
            if (this.cur < this.len) {
                throw new InvalidNameException("Invalid RDN: " + this.name);
            }
            return rdn;
        }

        private Rdn parseRdn() throws InvalidNameException {
            Rdn rdn = new Rdn();
            while (this.cur < this.len) {
                this.consumeWhitespace();
                String string = this.parseAttrType();
                this.consumeWhitespace();
                if (this.cur >= this.len || this.chars[this.cur] != '=') {
                    throw new InvalidNameException("Invalid name: " + this.name);
                }
                ++this.cur;
                this.consumeWhitespace();
                String string2 = this.parseAttrValue();
                this.consumeWhitespace();
                rdn.add(new TypeAndValue(string, string2, this.valuesCaseSensitive));
                if (this.cur >= this.len || this.chars[this.cur] != '+') break;
                ++this.cur;
            }
            return rdn;
        }

        private String parseAttrType() throws InvalidNameException {
            char c;
            int n = this.cur;
            while (this.cur < this.len && (Character.isLetterOrDigit(c = this.chars[this.cur]) || c == '.' || c == '-' || c == ' ')) {
                ++this.cur;
            }
            while (this.cur > n && this.chars[this.cur - 1] == ' ') {
                --this.cur;
            }
            if (n == this.cur) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return new String(this.chars, n, this.cur - n);
        }

        private String parseAttrValue() throws InvalidNameException {
            if (this.cur < this.len && this.chars[this.cur] == '#') {
                return this.parseBinaryAttrValue();
            }
            if (this.cur < this.len && this.chars[this.cur] == '\"') {
                return this.parseQuotedAttrValue();
            }
            return this.parseStringAttrValue();
        }

        private String parseBinaryAttrValue() throws InvalidNameException {
            int n = this.cur++;
            while (this.cur < this.len && Character.isLetterOrDigit(this.chars[this.cur])) {
                ++this.cur;
            }
            return new String(this.chars, n, this.cur - n);
        }

        private String parseQuotedAttrValue() throws InvalidNameException {
            int n = this.cur++;
            while (this.cur < this.len && this.chars[this.cur] != '\"') {
                if (this.chars[this.cur] == '\\') {
                    ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur >= this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            ++this.cur;
            return new String(this.chars, n, this.cur - n);
        }

        private String parseStringAttrValue() throws InvalidNameException {
            int n;
            int n2 = this.cur;
            int n3 = -1;
            while (this.cur < this.len && !this.atTerminator()) {
                if (this.chars[this.cur] == '\\') {
                    n3 = ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur > this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            for (n = this.cur; n > n2 && LdapName.isWhitespace(this.chars[n - 1]) && n3 != n - 1; --n) {
            }
            return new String(this.chars, n2, n - n2);
        }

        private void consumeWhitespace() {
            while (this.cur < this.len && LdapName.isWhitespace(this.chars[this.cur])) {
                ++this.cur;
            }
        }

        private boolean atTerminator() {
            return this.cur < this.len && (this.chars[this.cur] == ',' || this.chars[this.cur] == ';' || this.chars[this.cur] == '+');
        }
    }
}

