/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import com.ibm.jvm.ExtendedSystem;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class DriverManager {
    static final SQLPermission SET_LOG_PERMISSION = new SQLPermission("setLog");
    private static Vector writeDrivers = new Vector();
    private static Vector readDrivers = new Vector();
    private static int loginTimeout = 0;
    private static PrintWriter logWriter = null;
    private static PrintStream logStream = null;
    private static boolean initialized = false;
    private static Object logSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintWriter getLogWriter() {
        Object object = logSync;
        synchronized (object) {
            return logWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogWriter(PrintWriter printWriter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        Object object = logSync;
        synchronized (object) {
            logStream = null;
            logWriter = printWriter;
        }
        ExtendedSystem.setJVMUnresettableConditionally((int)131073, (String)new String("Modified logWriter in DriverManager.setLogWriter()"));
    }

    public static Connection getConnection(String string, Properties properties) throws SQLException {
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static Connection getConnection(String string) throws SQLException {
        Properties properties = new Properties();
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(string, properties, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Driver getDriver(String string) throws SQLException {
        Vector vector = null;
        DriverManager.println("DriverManager.getDriver(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        Object object = DriverManager.class;
        synchronized (object) {
            vector = readDrivers;
        }
        object = DriverManager.getCallerClassLoader();
        for (int i = 0; i < vector.size(); ++i) {
            DriverInfo driverInfo = (DriverInfo)vector.elementAt(i);
            if (DriverManager.getCallerClass((ClassLoader)object, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
                continue;
            }
            try {
                DriverManager.println("    trying " + driverInfo);
                if (!driverInfo.driver.acceptsURL(string)) continue;
                DriverManager.println("getDriver returning " + driverInfo);
                return driverInfo.driver;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        if (!initialized) {
            DriverManager.initialize();
        }
        DriverInfo driverInfo = new DriverInfo();
        driverInfo.driver = driver;
        driverInfo.driverClass = driver.getClass();
        driverInfo.driverClassName = driverInfo.driverClass.getName();
        writeDrivers.addElement(driverInfo);
        DriverManager.println("registerDriver: " + driverInfo);
        ExtendedSystem.setJVMUnresettableConditionally((int)131073, (String)new String("Modified drivers in DriverManager.registerDriver()"));
        readDrivers = (Vector)writeDrivers.clone();
    }

    public static synchronized void deregisterDriver(Driver driver) throws SQLException {
        int n;
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo driverInfo = null;
        for (n = 0; n < writeDrivers.size(); ++n) {
            driverInfo = (DriverInfo)writeDrivers.elementAt(n);
            if (driverInfo.driver == driver) break;
        }
        if (n >= writeDrivers.size()) {
            DriverManager.println("    couldn't find driver to unload");
            return;
        }
        if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
            throw new SecurityException();
        }
        writeDrivers.removeElementAt(n);
        readDrivers = (Vector)writeDrivers.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getDrivers() {
        Vector<Driver> vector = new Vector<Driver>();
        Vector vector2 = null;
        if (!initialized) {
            DriverManager.initialize();
        }
        Object object = DriverManager.class;
        synchronized (object) {
            vector2 = readDrivers;
        }
        object = DriverManager.getCallerClassLoader();
        for (int i = 0; i < vector2.size(); ++i) {
            DriverInfo driverInfo = (DriverInfo)vector2.elementAt(i);
            if (DriverManager.getCallerClass((ClassLoader)object, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
                continue;
            }
            vector.addElement(driverInfo.driver);
        }
        return vector.elements();
    }

    public static void setLoginTimeout(int n) {
        loginTimeout = n;
        ExtendedSystem.setJVMUnresettableConditionally((int)131073, (String)new String("Modified loginTimeout in DriverManager.setLoginTimeout()"));
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static synchronized void setLogStream(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = printStream;
        logWriter = printStream != null ? new PrintWriter(printStream) : null;
        ExtendedSystem.setJVMUnresettableConditionally((int)131073, (String)new String("Modified logStream in DriverManager.setLogStream()"));
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String string) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(string);
                logWriter.flush();
            }
        }
    }

    private static Class getCallerClass(ClassLoader classLoader, String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (Exception exception) {
            clazz = null;
        }
        return clazz;
    }

    private static void loadInitialDrivers() {
        String string;
        try {
            string = AccessController.doPrivileged(new GetPropertyAction("jdbc.drivers"));
        }
        catch (Exception exception) {
            string = null;
        }
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + string);
        if (string == null) {
            return;
        }
        while (string.length() != 0) {
            String string2;
            int n = string.indexOf(58);
            if (n < 0) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            if (string2.length() == 0) continue;
            try {
                DriverManager.println("DriverManager.Initialize: loading " + string2);
                Class.forName(string2, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                DriverManager.println("DriverManager.Initialize: load failed: " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnection(String string, Properties properties, ClassLoader classLoader) throws SQLException {
        Vector vector = null;
        if (string == null) {
            throw new SQLException("The url cannot be null", "08001");
        }
        DriverManager.println("DriverManager.getConnection(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        Serializable serializable = DriverManager.class;
        synchronized (serializable) {
            vector = readDrivers;
        }
        serializable = null;
        for (int i = 0; i < vector.size(); ++i) {
            DriverInfo driverInfo = (DriverInfo)vector.elementAt(i);
            if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
                continue;
            }
            try {
                DriverManager.println("    trying " + driverInfo);
                Connection connection = driverInfo.driver.connect(string, properties);
                if (connection == null) continue;
                DriverManager.println("getConnection returning " + driverInfo);
                return connection;
            }
            catch (SQLException sQLException) {
                if (serializable != null) continue;
                serializable = sQLException;
            }
        }
        if (serializable != null) {
            DriverManager.println("getConnection failed: " + serializable);
            throw serializable;
        }
        DriverManager.println("getConnection: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
    }

    private DriverManager() {
    }

    private static native ClassLoader getCallerClassLoader();
}

