/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    private String prefix;
    private static String args;
    private static Handler ch;
    private static Logger tl;
    public static final long TYPE_NONE = 0L;
    public static final long TYPE_ALL = -1L;
    public static final long TYPE_INFO = 1L;
    public static final long TYPE_INFORMATION = 1L;
    public static final long TYPE_WARN = 2L;
    public static final long TYPE_WARNING = 2L;
    public static final long TYPE_ERR = 4L;
    public static final long TYPE_ERROR = 4L;
    public static final long TYPE_FATAL = 8L;
    public static final long TYPE_DEFAULT_MESSAGE = 15L;
    public static final long TYPE_API = 16L;
    public static final long TYPE_CALLBACK = 32L;
    public static final long TYPE_ENTRY_EXIT = 64L;
    public static final long TYPE_ENTRY = 128L;
    public static final long TYPE_EXIT = 256L;
    public static final long TYPE_ERROR_EXC = 512L;
    public static final long TYPE_MISC_DATA = 1024L;
    public static final long TYPE_OBJ_CREATE = 2048L;
    public static final long TYPE_OBJ_DELETE = 4096L;
    public static final long TYPE_PRIVATE = 8192L;
    public static final long TYPE_PUBLIC = 16384L;
    public static final long TYPE_STATIC = 32768L;
    public static final long TYPE_SVC = 65536L;
    public static final long TYPE_PERF = 131072L;
    public static final long TYPE_LEVEL1 = 262144L;
    public static final long TYPE_LEVEL2 = 524288L;
    public static final long TYPE_LEVEL3 = 0x100000L;

    public Debug(String string, String string2) {
        if (tl == null) {
            tl = Logger.getLogger(string);
            ch = new ConsoleHandler();
            tl.addHandler(ch);
            tl.setLevel(Level.ALL);
            ch.setLevel(Level.ALL);
        }
    }

    public static void Help() {
        System.err.println();
        System.err.println("all       turn on all debugging");
        System.err.println("access    print all checkPermission results");
        System.err.println("jar       jar verification");
        System.err.println("policy    loading and granting");
        System.err.println("scl       permissions SecureClassLoader assigns");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack     include stack trace");
        System.err.println("domain    dumps all domains in context");
        System.err.println("failure   before throwing exception, dump stack");
        System.err.println("          and domain that didn't have permission");
        System.err.println();
        System.exit(0);
    }

    public static Debug getInstance(String string) {
        return Debug.getInstance(string, string);
    }

    public static Debug getInstance(String string, String string2) {
        if (Debug.isOn(string)) {
            return new Debug("com.ibm.misc.Debug", null);
        }
        return null;
    }

    public static boolean isOn(String string) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(string) != -1;
    }

    private String getParms(Object[] objectArray) {
        String string = " ";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + objectArray[i].toString() + " ";
        }
        return string;
    }

    public void data(long l, Object object, String string, byte[] byArray) {
        Object[] objectArray = new Object[]{byArray};
        tl.log(Level.FINER, (String)object + " " + string, objectArray);
    }

    public void entry(long l, Object object, String string) {
        tl.entering((String)object, string);
    }

    public void entry(long l, Object object, String string, Object object2) {
        Object[] objectArray = new Object[]{object2};
        tl.entering((String)object, string, objectArray);
    }

    public void entry(long l, Object object, String string, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        tl.entering((String)object, string, objectArray);
    }

    public void entry(long l, Object object, String string, Object[] objectArray) {
        tl.entering((String)object, string, objectArray);
    }

    public void exception(long l, Object object, String string, Throwable throwable) {
        tl.log(Level.FINER, (String)object + " " + string, throwable);
    }

    public void exit(long l, Object object, String string) {
        tl.exiting((String)object, string);
    }

    public void exit(long l, Object object, String string, byte by) {
        tl.exiting((String)object, string, new Byte(by));
    }

    public void exit(long l, Object object, String string, short s) {
        tl.exiting((String)object, string, new Short(s));
    }

    public void exit(long l, Object object, String string, int n) {
        tl.exiting((String)object, string, new Integer(n));
    }

    public void exit(long l, Object object, String string, long l2) {
        tl.exiting((String)object, string, new Long(l2));
    }

    public void exit(long l, Object object, String string, float f) {
        tl.exiting((String)object, string, new Float(f));
    }

    public void exit(long l, Object object, String string, double d) {
        tl.exiting((String)object, string, new Double(d));
    }

    public void exit(long l, Object object, String string, char c) {
        tl.exiting((String)object, string, new Character(c));
    }

    public void exit(long l, Object object, String string, boolean bl) {
        tl.exiting((String)object, string, new Boolean(bl));
    }

    public void exit(long l, Object object, String string, Object object2) {
        tl.exiting((String)object, string, object2);
    }

    public void stackTrace(long l, Object object, String string) {
        StringWriter stringWriter = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(stringWriter));
        tl.logp(Level.FINER, (String)object, string, stringWriter.toString());
    }

    public void stackTrace(long l, Object object, String string, String string2) {
        StringWriter stringWriter = new StringWriter();
        new Throwable(string2).printStackTrace(new PrintWriter(stringWriter));
        Object[] objectArray = new Object[]{stringWriter.toString()};
        tl.logp(Level.FINER, (String)object, string, string2, objectArray);
    }

    public void text(long l, Object object, String string, String string2) {
        tl.logp(Level.FINER, (String)object, string, string2);
    }

    public void text(long l, Object object, String string, String string2, Object object2) {
        Object[] objectArray = new Object[]{object2};
        tl.logp(Level.FINER, (String)object, string, string2, objectArray);
    }

    public void text(long l, Object object, String string, String string2, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        tl.logp(Level.FINER, (String)object, string, string2, objectArray);
    }

    public void text(long l, Object object, String string, String string2, Object[] objectArray) {
        tl.logp(Level.FINER, (String)object, string, string2, objectArray);
    }

    static {
        ch = null;
        tl = null;
        args = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.auth.debug");
            }
        });
        args = args == null ? string : args + "," + string;
        if (args != null && (args = args.toLowerCase()).equals("help")) {
            Debug.Help();
        }
    }
}

