/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.BasicPFX;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.CrlBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedChars;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PFX
extends BasicPFX
implements Cloneable {
    private Cipher cipher;
    private Vector unprotectedBags = new Vector();
    private Vector protectedBags = new Vector();
    SmudgedChars savedPasswd = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PFX";

    public PFX() {
        if (debug != null) {
            debug.entry(16384L, className, "PFX");
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PFX", string);
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PFX", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "PFX", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "PFX", objectArray);
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PFX", objectArray);
            debug.exit(16384L, className, "PFX");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            PFX pFX = new PFX(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", pFX);
            }
            return pFX;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public synchronized void addCertificate(Certificate certificate, String string, byte[] byArray) throws PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, string, byArray};
            debug.entry(16384L, (Object)className, "addCertificate", objectArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "addCertificate", "Certificate must be specified.");
            }
            throw new PKCSException("Certificate must be specified.");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addCertificate", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        objectArray = new CertBag(certificate, this.provider);
        this.addInfo((Bag)objectArray, string, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "addCertificate");
        }
    }

    public synchronized void addPrivateKey(PrivateKey privateKey, String string, byte[] byArray) throws PKCSException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{privateKey, string, byArray};
            debug.entry(16384L, (Object)className, "addPrivateKey", objectArray);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "addPrivateKey", "Private key must be specified.");
            }
            throw new PKCSException("Private key must be specified.");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addPrivateKey", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        objectArray = new PrivateKeyInfo(privateKey.getEncoded(), this.provider);
        KeyBag keyBag = new KeyBag((PrivateKeyInfo)objectArray, this.provider);
        this.addInfo(keyBag, string, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "addPrivateKey");
        }
    }

    public synchronized void addShroudedKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, String string, byte[] byArray) throws PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{encryptedPrivateKeyInfo, string, byArray};
            debug.entry(16384L, (Object)className, "addShroudedKey", objectArray);
        }
        if (encryptedPrivateKeyInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "addShroudedKey", "Shrouded key must be specified.");
            }
            throw new PKCSException("Shrouded key must be specified.");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addShroudedKey", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        objectArray = new ShroudedKeyBag(encryptedPrivateKeyInfo, this.provider);
        this.addInfo((Bag)objectArray, string, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "addShroudedKey");
        }
    }

    public synchronized void addCRL(CRL cRL, String string, byte[] byArray) throws PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cRL, string, byArray};
            debug.entry(16384L, (Object)className, "addCRL", objectArray);
        }
        if (cRL == null) {
            if (debug != null) {
                debug.text(16384L, className, "addCRL", "CRL must be specified.");
            }
            throw new PKCSException("CRL must be specified.");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addCRL", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        objectArray = new CrlBag(cRL, this.provider);
        this.addInfo((Bag)objectArray, string, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "addCRL");
        }
    }

    public synchronized void protect(String string, char[] cArray) throws NoSuchAlgorithmException, IOException, PKCSException {
        int n;
        if (debug != null) {
            debug.entry(16384L, className, "protect", string, cArray);
        }
        if (cArray == null || cArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "protect", "Password must be specified.");
            }
            throw new PKCSException("Password must be specified.");
        }
        if (this.getSavedPassword() != null) {
            boolean bl = false;
            if (this.getSavedPassword().length != cArray.length) {
                bl = true;
            } else {
                char[] cArray2 = this.getSavedPassword();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray2[i] == cArray[i]) continue;
                    bl = true;
                    break;
                }
                Arrays.fill(cArray2, ' ');
            }
            if (bl) {
                for (int i = 0; i < this.protectedBags.size(); ++i) {
                    this.unprotectedBags.add(this.protectedBags.elementAt(i));
                }
                this.protectedBags.clear();
                this.authSafeContents = null;
            }
        }
        if (this.unprotectedBags.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "protect_1");
            }
            return;
        }
        SafeBag[] safeBagArray = new SafeBag[this.unprotectedBags.size()];
        for (n = 0; n < this.unprotectedBags.size(); ++n) {
            safeBagArray[n] = (SafeBag)this.unprotectedBags.elementAt(n);
        }
        super.addSafeBagsWithPasswordPrivacy(safeBagArray, string, cArray);
        for (n = 0; n < this.unprotectedBags.size(); ++n) {
            this.protectedBags.add(this.unprotectedBags.elementAt(n));
        }
        this.unprotectedBags.clear();
        super.applyMac(cArray, 1);
        this.setSavedPassword((char[])cArray.clone());
        if (debug != null) {
            debug.exit(16384L, className, "protect_2");
        }
    }

    public PrivateKeyInfo[] getPrivateKeys(char[] cArray) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getPrivateKeys", (Object)cArray);
            debug.exit(16384L, (Object)className, "getPrivateKeys", super.getPrivateKeys(cArray, null, null, false));
        }
        return super.getPrivateKeys(cArray, null, null, false);
    }

    public EncryptedPrivateKeyInfo[] getShroudedKeys(char[] cArray) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getShroudedKeys", (Object)cArray);
            debug.exit(16384L, (Object)className, "getShroudedKeys", super.getShroudedKeys(cArray, null, null, false));
        }
        return super.getShroudedKeys(cArray, null, null, false);
    }

    public Certificate[] getCertificates(char[] cArray) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertificates", (Object)cArray);
            debug.exit(16384L, (Object)className, "getCertificates", super.getCertificates(cArray, null, null, false));
        }
        return super.getCertificates(cArray, null, null, false);
    }

    public CRL[] getCRLs(char[] cArray) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCRLs", (Object)cArray);
            debug.exit(16384L, (Object)className, "getCRLs", super.getCRLs(cArray, null, null, false));
        }
        return super.getCRLs(cArray, null, null, false);
    }

    public String[] getFriendlyNames(char[] cArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getFriendlyNames", (Object)cArray);
            debug.exit(16384L, (Object)className, "getFriendlyNames", super.getFriendlyNames(cArray));
        }
        return super.getFriendlyNames(cArray);
    }

    public Certificate[] getCertificatesByFriendlyName(char[] cArray, String string) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByFriendlyName", cArray, string);
            debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName", super.getCertificatesByFriendlyName(cArray, string));
        }
        return super.getCertificatesByFriendlyName(cArray, string);
    }

    public PrivateKeyInfo[] getPrivateKeysByFriendlyName(char[] cArray, String string) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKeysByFriendlyName", cArray, string);
            debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName", super.getPrivateKeysByFriendlyName(cArray, string));
        }
        return super.getPrivateKeysByFriendlyName(cArray, string);
    }

    public EncryptedPrivateKeyInfo[] getShroudedKeysByFriendlyName(char[] cArray, String string) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByFriendlyName", cArray, string);
            debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName", super.getShroudedKeysByFriendlyName(cArray, string));
        }
        return super.getShroudedKeysByFriendlyName(cArray, string);
    }

    public byte[][] getAllLocalKeyIds(char[] cArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAllLocalKeyIds", (Object)cArray);
            debug.exit(16384L, (Object)className, "getAllLocalKeyIds", super.getAllLocalKeyIds(cArray));
        }
        return super.getAllLocalKeyIds(cArray);
    }

    public Certificate[] getCertificatesByLocalKeyId(char[] cArray, byte[] byArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByLocalKeyId", cArray, byArray);
            debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId", super.getCertificatesByLocalKeyId(cArray, byArray));
        }
        return super.getCertificatesByLocalKeyId(cArray, byArray);
    }

    public EncryptedPrivateKeyInfo[] getShroudedKeysByLocalKeyId(char[] cArray, byte[] byArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByLocalKeyId", cArray, byArray);
            debug.exit(16384L, (Object)className, "getShroudedKeysByLocalKeyId", super.getShroudedKeysByLocalKeyId(cArray, byArray));
        }
        return super.getShroudedKeysByLocalKeyId(cArray, byArray);
    }

    public byte[] getLocalKeyIdOfShroudedKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] cArray) throws PKCSException, IOException {
        return super.getLocalKeyIdOfShroudedKey(encryptedPrivateKeyInfo, cArray);
    }

    public byte[] getLocalKeyIdOfPrivateKey(PrivateKeyInfo privateKeyInfo, char[] cArray) throws PKCSException, IOException {
        return super.getLocalKeyIdOfPrivateKey(privateKeyInfo, cArray);
    }

    public String getFriendlyNameOfShroudedKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] cArray) throws PKCSException, IOException {
        return super.getFriendlyNameOfShroudedKey(encryptedPrivateKeyInfo, cArray);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        super.encode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
            debug.exit(16384L, (Object)className, "equals", super.equals(object));
        }
        return super.equals(object);
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString());
        }
        return super.toString();
    }

    public boolean verifyMac(char[] cArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifyMac", (Object)cArray);
            debug.exit(16384L, (Object)className, "verifyMac", super.verifyMac(cArray));
        }
        return super.verifyMac(cArray);
    }

    public MacData getMacData() {
        if (debug != null) {
            debug.entry(16384L, className, "getMacData");
            debug.exit(16384L, (Object)className, "getMacData", super.getMacData());
        }
        return super.getMacData();
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        super.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private synchronized void addInfo(Bag bag, String string, byte[] byArray) throws PKCSException {
        SafeBag safeBag;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{bag, string, byArray};
            debug.entry(16384L, (Object)className, "addInfo", objectArray);
        }
        try {
            objectArray = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, byArray, this.provider);
            PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{objectArray};
            PKCSAttributes pKCSAttributes = new PKCSAttributes(pKCSAttributeArray, this.provider);
            if (string != null && string.length() != 0) {
                pKCSAttributes = pKCSAttributes.addAttribute(new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, string, this.provider));
            }
            safeBag = new SafeBag(bag, pKCSAttributes, this.provider);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "addInfo", iOException);
            }
            throw new PKCSException(iOException, "Unable to add private information (" + iOException.toString() + ")");
        }
        this.unprotectedBags.add(safeBag);
        if (debug != null) {
            debug.exit(16384L, className, "addInfo");
        }
    }

    ContentInfo protectWithPasswordPrivacy(byte[] byArray, String string, String string2, char[] cArray) throws IOException, PKCSException, NoSuchAlgorithmException {
        AlgorithmId algorithmId;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        AlgorithmParameters algorithmParameters = null;
        if (debug != null) {
            object6 = new Object[]{byArray, string, string2, cArray};
            debug.entry(16384L, (Object)className, "protectWithPasswordPrivacy", (Object[])object6);
        }
        if (this.cipher == null) {
            object6 = "PBEWith" + string + "And" + string2;
            object5 = new PBEKeySpec(cArray);
            try {
                object4 = this.provider != null ? SecretKeyFactory.getInstance("PBEWithSha1AndRC2", this.provider) : SecretKeyFactory.getInstance("PBEWithSha1AndRC2");
                object3 = ((SecretKeyFactory)object4).generateSecret((KeySpec)object5);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
                }
                throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
            }
            int n = 8;
            object2 = string2.toUpperCase();
            if (((String)object2).indexOf("DES") != -1) {
                n = 20;
            }
            object = new byte[n];
            SecureRandom secureRandom = null;
            try {
                secureRandom = this.provider != null ? SecureRandom.getInstance("IBMSecureRandom", this.provider) : SecureRandom.getInstance("IBMSecureRandom");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", noSuchAlgorithmException);
                }
                secureRandom = new SecureRandom();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", noSuchProviderException);
                }
                throw new PKCSException(noSuchProviderException, "Provider " + this.provider + " not found");
            }
            secureRandom.nextBytes((byte[])object);
            int n2 = 1;
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec((byte[])object, n2);
            try {
                algorithmParameters = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
                algorithmParameters.init(pBEParameterSpec);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
                }
                throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
            }
            try {
                this.cipher = this.provider != null ? Cipher.getInstance((String)object6, this.provider) : Cipher.getInstance((String)object6);
                this.cipher.init(1, (Key)object3, algorithmParameters);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
                }
                throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
            }
        }
        try {
            object6 = this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
            }
            throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
        }
        object4 = this.cipher.getParameters();
        object3 = null;
        if (object4 != null) {
            object3 = ((AlgorithmParameters)object4).getEncoded();
        }
        try {
            algorithmId = AlgorithmId.get(this.cipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", noSuchAlgorithmException);
            }
            throw new PKCSException(noSuchAlgorithmException, "Unsupported password-based encryption algorithm: " + this.cipher.getAlgorithm());
        }
        if (object3 != null) {
            object2 = algorithmId.getOID();
            object5 = new AlgorithmId((ObjectIdentifier)object2, (byte[])object3, this.provider);
        } else {
            object5 = algorithmId;
        }
        object2 = new EncryptedContentInfo(PKCSOID.DATA_OID, (AlgorithmId)object5, (byte[])object6, this.provider);
        object = new EncryptedData((EncryptedContentInfo)object2, null, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protectWithPasswordPrivacy", new ContentInfo((Content)object, this.provider));
        }
        return new ContentInfo((Content)object, this.provider);
    }

    private void setSavedPassword(char[] cArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSavedPassword", (Object)cArray);
        }
        this.savedPasswd = new SmudgedChars(cArray, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "setSavedPassword");
        }
    }

    private char[] getSavedPassword() {
        if (debug != null) {
            debug.entry(8192L, className, "getSavedPassword");
        }
        if (this.savedPasswd == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getSavedPassword_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getSavedPassword_2", this.savedPasswd.getClearText());
        }
        return this.savedPasswd.getClearText();
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
            debug.exit(16384L, className, "finalize");
        }
        this.savedPasswd = null;
    }
}

