/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.EntityIdentifier;
import com.ibm.security.pkcs7.RecipientIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;

public final class IssuerAndSerialNumber
extends PKCSDerObject
implements RecipientIdentifier,
EntityIdentifier,
Cloneable {
    private X500Name issuer;
    private BigInteger serialNumber;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.IssuerAndSerialNumber";

    public IssuerAndSerialNumber(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", (Object)byArray);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", byArray, string);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X500Name x500Name, BigInteger bigInteger) {
        this(x500Name, bigInteger, null);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", x500Name, bigInteger);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X500Name x500Name, BigInteger bigInteger, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{x500Name, bigInteger, string};
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", objectArray);
        }
        if (x500Name == null) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "issuer not specified.");
            }
            throw new IllegalArgumentException("issuer not specified.");
        }
        if (bigInteger == null) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "serialNumber not specified.");
            }
            throw new IllegalArgumentException("serialNumber not specified.");
        }
        this.issuer = x500Name;
        this.serialNumber = bigInteger;
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X509Certificate x509Certificate) throws IOException {
        this(x509Certificate, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", x509Certificate);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X509Certificate x509Certificate, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", x509Certificate, string);
        }
        if (x509Certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        if (!(x509Certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "Certificate type " + x509Certificate.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
            }
            throw new IllegalArgumentException("Certificate type " + x509Certificate.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
        }
        Principal principal = x509Certificate.getIssuerDN();
        this.issuer = new X500Name(principal.getName());
        this.serialNumber = x509Certificate.getSerialNumber();
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", string, new Boolean(bl));
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", objectArray);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.issuer.encode(derOutputStream);
        derOutputStream.putInteger(this.serialNumber);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "IssuerAndSerialNumber parsing error");
            }
            throw new IOException("IssuerAndSerialNumber parsing error");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.issuer = new X500Name(derValue2);
        this.serialNumber = derValue.getData().getInteger();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof IssuerAndSerialNumber)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((IssuerAndSerialNumber)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public String toString() {
        String string = "";
        string = string + "\tissuer: " + this.issuer;
        string = string + "\r\n\tserialNumber: " + this.serialNumber;
        return string;
    }

    public X500Name getIssuer() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuer");
        }
        if (this.issuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuer", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIssuer", new X500Name(this.issuer.toString()));
        }
        return new X500Name(this.issuer.toString());
    }

    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
            debug.exit(16384L, (Object)className, "getSerialNumber", this.serialNumber);
        }
        return this.serialNumber;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", issuerAndSerialNumber);
            }
            return issuerAndSerialNumber;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }
}

