/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;

public final class PKCS7 {
    String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.PKCS7";

    public PKCS7() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7");
            debug.exit(16384L, className, "PKCS7");
        }
    }

    public PKCS7(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS7", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7");
        }
    }

    public static boolean isData(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isData", string);
            debug.exit(16384L, (Object)className, "isData", new Boolean(string.equals(PKCSOID.DATA_OID.toString())));
        }
        return string.equals(PKCSOID.DATA_OID.toString());
    }

    public static boolean isSignedData(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedData", string);
            debug.exit(16384L, (Object)className, "isSignedData", new Boolean(string.equals(PKCSOID.SIGNED_DATA_OID.toString())));
        }
        return string.equals(PKCSOID.SIGNED_DATA_OID.toString());
    }

    public static boolean isEnvelopedData(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEnvelopedData", string);
            debug.exit(16384L, (Object)className, "isEnvelopedData", new Boolean(string.equals(PKCSOID.ENVELOPED_DATA_OID.toString())));
        }
        return string.equals(PKCSOID.ENVELOPED_DATA_OID.toString());
    }

    public static boolean isSignedAndEnvelopedData(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedAndEnvelopedData", string);
            debug.exit(16384L, (Object)className, "isSignedAndEnvelopedData", new Boolean(string.equals(PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID.toString())));
        }
        return string.equals(PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID.toString());
    }

    public static boolean isDigestedData(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isDigestedData", string);
            debug.exit(16384L, (Object)className, "isDigestedData", new Boolean(string.equals(PKCSOID.DIGESTED_DATA_OID.toString())));
        }
        return string.equals(PKCSOID.DIGESTED_DATA_OID.toString());
    }

    public static boolean isEncryptedData(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEncryptedData", string);
            debug.exit(16384L, (Object)className, "isEncryptedData", new Boolean(string.equals(PKCSOID.ENCRYPTED_DATA_OID.toString())));
        }
        return string.equals(PKCSOID.ENCRYPTED_DATA_OID.toString());
    }

    public static boolean isNetscapeCertSequence(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isNetscapeCertSequence", string);
            debug.exit(16384L, (Object)className, "isNetscapeCertSequence", new Boolean(string.equals(PKCSOID.NETSCAPE_CERT_SEQUENCE_OID.toString())));
        }
        return string.equals(PKCSOID.NETSCAPE_CERT_SEQUENCE_OID.toString());
    }

    public static boolean isData(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isData", objectIdentifier);
            debug.exit(16384L, (Object)className, "isData", new Boolean(PKCS7.isData(objectIdentifier.toString())));
        }
        return PKCS7.isData(objectIdentifier.toString());
    }

    public static boolean isSignedData(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedData", objectIdentifier);
            debug.exit(16384L, (Object)className, "isSignedData", new Boolean(PKCS7.isSignedData(objectIdentifier.toString())));
        }
        return PKCS7.isSignedData(objectIdentifier.toString());
    }

    public static boolean isEnvelopedData(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEnvelopedData", objectIdentifier);
            debug.exit(16384L, (Object)className, "isEnvelopedData", new Boolean(PKCS7.isEnvelopedData(objectIdentifier.toString())));
        }
        return PKCS7.isEnvelopedData(objectIdentifier.toString());
    }

    public static boolean isSignedAndEnvelopedData(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSignedAndEnvelopedData", objectIdentifier);
            debug.exit(16384L, (Object)className, "isSignedAndEnvelopedData", new Boolean(PKCS7.isSignedAndEnvelopedData(objectIdentifier.toString())));
        }
        return PKCS7.isSignedAndEnvelopedData(objectIdentifier.toString());
    }

    public static boolean isDigestedData(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isDigestedData", objectIdentifier);
            debug.exit(16384L, (Object)className, "isDigestedData", new Boolean(PKCS7.isDigestedData(objectIdentifier.toString())));
        }
        return PKCS7.isDigestedData(objectIdentifier.toString());
    }

    public static boolean isEncryptedData(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isEncryptedData", objectIdentifier);
            debug.exit(16384L, (Object)className, "isEncryptedData", new Boolean(PKCS7.isEncryptedData(objectIdentifier.toString())));
        }
        return PKCS7.isEncryptedData(objectIdentifier.toString());
    }

    public static boolean isNetscapeCertSequence(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isNetscapeCertSequence", objectIdentifier);
            debug.exit(16384L, (Object)className, "isNetscapeCertSequence", new Boolean(PKCS7.isNetscapeCertSequence(objectIdentifier.toString())));
        }
        return PKCS7.isNetscapeCertSequence(objectIdentifier.toString());
    }

    public static String getDigestAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        try {
            String string2 = PKCS7.getDigestAlgorithm(algorithmId);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", string2);
            }
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "getDigestAlgorithm", noSuchAlgorithmException);
                debug.text(16384L, className, "getDigestAlgorithm", "Unrecognized algorithm name: " + string + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + string + ".");
        }
    }

    public static String getDigestAlgorithm(String string, String string2) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        try {
            String string3 = PKCS7.getDigestAlgorithm(algorithmId, string2);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", string3);
            }
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "getDigestAlgorithm", noSuchAlgorithmException);
                debug.text(16384L, className, "getDigestAlgorithm", "Unrecognized algorithm name: " + string + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + string + ".");
        }
    }

    public static String getDigestAlgorithm(AlgorithmId algorithmId) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestAlgorithm", algorithmId);
        }
        String string = PKCS7.getDigestAlgorithm(algorithmId, null);
        if (debug != null) {
            debug.text(16384L, className, "getDigestAlgorithm", string);
        }
        return string;
    }

    public static String getDigestAlgorithm(AlgorithmId algorithmId, String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm", algorithmId, string);
        }
        if (algorithmId == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        if (objectIdentifier.equals(AlgorithmId.MD5_oid) || objectIdentifier.equals(AlgorithmId.MD2_oid) || objectIdentifier.equals(AlgorithmId.SHA_oid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm_1", algorithmId.getName());
            }
            return algorithmId.getName();
        }
        String string2 = null;
        if (objectIdentifier.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
            string2 = new AlgorithmId(AlgorithmId.MD5_oid, string).getName();
        } else if (objectIdentifier.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
            string2 = new AlgorithmId(AlgorithmId.MD2_oid, string).getName();
        } else if (objectIdentifier.equals(AlgorithmId.sha1WithDSA_oid)) {
            string2 = new AlgorithmId(AlgorithmId.SHA_oid, string).getName();
        } else if (objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid)) {
            string2 = new AlgorithmId(AlgorithmId.SHA_oid, string).getName();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "getDigestAlgorithm", "Unrecognized algorithm name: " + algorithmId + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + algorithmId + ".");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", string2);
        }
        return string2;
    }

    public static String getSignatureAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignatureAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "getSignatureAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        try {
            String string2 = PKCS7.getSignatureAlgorithm(algorithmId);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignatureAlgorithm", string2);
            }
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSignatureAlgorithm", noSuchAlgorithmException);
                debug.text(16384L, className, "getSignatureAlgorithm", "Unrecognized algorithm name: " + string + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + string + ".");
        }
    }

    public static String getSignatureAlgorithm(AlgorithmId algorithmId) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignatureAlgorithm", algorithmId);
        }
        if (algorithmId == null) {
            if (debug != null) {
                debug.text(16384L, className, "getSignatureAlgorithm", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        String string = null;
        if (!(objectIdentifier.equals(AlgorithmId.RSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.DSA_oid) || objectIdentifier.equals(AlgorithmId.md5WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.md2WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithDSA_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "getSignatureAlgorithm", "Unrecognized algorithm name: " + algorithmId + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized algorithm name: " + algorithmId + ".");
        }
        string = algorithmId.getName();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm", string);
        }
        return string;
    }

    public static String getMACAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getMACAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "getMACAlgorithm", "MAC algorithm must be specified.");
            }
            throw new IllegalArgumentException("MAC algorithm must be specified.");
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        try {
            String string2 = PKCS7.getMACAlgorithm(algorithmId);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMACAlgorithm", string2);
            }
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.text(16384L, className, "getMACAlgorithm", "Unrecognized MAC algorithm name: " + string + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized MAC algorithm name: " + string + ".");
        }
    }

    public static String getMACAlgorithm(AlgorithmId algorithmId) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getMACAlgorithm", algorithmId);
        }
        if (algorithmId == null) {
            if (debug != null) {
                debug.text(16384L, className, "getMACAlgorithm", "MAC algorithm must be specified.");
            }
            throw new IllegalArgumentException("MAC algorithm must be specified.");
        }
        ObjectIdentifier objectIdentifier = algorithmId.getOID();
        if (objectIdentifier.equals(AlgorithmId.HmacSHA1_oid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMACAlgorithm", algorithmId.getName());
            }
            return algorithmId.getName();
        }
        if (debug != null) {
            debug.text(16384L, className, "getMACAlgorithm", "Unrecognized MAC algorithm name: " + algorithmId + ".");
        }
        throw new NoSuchAlgorithmException("Unrecognized MAC algorithm name: " + algorithmId + ".");
    }

    public static String getDigestSignatureAlgorithm(String string, String string2) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestSignatureAlgorithm", string, string2);
        }
        String string3 = PKCS7.getDigestSignatureAlgorithm(string, string2, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", string3);
        }
        return string3;
    }

    public static String getDigestSignatureAlgorithm(String string, String string2, String string3) throws NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, string2, string3};
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", objectArray);
        }
        if (string2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Signature algorithm must be specified.");
        }
        objectArray = AlgorithmId.get(string);
        AlgorithmId algorithmId = AlgorithmId.get(string2);
        try {
            String string4 = PKCS7.getDigestSignatureAlgorithm((AlgorithmId)objectArray, algorithmId, string3);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestSignatureAlgorithm", string4);
            }
            return string4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "getDigestSignatureAlgorithm", noSuchAlgorithmException);
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Unrecognized combination for digest algorithm " + string + " and signature algorithm " + string2 + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized combination for digest algorithm " + string + " and signature algorithm " + string2 + ".");
        }
    }

    public static String getDigestSignatureAlgorithm(AlgorithmId algorithmId, AlgorithmId algorithmId2) throws NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{algorithmId, algorithmId2};
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", objectArray);
        }
        objectArray = PKCS7.getDigestSignatureAlgorithm(algorithmId, algorithmId2, null);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestSignatureAlgorithm", objectArray);
        }
        return objectArray;
    }

    public static String getDigestSignatureAlgorithm(AlgorithmId algorithmId, AlgorithmId algorithmId2, String string) throws NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{algorithmId, algorithmId2, string};
            debug.entry(16384L, (Object)className, "getDigestSignatureAlgorithm", objectArray);
        }
        if (algorithmId2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Signature algorithm must be specified.");
        }
        objectArray = null;
        if (algorithmId != null) {
            objectArray = algorithmId.getOID();
        }
        ObjectIdentifier objectIdentifier = algorithmId2.getOID();
        String string2 = null;
        if (objectArray == null && objectIdentifier.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
            string2 = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, string).getName();
        } else if (objectArray == null && objectIdentifier.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
            string2 = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, string).getName();
        } else if (objectArray == null && objectIdentifier.equals(AlgorithmId.sha1WithDSA_oid)) {
            string2 = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, string).getName();
        } else if (objectArray == null && (objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid))) {
            string2 = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid, string).getName();
        } else if (objectArray != null) {
            if (objectArray.equals(AlgorithmId.MD2_oid) && objectIdentifier.equals(AlgorithmId.RSAEncryption_oid)) {
                string2 = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.MD2_oid) && objectIdentifier.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
                string2 = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.md2WithRSAEncryption_oid) && objectIdentifier.equals(AlgorithmId.md2WithRSAEncryption_oid)) {
                string2 = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.MD5_oid) && objectIdentifier.equals(AlgorithmId.RSAEncryption_oid)) {
                string2 = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.MD5_oid) && objectIdentifier.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
                string2 = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.md5WithRSAEncryption_oid) && objectIdentifier.equals(AlgorithmId.md5WithRSAEncryption_oid)) {
                string2 = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.SHA_oid) && objectIdentifier.equals(AlgorithmId.DSA_oid)) {
                string2 = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.SHA_oid) && objectIdentifier.equals(AlgorithmId.sha1WithDSA_oid)) {
                string2 = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.sha1WithDSA_oid) && objectIdentifier.equals(AlgorithmId.sha1WithDSA_oid)) {
                string2 = new AlgorithmId(AlgorithmId.sha1WithDSA_oid, string).getName();
            } else if (objectArray.equals(AlgorithmId.SHA_oid)) {
                if (objectIdentifier.equals(AlgorithmId.RSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid)) {
                    string2 = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid, string).getName();
                }
            } else if ((objectArray.equals(AlgorithmId.sha1WithRSAEncryption_oid) || objectArray.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid)) && (objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_oid) || objectIdentifier.equals(AlgorithmId.sha1WithRSAEncryption_OIW_oid))) {
                string2 = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid, string).getName();
            }
        }
        if (string2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "getDigestSignatureAlgorithm", "Unrecognized combination for digest algorithm " + algorithmId + " and signature algorithm " + algorithmId2 + ".");
            }
            throw new NoSuchAlgorithmException("Unrecognized combination for digest algorithm " + algorithmId + " and signature algorithm " + algorithmId2 + ".");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestSignatureAlgorithm", string2);
        }
        return string2;
    }

    static byte[] stripOctetTags(byte[] byArray) {
        byte[] byArray2;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "stripOctetTags", byArray);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerInputStream derInputStream = new DerInputStream(byArray);
            while (derInputStream.available() != 0) {
                byte[] byArray3 = derInputStream.getOctetString();
                if (byArray3 == null) continue;
                byteArrayOutputStream.write(byArray3, 0, byArray3.length);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "stripOctetTags", exception);
            }
            byArray2 = byArray;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "stripOctetTags", byArray2);
        }
        return byArray2;
    }
}

